package com.yy.platform.loginlite;


import com.google.protobuf.InvalidProtocolBufferException;
import com.yy.platform.loginlite.proto.CreditLoginReq;
import com.yy.platform.loginlite.proto.CreditLoginRsp;
import com.yy.platform.loginlite.proto.Errcode;
import com.yy.platform.loginlite.proto.ProtoHeader;
import com.yy.platform.loginlite.utils.CodeUtils;
import com.yy.platform.loginlite.utils.EventTypeUtils;
import com.yy.platform.loginlite.utils.ThreadManager;
import com.yy.platform.loginlite.utils.UserInfoUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import okhttp3.Call;

/**
 * Created by chenkaicai on 2019/7/11.
 */

public class CreditLoginByOkhttp extends BaseOkHttp {

    private String path;
    private Map<String, String> map = new HashMap<String, String>();
    private long yyuid;
    private long startTime;
    private Lock callbackLock;
    private CreditLoginReq creditLoginReq;

    private ICreditLoginCallback callback;
    private int timeout;
    private static final String fun = "CreditLogin ";
    private long bTime;
    private int httpResult;

    public CreditLoginByOkhttp(
            int timeout, long sTime, long yyuid, ProtoHeader header, ICreditLoginCallback callback
    ) {
        this.yyuid = yyuid;
        this.callback = callback;
        this.callbackLock = new ReentrantLock();
        this.startTime = sTime;
        this.timeout = timeout;

        String credit = AuthInfo.getCredit(yyuid);
        if (credit == null) {
            credit = "";
        }
        creditLoginReq = CreditLoginReq.newBuilder()
                .setUser(String.valueOf(yyuid))
                .setCredit(credit)
                .setPrheader(header)
                .build();

        path = "UdbApp.LoginServer.LoginObj/LoginByCredit";
        map.put("Context", "creditLogin");
        map.put("AppId", AuthInfo.getAppId());
        map.put("Uid", String.valueOf(yyuid));
        map.put("ServiceName", "UdbApp.LoginServer.LoginObj");
        map.put("FunctionName", "LoginByCredit");
        map.put("ProtoType", "http");
//        map.put("InstId", "creditLogin");
//        map.put("ServerId", "creditLogin");

        tag = fun + "yyuid:" + yyuid + ", ";
    }

    public void execute() {
        bTime = System.currentTimeMillis();
        executeInner(path, map, creditLoginReq.toByteArray(), timeout);
    }

    @Override
    public void onSuccess(Call call, byte[] data, int httpCode, long useTime) {
        CreditLoginRsp res;
        try {
            res = CreditLoginRsp.parseFrom(data);
        } catch (InvalidProtocolBufferException e) {
            String msg = e.getMessage();
            httpResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
            String errInfo = fun + "IOException:" + msg + ", code: " + httpCode;
            ALog.i(errInfo);
            int code = CodeUtils.makeCode(httpCode, CodeUtils.creditLogin);
            onCreditLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, code, msg);
            return;
        }

        ALog.i(fun + "success,uid=" + yyuid +
                ",authSrvCode:" + res.getErrcode() + ", authSrvDesc:" + res.getDescription());

        if (res.getErrcode() == Errcode.SUCCESS) {
            final long eTime = System.currentTimeMillis();
            if (bTime > 0) {
                long reportStart = System.currentTimeMillis();
                CHidoReport.CReportResponse report = new CHidoReport.CReportResponse();
                report.mRtt = eTime - bTime;
                report.mEventType = getEventType();
                report.mSucceed = 0;
                report.mErrType = 0;
                report.mErrCode = 0;
                report.mTraceId = traceId;
                report.mChannel = ChannelName.HTTP;
                report.mUserInfo = String.valueOf(yyuid);

                report.mTotalRtt = eTime - startTime;

                CHidoReport.getInstance().report2Hido(report);
                CHidoReport.getInstance().report2Metric(report);
                ALog.e(fun + "report success time: " +
                        (System.currentTimeMillis() - reportStart));
            }

            final YYInfo info = new YYInfo();
            UserInfoUtils.unPack(res.getUserData(), info);
            //单位s
            info.mTS = res.getServerTime();
            info.mIsNewUser = false;
            info.mUrl = res.getUrl();
            info.extjsstr = res.getExtjsstr();
            AuthInfo.saveAuth(info.mUid, info.mCredit, info.mTS * 1000, info.st);

            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    onSuccess(0, info);
                    AntiHelper.checkAntiCodeHw(info.mUid);
                }
            });
        } else {
            httpResult = (CHidoReport.QuicResult.AUTH_ERROR);
            onCreditLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE,
                    res.getErrcodeValue(), res.getDescription());
        }
    }

    private String getEventType() {
        return compose(EventTypeUtils.creditLogin);
    }

    @Override
    public void onFail(int code, String message, long useTime) {
        httpResult = (CHidoReport.QuicResult.AUTH_ERROR);
        int busiCode = CodeUtils.makeCode(code, CodeUtils.creditLogin);
        ALog.i(fun + "response fail, code: " + code + ", business code: " + busiCode);
        onCreditLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, busiCode, message);
    }

    @Override
    public void onHttpFail(int code, String message, long useTime) {
        httpResult = (CHidoReport.QuicResult.CONNECT_ERROR);
        int busiCode = CodeUtils.makeCode(code, CodeUtils.creditLogin);
        ALog.i(fun + "http fail, code: " + code + ", business code: " + busiCode);
        onCreditLoginFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, busiCode, message);
    }

    private void onCreditLoginFailed(long bTime, final int errType, final int errCode,
                                     final String description) {
        final long eTime = System.currentTimeMillis();
        if (bTime > 0) {
            long reportStart = System.currentTimeMillis();
            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
            response.mRtt = eTime - bTime;
            response.mEventType = getEventType();
            response.mSucceed = 2;
            response.mErrType = errType + 1;
            response.mErrCode = errCode;
            response.mErrDesc = description;
            response.mTraceId = traceId;
            response.mChannel = ChannelName.HTTP;
            response.mUserInfo = String.valueOf(yyuid);
            response.mTotalRtt = eTime - startTime;

            CHidoReport.getInstance().report2Hido(response);
            CHidoReport.getInstance().report2Metric(response);
            ALog.e(fun + "report fail time: " + (System.currentTimeMillis() - reportStart));
        }
        ThreadManager.executeOnMainThread(new Runnable() {
            @Override
            public void run() {
                onFail(-1, errType, errCode, description);
            }
        });
    }

    private void onSuccess(int requestId, YYInfo uinfo) {
        callbackLock.lock();
        if (callback != null) {
            callback.onSuccess(requestId, uinfo);
        }
        callback = null;
        callbackLock.unlock();
    }


    private void onNext(int requestId, NextVerify dynVerify) {
        callbackLock.lock();
        if (callback != null) {
            callback.onNext(requestId, dynVerify);
        }
        callback = null;
        callbackLock.unlock();
    }


    private void onFail(int requestId, int codeType, int resCode, String resDesc) {
        callbackLock.lock();
        if (callback != null) {
            callback.onFail(requestId, codeType, resCode, resDesc);
        }
        callback = null;
        callbackLock.unlock();
    }
}
