package com.yy.platform.loginlite;

import android.os.Handler;
import android.os.Looper;


import java.util.ArrayList;
import java.util.List;

public class CallbackProxy<T> {

    public static final int SUCCESS = 1;
    public static final int FAIL = -1;

    protected T callback;
    protected int count = 0;
    private Handler handler;
    private int successCount = 0;
    protected int failCount = 0;
    private volatile boolean isSuccess = false;
    private volatile boolean isFail = false;
    private volatile boolean isNext = false;
    protected final static int time = 500;
    private volatile boolean isReportSuccess = false;
    private volatile List<CHidoReport.CReportResponse> failList;
    private Object lock = new Object();
    private Object faillock = new Object();
    private volatile int httpResult = 0;
    private volatile int quicResult = 0;

    public CallbackProxy(T callback) {
        this.callback = callback;
        failList = new ArrayList<>();
    }

    public void increUseCount() {
        count = count + 1;
        successCount = successCount + 1;
        failCount = failCount + 1;
        if (count > 1) {
            handler = new Handler(Looper.getMainLooper());
        }
    }

    public void setHttpResult(boolean isSuccess) {
        httpResult = isSuccess ? SUCCESS : FAIL;
    }

    public void setQuicResult(boolean isSuccess) {
        quicResult = isSuccess ? SUCCESS : FAIL;
    }

    public void reportSuccess(CHidoReport.CReportResponse response) {
        if (count == 1) {
            ALog.i("CHidoReport one success");
            response.mEventType = response.mEventType + "/" + response.mChannel;
            report(response);
        } else {
            synchronized (lock) {
                if (isReportSuccess) {
                    return;
                }
                ALog.i("CHidoReport multi success");
                isReportSuccess = true;
                response.mEventType = response.mEventType + "/m" + response.mChannel;
                report(response);
            }
        }
    }

    public void addFailResponse(CHidoReport.CReportResponse response) {
        if (count == 1) {
            ALog.i("CHidoReport one fail");
            response.mEventType = response.mEventType + "/" + response.mChannel;
            report(response);
        } else {
            synchronized (faillock) {
                failList.add(response);
            }
        }
    }

    public void reportFail() {
        if (count > 1 && failList.size() > 0) {
            ALog.i("CHidoReport multi fail");
            int size = failList.size();
            int choice = 0;
            for (int i = 1; i < size; i++) {
                choice = failList.get(choice).mTotalRtt > failList.get(i).mTotalRtt ? i : choice;
            }
            CHidoReport.CReportResponse response = failList.get(choice);
            response.mEventType = response.mEventType + "/m" + response.mChannel;
            report(response);

            failList.clear();
        }
    }

    private void report(CHidoReport.CReportResponse response) {
        CHidoReport.getInstance().report2Hido(response);
        CHidoReport.getInstance().report2Metric(response);
    }

    public boolean isSuccess() {
        return isSuccess;
    }

    public void setSuccess(boolean flag) {
        this.isSuccess = flag;
    }

    public boolean isNext() {
        return isNext;
    }

    public void setNext(boolean flag) {
        isNext = flag;
    }

    public boolean isFail() {
        return isFail;
    }

    public void setFail(boolean flag) {
        this.isFail = flag;
    }

    public void postDelay(Runnable runnable, long time) {
        if (handler != null && runnable != null && time >= 0) {
            handler.postDelayed(runnable, time);
        } else {
            ALog.i("post delay fail,please check");
        }
    }

    public void clearHandler() {
        if (handler != null) {
            handler.removeCallbacksAndMessages(null);
        }
    }
}
