package com.yy.platform.loginlite;

import com.yy.platform.loginlite.utils.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by chenkaicai on 2018/10/24.
 */

public class CHidoReport {

    public static final String sep = "/";

    public final static class CReportResponse {
        public static String mAppId = "";
        public static String mAppKey = "";

        public static int mSys = 0;

        public static String mDevice = "";
        public static String mOS = "";

        public long mRtt = 0;
        public String mEventType = "";
        public int mErrCode = 0;
        public int mErrType = 0;
        public String mErrDesc = "";
        public int mSucceed = 0;
        public int mNetOptimize = -1;
        public String mTraceId = "";
        public String mChannel = "";
        public String mUserInfo = "";
        public int mQuicResult = QuicResult.DISABLE_QUIC;
        public long mTotalRtt = 0;
    }

    private static CHidoReport sInstance = null;
    private ILoginliteListener.ILoginliteHiidoMetricsStatisApi mMetricsReport = null;

    public static synchronized CHidoReport getInstance() {
        if (sInstance == null) {
            sInstance = new CHidoReport();
        }

        return sInstance;
    }

    public void setHiidoMetricsStatisApi(ILoginliteListener.ILoginliteHiidoMetricsStatisApi metricsReport) {
        mMetricsReport = metricsReport;
    }

    public void report2Hido(CReportResponse response) {
        if (mMetricsReport == null || response == null) {
            ALog.i("ILoginliteHiidoMetricsStatisApi or response is null");
            return;
        }
        String message = StringUtils.substring(response.mErrDesc, 200) +
                BaseOkHttp.getExtra();
        BaseOkHttp.clearExtra();

        Map<String, Integer> intFields = new HashMap<>();
        intFields.put("errcode_type", response.mErrType);
        intFields.put("errcode", response.mErrCode);
        intFields.put("succeed", response.mSucceed);
        intFields.put("sys", CReportResponse.mSys);
        intFields.put("no", response.mNetOptimize);

        intFields.put("ab", AuthInfo.getABTest());
        int nt = AuthCore.sNetWorkReceiver.checkCurrentNetwork();
        int ns = AuthCore.sNetWorkReceiver.getNetWorkState();
        intFields.put("nt", nt);
        intFields.put("ns", ns);
        intFields.put("ncn", AuthCore.sNetWorkReceiver.getNetworkChangedCount());
        intFields.put("qr", response.mQuicResult);

        final long realt = System.currentTimeMillis() / 1000;
        Map<String, Long> longFields = new HashMap<>();
        longFields.put("expend_time", Long.valueOf(response.mRtt));
        longFields.put("nct", AuthCore.sNetWorkReceiver.getLastNetworkChangedTs());
        longFields.put("rdt", realt);
        longFields.put("total_time", response.mTotalRtt);

        Map<String, String> stringFields = new HashMap<>();
        stringFields.put("appkey", CReportResponse.mAppKey);
        stringFields.put("appId", CReportResponse.mAppId);
        stringFields.put("event_type", response.mEventType);
//        ErrorDesc上报了乱码，不上报了
        stringFields.put("errcode_desc", message);
        stringFields.put("sdkver", AuthInfo.getSdkVersion());
        stringFields.put("tid", response.mTraceId);
        stringFields.put("appver", AuthInfo.getAppVer());
        stringFields.put("channel", response.mChannel);
        stringFields.put("os", response.mOS);
        stringFields.put("model", response.mDevice);
        stringFields.put("uinfo", response.mUserInfo);

        ALog.i("report hiido,errType=" + response.mErrType
                + ",errCode=" + response.mErrCode + ",abTest=" + AuthInfo.getABTest()
                + ",quicCode=" + response.mQuicResult + ",rtt=" + response.mRtt + ",tRtt=" + response.mTotalRtt
                + ",netType=" + nt + ",netState=" + ns
                + ",netChangedCount=" + AuthCore.sNetWorkReceiver.getNetworkChangedCount()
                + ",netChanngetLastTS=" + AuthCore.sNetWorkReceiver.getLastNetworkChangedTs()
                + ",desc=" + message);

        mMetricsReport.reportStatisticContentTemporary("yyloginlite", intFields, longFields, stringFields);
    }

    public void report2Metric(CReportResponse response) {
        if (mMetricsReport == null || response == null) {
            ALog.i("ILoginliteHiidoMetricsStatisApi or response is null");
            return;
        }
        String uri = response.mAppId + sep + response.mEventType;
//        AuthCore.sNetWorkReceiver.checkCurrentNetwork();
//        int ns = AuthCore.sNetWorkReceiver.getNetWorkState();
//        if (ns != NetworkInfo.State.CONNECTED.ordinal()) {
//            ALog.i("not network connected:" + ns);
//            return;
//        }
        long rtt = response.mRtt;
        if (response.mSucceed != 0) {
            rtt = 0;
        }
        ALog.i("report metrics,eventType=" + uri + ",errCode=" + response.mErrCode +
                ",rtt=" + rtt + ",iRtt=" + response.mRtt + ",channel=" + response.mChannel);
        mMetricsReport.reportReturnCode(50190, uri, rtt, String.valueOf(response.mErrCode));
    }

    public static final class QuicResult {
        public final static int DISABLE_QUIC = -2;
        public final static int ENABLE_QUIC = -1;
        public final static int SUCCESS = 0;
        public final static int ONGOING = 1;
        public final static int CONNECT_IO_EXCEPTION = 2;
        public final static int RESPONSE_ERROR = 3;
        public final static int CONNECT_ERROR = 4;
        public final static int TIMEOUT = 5;
        public final static int RESPONSE_IO_EXCEPTION = 6;
        public final static int AUTH_ERROR = 7;
        public final static int AUTH_CONTINUE = 8;
    }

}
