//package com.yy.platform.loginlite;
//
//import com.yy.platform.loginlite.proto.ThirdloginReq;
//import com.yy.platform.loginlite.proto.ThirdloginRsp;
//import com.yy.platform.loginlite.utils.NetworkUtil;
//import com.yy.platform.loginlite.utils.ServiceUrls;
//import com.yy.platform.loginlite.utils.ThirdInfoUtils;
//import com.yy.platform.loginlite.utils.ThreadManager;
//import org.json.JSONObject;
//
//import java.io.InputStream;
//import java.util.HashMap;
//import java.util.UUID;
//import java.util.concurrent.locks.Lock;
//import java.util.concurrent.locks.ReentrantLock;
//
///**
// * Created by chenkaicai on 2019/7/10.
// */
//
//public class BindThirdTokenQuic implements IThirdLoginCallback {
//
//    private String channel;
//    private String token;
//    private int tokenType;
//    private String openid;
//    private String authUrl;
//    private String extInfo;
//    private String uid;
//    private String optToken;
//    IThirdLoginCallback callback;
//    private IQuicHandler quicHttp;
//    private int quicResult = CHidoReport.QuicResult.ENABLE_QUIC;
//    private String traceId = "";
//    private static final String fun = "BindThirdUserByUid using quic ";
//
//    public int getQuicResult() {
//        return quicResult;
//    }
//
//    private long startTime;
//    private boolean isTimeout = false;
//    private Lock callbackLock;
//
//    public BindThirdTokenQuic(
//            IQuicHandler handler,
//            long sTime,
//            String channel,
//            String token,
//            int tokenType,
//            String openid,
//            String uid,
//            String optToken,
//            String authUrl,
//            String extInfo,
//            IThirdLoginCallback callback
//    ) {
//        this.quicHttp = handler;
//        this.channel = channel;
//        this.token = token;
//        this.tokenType = tokenType;
//        this.openid = openid;
//        this.authUrl = authUrl;
//        this.extInfo = extInfo;
//        this.uid = uid;
//        this.optToken = optToken;
//        this.callback = callback;
//        this.callbackLock = new ReentrantLock();
//        this.startTime = sTime;
//    }
//
//    public int run() {
//        long bTime = System.currentTimeMillis();
//        quicResult = (CHidoReport.QuicResult.ONGOING);
//
//        ThirdloginReq thirdLoginReq = ThirdloginReq.newBuilder()
//                .setVersion(1)
//                .setAppid(AuthInfo.getHeader().getAppId())
//                .setChannel(channel)
//                .setToken(token)
//                .setTokenType(tokenType)
//                .setOpenid(openid)
//                .setUid(uid)
//                .setOptToken(optToken)
//                .setAuthUrl(authUrl)
//                .setDeviceid(AuthInfo.getHeader().getDeviceId())
//                .setClientSys(AuthInfo.getHeader().getSys())
//                .setExtInfo(extInfo)
//                .setRegion(AuthInfo.getHeader().getRegion())
//                .build();
//
//        traceId = UUID.randomUUID().toString();
//        String url = ServiceUrls.getQuitUrl() + "UdbApp.ThirdloginServer.ThirdloginObj/BindThirdUserByUid";
//        ALog.i(fun + "channel:" + channel + ", token:" + token + ", tokenType:" + tokenType +
//                ", openid:" + openid + ", traceId: " + traceId + ", url: " + url);
//        quicHttp.init();
//        HashMap<String, String> quicHeader = new HashMap<>();
//        quicHeader.put("Context", "BindThirdUserByUid");
//        quicHeader.put("AppId", AuthInfo.getAppId());
//        quicHeader.put("Uid", openid);
//        quicHeader.put("ServiceName", "UdbApp.ThirdloginServer.ThirdloginObj");
//        quicHeader.put("FunctionName", "BindThirdUserByUid");
//        quicHeader.put("TraceId", traceId);
//        quicHeader.put("ProtoType", "Quic");
//        quicHeader.put("InstId", "BindThirdUserByUid");
//        quicHeader.put("ServerId", "BindThirdUserByUid");
//
//        try {
//            quicHttp.connect(url, "POST", quicHeader, thirdLoginReq.toByteArray(),
//                    60 * 1000, true, true);
//        } catch (Exception e) {
//            quicResult = (CHidoReport.QuicResult.CONNECT_IO_EXCEPTION);
//            ALog.i(fun + "connect exception, " + e.getMessage());
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
////            onThirdLoginFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
////                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol, errInfo, callback);
//            return quicResult;
//        }
//
//        int code;
//        try {
//            code = quicHttp.getResponseCode();
//        } catch (Exception e) {
//            code = ResCodeDef.AuthSdkErrorCode.ConnectErr;
//            ALog.i(fun + "getResponseCode exception, " + e.getMessage());
//        }
//        if (code > 400) {
//            quicResult = (CHidoReport.QuicResult.RESPONSE_ERROR);
//            ALog.i(fun + "recvResponse code:" + code);
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
////            onThirdLoginFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
////                    quicHttp.getResponseCode(), errInfo, callback);
//            return quicResult;
//        } else if (code == ResCodeDef.AuthSdkErrorCode.ConnectErr) {
//            quicResult = isTimeout ? CHidoReport.QuicResult.TIMEOUT
//                    : (CHidoReport.QuicResult.CONNECT_ERROR);
//            ALog.i(fun + "connect err code:" + code);
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
////            onThirdLoginFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
////                    ResCodeDef.AuthSdkErrorCode.ConnectErr, errInfo, callback);
//            return quicResult;
//        }
//
//        ThirdloginRsp res;
//        try {
//            InputStream is = quicHttp.getInputStream();
//            res = ThirdloginRsp.parseFrom(is);
//        } catch (Exception e) {
//            quicResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
//            String errInfo = fun + "getInputStream IOException, errInfo:" + e.getMessage();
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//            onBindThirdTokenFailed(bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE, code, errInfo);
//            return quicResult;
//        } finally {
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
//        }
//
//        if (res.getRescode().equals("0")) {
//            quicResult = (CHidoReport.QuicResult.SUCCESS);
//            long eTime = System.currentTimeMillis();
//            if (NetworkUtil.isNetworkConnected() && bTime > 0) {
//                CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
//                response.mRtt = System.currentTimeMillis() - bTime;
//                response.mEventType = "BindThirdUserByUid/quic";
//                response.mSucceed = 0;
//                response.mErrType = 0;
//                response.mErrCode = 0;
//                response.mTraceId = traceId;
//                response.mChannel = ChannelName.QUIC;
//                response.mUserInfo = token;
//
//                response.mQuicResult = quicResult;
//                response.mTotalRtt = eTime - startTime;
//                CHidoReport.getInstance().report2Hido(response);
//                CHidoReport.getInstance().report2Metric(response);
//            }
//
//            try {
//                JSONObject jsonData = new JSONObject(res.getData());
//                final ThirdInfo info = new ThirdInfo();
//                ThirdInfoUtils.unPack(jsonData, info);
//
//                ALog.i(fun + "success,chanel=" + channel + ",oid=" + openid +
//                        ",thirdAuthSrvCode:" + res.getRescode() + ",thirdAuthSrvDesc:" +
//                        res.getMessage() + ",data:" + res.getData() + ",ts=" + info.mTS);
//
//                AuthInfo.saveAuth(info.mUid, info.mCredit, info.mTS * 1000, info.st);
//                AntiHelper.checkAntiCodeHw(info.mUid);
//                ThreadManager.executeOnMainThread(new Runnable() {
//                    @Override
//                    public void run() {
//                        onSuccess(0, info);
//                    }
//                });
//            } catch (Exception e) {
//                quicResult = CHidoReport.QuicResult.AUTH_ERROR;
//                ALog.i(fun + "fail, chanel=" + channel + ", oid=" + openid +
//                        ", exceptionDesc:" + e.getMessage());
//                onBindThirdTokenFailed(bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
//                        Integer.parseInt(res.getRescode()), e.getMessage());
//            }
//        } else {
//            ALog.i(fun + "fail,chanel=" + channel + ",oid=" + openid + ",thidAuthSrvCode:" +
//                    res.getRescode() + ", thirdAuthSrvDesc:" + res.getMessage());
//            quicResult = CHidoReport.QuicResult.AUTH_ERROR;
//            onBindThirdTokenFailed(bTime, traceId, ResCodeDef.Type.AUTH_SRV_CODE,
//                    Integer.parseInt(res.getRescode()), res.getMessage());
//        }
//        return quicResult;
//    }
//
//    public void stop() {
//        isTimeout = true;
//        if (quicHttp != null) {
//            quicHttp.disconnect();
//        }
//    }
//
//    public void onBindThirdTokenFailed(long bTime, int errType, int errCode, String description) {
//        onBindThirdTokenFailed(bTime, traceId, errType, errCode, description);
//    }
//
//    private void onBindThirdTokenFailed(long bTime, String traceId, final int errType, final int errCode,
//                                        final String description) {
//        long eTime = System.currentTimeMillis();
//        if (NetworkUtil.isNetworkConnected() && bTime > 0) {
//            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
//            response.mRtt = eTime - bTime;
//            response.mEventType = "BindThirdUserByUid/quic";
//            response.mSucceed = 2;
//            response.mErrType = errType + 1;
//            response.mErrCode = errCode;
//            response.mErrDesc = description;
//            response.mTraceId = traceId;
//            response.mChannel = ChannelName.QUIC;
//            response.mUserInfo = token;
//
//            response.mQuicResult = quicResult;
//            response.mTotalRtt = eTime - startTime;
//            CHidoReport.getInstance().report2Hido(response);
//            CHidoReport.getInstance().report2Metric(response);
//        }
//
//        ThreadManager.executeOnMainThread(new Runnable() {
//            @Override
//            public void run() {
//                onFail(-1, errType, errCode, description);
//            }
//        });
//    }
//
//
//    @Override
//    public void onSuccess(int requestId, ThirdInfo thirdInfo) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onSuccess(requestId, thirdInfo);
//        }
//        callback = null;
//        callbackLock.unlock();
//    }
//
//    @Override
//    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onFail(requestId, codeType, resCode, resDesc);
//        }
//        callback = null;
//        callbackLock.unlock();
//    }
//}
