package com.yy.platform.loginlite;

import com.google.protobuf.InvalidProtocolBufferException;
import com.yy.platform.loginlite.proto.ThirdloginReq;
import com.yy.platform.loginlite.proto.ThirdloginRsp;
import com.yy.platform.loginlite.utils.CodeUtils;
import com.yy.platform.loginlite.utils.EventTypeUtils;
import com.yy.platform.loginlite.utils.ThirdInfoUtils;
import com.yy.platform.loginlite.utils.ThreadManager;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import okhttp3.Call;

/**
 * Created by chenkaicai on 2019/7/10.
 */

public class BindThirdTokenByOkHttp extends BaseOkHttp implements IThirdLoginCallback {
    private static final String fun = "BindThirdUserByUid ";
    private String uid;
    private String optToken;
    private String path;
    private Map<String, String> map;
    private long bTime;
    private ThirdloginReq thirdLoginReq;
    private int timeout;

    public BindThirdTokenByOkHttp(
            int timeout, long sTime, String channel, String token, int tokenType,
            String openid, String uid, String optToken,
            String authUrl, String extInfo, IThirdLoginCallback callback
    ) {
        this.timeout = timeout;
        this.channel = channel;
        this.token = token;
        this.tokenType = tokenType;
        this.openid = openid;
        this.uid = uid;
        this.optToken = optToken;
        this.callback = callback;
        this.callbackLock = new ReentrantLock();
        this.startTime = sTime;

        thirdLoginReq = ThirdloginReq.newBuilder()
                .setVersion(1)
                .setAppid(AuthInfo.getHeader().getAppId())
                .setChannel(channel)
                .setToken(token)
                .setTokenType(tokenType)
                .setOpenid(openid)
                .setUid(uid)
                .setOptToken(optToken)
                .setAuthUrl(authUrl)
                .setDeviceid(AuthInfo.getHeader().getDeviceId())
                .setClientSys(AuthInfo.getHeader().getSys())
                .setExtInfo(extInfo)
                .setRegion(AuthInfo.getHeader().getRegion())
                .build();
        path = "UdbApp.ThirdloginServer.ThirdloginObj/BindThirdUserByUid";
        map = new HashMap<>();

        map.put("Context", "BindThirdUserByUid");
        map.put("AppId", AuthInfo.getAppId());
        map.put("Uid", openid);
        map.put("ServiceName", "UdbApp.ThirdloginServer.ThirdloginObj");
        map.put("FunctionName", "BindThirdUserByUid");

        map.put("ProtoType", "http");
//        map.put("InstId", "BindThirdUserByUid");
//        map.put("ServerId", "BindThirdUserByUid");
        String regionSet = AuthInfo.getRegionSet();
        if (regionSet != null) {
            map.put(AuthInfo.getRegionSetKey(), regionSet);
        }
        tag = fun;
    }

    public void execute() {
        bTime = System.currentTimeMillis();
        quicResult = (CHidoReport.QuicResult.ONGOING);
        ALog.i(fun + "channel:" + channel + ", token:" + token + ", tokenType:" + tokenType +
                ", openid:" + openid);
        executeInner(path, map, thirdLoginReq.toByteArray(), timeout);
    }

    private void onBindThirdTokenFailed(long bTime, final int errType, final int errCode,
                                        final String description) {
        long eTime = System.currentTimeMillis();
        if (bTime > 0) {
            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
            response.mRtt = eTime - bTime;
            response.mEventType = getEventType();
            response.mSucceed = 2;
            response.mErrType = errType + 1;
            response.mErrCode = errCode;
            response.mErrDesc = description;
            response.mTraceId = traceId;
            response.mChannel = ChannelName.HTTP;
            response.mUserInfo = token;

//            response.mQuicResult = quicResult;
            response.mTotalRtt = eTime - startTime;
            CHidoReport.getInstance().report2Hido(response);
            CHidoReport.getInstance().report2Metric(response);
        }

        ThreadManager.executeOnMainThread(new Runnable() {
            @Override
            public void run() {
                onFail(-1, errType, errCode, description);
            }
        });
    }

    private String channel;
    private String token;
    private int tokenType;
    private String openid;
    private IThirdLoginCallback callback;
    private int quicResult = CHidoReport.QuicResult.ENABLE_QUIC;
    private long startTime = 0;
    private Lock callbackLock = null;

    @Override
    public void onSuccess(int requestId, ThirdInfo thirdInfo) {
        callbackLock.lock();
        if (callback != null) {
            callback.onSuccess(requestId, thirdInfo);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
        callbackLock.lock();
        if (callback != null) {
            callback.onFail(requestId, codeType, resCode, resDesc);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onSuccess(Call call, byte[] data, int httpCode, long useTime) {

        ThirdloginRsp res;
        try {
            res = ThirdloginRsp.parseFrom(data);
        } catch (InvalidProtocolBufferException e) {
            String msg = e.getMessage();
            quicResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
            String errInfo = fun + "IOException, err:" + msg + ", code: " + httpCode;
            ALog.i(errInfo);
            int code = CodeUtils.makeCode(httpCode, CodeUtils.bindThirdToken);
            onBindThirdTokenFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, code, msg);
            return;
        }

        if (res.getRescode().equals("0")) {
            quicResult = (CHidoReport.QuicResult.SUCCESS);
            long eTime = System.currentTimeMillis();
            if (bTime > 0) {
                CHidoReport.CReportResponse report = new CHidoReport.CReportResponse();
                report.mRtt = eTime - bTime;
                report.mEventType = getEventType();
                report.mSucceed = 0;
                report.mErrType = 0;
                report.mErrCode = 0;
                report.mTraceId = traceId;
                report.mChannel = ChannelName.HTTP;
                report.mUserInfo = token;

//                report.mQuicResult = quicResult;
                report.mTotalRtt = eTime - startTime;
                CHidoReport.getInstance().report2Hido(report);
                CHidoReport.getInstance().report2Metric(report);
            }

            try {
                JSONObject jsonData = new JSONObject(res.getData());
                final ThirdInfo info = new ThirdInfo();
                ThirdInfoUtils.unPack(jsonData, info);

                ALog.i(fun + "success,chanel=" + channel + ",thirdAuthSrvCode:" +
                        res.getRescode() + ",thirdAuthSrvDesc:" + res.getMessage() +
                        ",data:" + res.getData() + ",ts=" + info.mTS);

                AuthInfo.saveAuth(info.mUid, info.mCredit, info.mTS * 1000, info.st);
                ThreadManager.executeOnMainThread(new Runnable() {
                    @Override
                    public void run() {
                        onSuccess(0, info);
                        AntiHelper.checkAntiCodeHw(info.mUid);
                    }
                });
            } catch (Exception e) {
                quicResult = CHidoReport.QuicResult.AUTH_ERROR;
                ALog.i(fun + "fail, chanel=" + channel + ", exceptionDesc:" + e.getMessage());
                int errorCode = CodeUtils.parseCode(res.getRescode(), 99);
                onBindThirdTokenFailed(bTime, ResCodeDef.Type.AUTH_SDK_CODE,
                        errorCode, e.getMessage());
            }
        } else {
            ALog.i(fun + "fail,chanel=" + channel +
                    ", thidAuthSrvCode:" + res.getRescode() +
                    ", thirdAuthSrvDesc:" + res.getMessage());
            quicResult = CHidoReport.QuicResult.AUTH_ERROR;
            int errorCode = CodeUtils.parseCode(res.getRescode(), 99);
            onBindThirdTokenFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE,
                    errorCode, res.getMessage());
        }
    }

    private String getEventType() {
        return compose(EventTypeUtils.bindThird);
    }

    @Override
    public void onFail(int code, String message, long useTime) {
        quicResult = (CHidoReport.QuicResult.AUTH_ERROR);
        int busiCode = CodeUtils.makeCode(code, CodeUtils.bindThirdToken);
        ALog.i(fun + "response fail, code: " + code + ", business code: " + busiCode);
        onBindThirdTokenFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, busiCode, message);
    }

    @Override
    public void onHttpFail(int code, String message, long useTime) {
        quicResult = (CHidoReport.QuicResult.CONNECT_ERROR);
        int busiCode = CodeUtils.makeCode(code, CodeUtils.bindThirdToken);
        ALog.i(fun + "http fail, code: " + code + ", business code: " + busiCode);
        onBindThirdTokenFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, busiCode, message);
    }
}
