//package com.yy.platform.loginlite;
//
//import com.yy.platform.loginlite.proto.BindMobileReq;
//import com.yy.platform.loginlite.proto.BindMobileRsp;
//import com.yy.platform.loginlite.proto.ClientRegisterErr;
//import com.yy.platform.loginlite.utils.NetworkUtil;
//import com.yy.platform.loginlite.utils.ServiceUrls;
//import com.yy.platform.loginlite.utils.ThreadManager;
//
//import java.io.InputStream;
//import java.util.HashMap;
//import java.util.UUID;
//import java.util.concurrent.locks.Lock;
//import java.util.concurrent.locks.ReentrantLock;
//
///**
// * Created by chenkaicai on 2019/7/10.
// */
//
//public class BindMobilePhoneQuic implements IBindMobilePhoneCallback {
//
//    private static final String fun = "bindMobilePhone using quic ";
//    private String traceId = "";
//    private String phoNum;
//    private long uid;
//    private String smsCode;
//    private long startTime;
//    private Lock callbackLock;
//    IBindMobilePhoneCallback callback;
//    private IQuicHandler quicHttp;
//    private int quicResult = CHidoReport.QuicResult.ENABLE_QUIC;
//    private boolean isTimeout = false;
//
//    public BindMobilePhoneQuic(
//            IQuicHandler handler,
//            long sTime,
//            String phoNum,
//            long uid,
//            String smsCode,
//            IBindMobilePhoneCallback callback
//    ) {
//        this.quicHttp = handler;
//        this.phoNum = phoNum;
//        this.uid = uid;
//        this.smsCode = smsCode;
//        this.callback = callback;
//        this.callbackLock = new ReentrantLock();
//        this.startTime = sTime;
//    }
//
//    public int getQuicResult() {
//        return quicResult;
//    }
//
//    public int run() {
//        long bTime = System.currentTimeMillis();
//        quicResult = (CHidoReport.QuicResult.ONGOING);
//
//        BindMobileReq bindMobileReq = BindMobileReq.newBuilder().build().newBuilder()
//                .setUser(String.valueOf(uid))
//                .setMobile(phoNum)
//                .setSmscode(smsCode)
//                .setOtp(new String(AuthInfo.getOtp("", uid)))
//                .setPrheader(AuthInfo.getHeader())
//                .build();
//
//        traceId = UUID.randomUUID().toString();
//        String url = ServiceUrls.getHttpUrl() + "UdbApp.RegisterServer.RegisterObj/BindMobile";
//        ALog.i(fun + "phoNum:" + phoNum + ", uid:" + uid + ", traceId: " + traceId + ", url: " + url);
//        quicHttp.init();
//        HashMap<String, String> quicHeader = new HashMap<>();
//        quicHeader.put("Context", "BindMobile");
//        quicHeader.put("AppId", AuthInfo.getAppId());
//        quicHeader.put("Uid", String.valueOf(uid));
//        quicHeader.put("ServiceName", "UdbApp.RegisterServer.RegisterObj");
//        quicHeader.put("FunctionName", "BindMobile");
//        quicHeader.put("TraceId", traceId);
//        quicHeader.put("ProtoType", "Quic");
//        quicHeader.put("InstId", "BindMobile");
//        quicHeader.put("ServerId", "BindMobile");
//
//        try {
//            quicHttp.connect(url, "POST", quicHeader, bindMobileReq.toByteArray(),
//                    60 * 1000, true, true);
//        } catch (Exception e) {
//            quicResult = (CHidoReport.QuicResult.CONNECT_IO_EXCEPTION);
//            ALog.i(fun + "connect exception, " + e.getMessage());
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
////            onThirdLoginFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
////                    ResCodeDef.AuthSdkErrorCode.InvalidProtocol, errInfo, callback);
//            return quicResult;
//        }
//
//        int code;
//        try {
//            code = quicHttp.getResponseCode();
//        } catch (Exception e) {
//            code = ResCodeDef.AuthSdkErrorCode.ConnectErr;
//            ALog.i(fun + "getResponseCode exception, " + e.getMessage());
//        }
//        if (code > 400) {
//            quicResult = (CHidoReport.QuicResult.RESPONSE_ERROR);
//            ALog.i(fun + "recvResponse code:" + code);
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
////            onThirdLoginFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
////                    quicHttp.getResponseCode(), errInfo, callback);
//            return quicResult;
//        } else if (code == ResCodeDef.AuthSdkErrorCode.ConnectErr) {
//            quicResult = isTimeout ? CHidoReport.QuicResult.TIMEOUT
//                    : (CHidoReport.QuicResult.CONNECT_ERROR);
//            ALog.i(fun + "connect err code:" + code);
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
////            onThirdLoginFailed(true, bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE,
////                    ResCodeDef.AuthSdkErrorCode.ConnectErr, errInfo, callback);
//            return quicResult;
//        }
//
//        BindMobileRsp res;
//        try {
//            InputStream is = quicHttp.getInputStream();
//            res = BindMobileRsp.parseFrom(is);
//        } catch (Exception e) {
//            quicResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
//            String errInfo = fun + "getInputStream IOException, errInfo:" + e.getMessage();
//            AuthCore.sLog.i(AuthCore.TAG, errInfo);
//            onBindPhoneFailed(bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE, code, errInfo);
//            return quicResult;
//        } finally {
//            if (quicHttp != null) {
//                quicHttp.disconnect();
//            }
//        }
//
//        ALog.i(fun + "success, authSrvCode:" + res.getErrcodeValue() +
//                ",authSrvDesc:" + res.getDescription());
//
//        if (res.getErrcode() == ClientRegisterErr.CSUCCESS) {
//            quicResult = (CHidoReport.QuicResult.SUCCESS);
//            long eTime = System.currentTimeMillis();
//            if (NetworkUtil.isNetworkConnected() && bTime > 0) {
//                CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
//                response.mRtt = System.currentTimeMillis() - bTime;
//                response.mEventType = "BindMobile/quic";
//                response.mSucceed = 0;
//                response.mErrType = 0;
//                response.mErrCode = 0;
//                response.mTraceId = traceId;
//                response.mChannel = ChannelName.QUIC;
//
//                response.mQuicResult = quicResult;
//                response.mTotalRtt = eTime - startTime;
//                CHidoReport.getInstance().report2Hido(response);
//                CHidoReport.getInstance().report2Metric(response);
//            }
//            ThreadManager.executeOnMainThread(new Runnable() {
//                @Override
//                public void run() {
//                    onSuccess(0);
//                }
//            });
//
//        } else {
//            quicResult = CHidoReport.QuicResult.AUTH_ERROR;
//            onBindPhoneFailed(bTime, traceId, ResCodeDef.Type.AUTH_SRV_CODE,
//                    res.getErrcodeValue(), res.getDescription());
//        }
//        return quicResult;
//    }
//
//    public void stop() {
//        isTimeout = true;
//        if (quicHttp != null) {
//            quicHttp.disconnect();
//        }
//    }
//
//    public void onBindPhoneFailed(long bTime, int errType, int errCode, String description) {
//        onBindPhoneFailed(bTime, traceId, errType, errCode, description);
//    }
//
//    private void onBindPhoneFailed(long bTime, String traceId, final int errType, final int errCode,
//                                   final String description) {
//        long eTime = System.currentTimeMillis();
//        if (NetworkUtil.isNetworkConnected() && bTime > 0) {
//            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
//            response.mRtt = eTime - bTime;
//            response.mEventType = "BindMobile/quic";
//            response.mSucceed = 2;
//            response.mErrType = errType + 1;
//            response.mErrCode = errCode;
//            response.mErrDesc = description;
//            response.mTraceId = traceId;
//            response.mChannel = ChannelName.QUIC;
//            response.mQuicResult = quicResult;
//            response.mTotalRtt = eTime - startTime;
//            CHidoReport.getInstance().report2Hido(response);
//            CHidoReport.getInstance().report2Metric(response);
//        }
//
//        ThreadManager.executeOnMainThread(new Runnable() {
//            @Override
//            public void run() {
//                onFail(-1, errType, errCode, description);
//            }
//        });
//    }
//
//
//    @Override
//    public void onSuccess(int requestId) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onSuccess(requestId);
//        }
//        callback = null;
//        callbackLock.unlock();
//    }
//
//    @Override
//    public void onNext(int requestId, NextVerify dynVerify) {
//
//    }
//
//    @Override
//    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
//        callbackLock.lock();
//        if (callback != null) {
//            callback.onFail(requestId, codeType, resCode, resDesc);
//        }
//        callback = null;
//        callbackLock.unlock();
//    }
//}
