package com.yy.platform.loginlite;

import com.yy.platform.loginlite.proto.BindMobileReq;
import com.yy.platform.loginlite.proto.BindMobileRsp;
import com.yy.platform.loginlite.proto.ClientRegisterErr;
import com.yy.platform.loginlite.utils.NetworkUtil;
import com.yy.platform.loginlite.utils.ServiceUrls;
import com.yy.platform.loginlite.utils.ThreadManager;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Created by chenkaicai on 2019/7/10.
 */

public class BindMobilePhoneHttp extends BaseHttp implements IBindMobilePhoneCallback {
    private static final String fun = "bindMobilePhone using http ";
    private String traceId = "";
    private String phoNum;
    private long uid;
    private String smsCode;
    private long startTime;
    private Lock callbackLock;
    IBindMobilePhoneCallback callback;
    private HttpURLConnection conn = null;

    public BindMobilePhoneHttp(
            long sTime,
            String phoNum,
            long uid,
            String smsCode,
            IBindMobilePhoneCallback callback
    ) {
        super(callback);
        this.phoNum = phoNum;
        this.uid = uid;
        this.smsCode = smsCode;
        this.callback = callback;
        this.callbackLock = new ReentrantLock();
        this.startTime = sTime;
    }

    public int execute() {
        long bTime = System.currentTimeMillis();
        quicResult = (CHidoReport.QuicResult.ONGOING);

        BindMobileReq bindMobileReq = BindMobileReq.newBuilder().build().newBuilder()
                .setUser(String.valueOf(uid))
                .setMobile(phoNum)
                .setSmscode(smsCode)
                .setOtp(new String(AuthInfo.getOtp("", uid)))
                .setPrheader(AuthInfo.getHeader())
                .build();

        traceId = UUID.randomUUID().toString();
        String url = ServiceUrls.getHttpUrl() + "UdbApp.RegisterServer.RegisterObj/BindMobile";
        ALog.i(fun + "phoNum:" + phoNum + ", uid:" + uid + ", traceId: " + traceId + ", url: " + url);
        int code;
        try {
            URL httpURL = new URL(url);
            conn = (HttpURLConnection) httpURL.openConnection();
            conn.setRequestMethod(ServiceUrls.POST);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setReadTimeout(ServiceUrls.HTTP_CONNECT_TIMEOUT);
            conn.setConnectTimeout(ServiceUrls.HTTP_CONNECT_TIMEOUT);

            conn.addRequestProperty("Context", "BindMobile");
            conn.addRequestProperty("AppId", AuthInfo.getAppId());
            conn.addRequestProperty("Uid", String.valueOf(uid));
            conn.addRequestProperty("ServiceName", "UdbApp.RegisterServer.RegisterObj");
            conn.addRequestProperty("FunctionName", "BindMobile");
            conn.addRequestProperty("TraceId", traceId);
            conn.addRequestProperty("ProtoType", "http");
            conn.addRequestProperty("InstId", "BindMobile");
            conn.addRequestProperty("ServerId", "BindMobile");

            OutputStream os = conn.getOutputStream();
            bindMobileReq.writeTo(os);
            conn.connect();

            code = conn.getResponseCode();
            ALog.i(fun + "recvResponse code:" + code);
            if (code > 400) {
                quicResult = (CHidoReport.QuicResult.RESPONSE_ERROR);
                if (conn != null) {
                    conn.disconnect();
                }
                return quicResult;
            }
        } catch (Exception e) {
            quicResult = (CHidoReport.QuicResult.CONNECT_IO_EXCEPTION);
            ALog.i(fun + "connect exception, " + e.getMessage());
            if (conn != null) {
                conn.disconnect();
            }
            return quicResult;
        }

        BindMobileRsp res;
        try {
            InputStream is = conn.getInputStream();
            res = BindMobileRsp.parseFrom(is);
        } catch (Exception e) {
            quicResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
            String errInfo = fun + "getInputStream IOException, errInfo:" + e.getMessage();
            ALog.i(errInfo);
            onBindPhoneFailed(bTime, traceId, ResCodeDef.Type.AUTH_SDK_CODE, code, errInfo);
            return quicResult;
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }

        ALog.i(fun + "success, authSrvCode:" + res.getErrcodeValue() +
                ",authSrvDesc:" + res.getDescription());

        if (res.getErrcode() == ClientRegisterErr.CSUCCESS) {
            quicResult = (CHidoReport.QuicResult.SUCCESS);
            long eTime = System.currentTimeMillis();
            if (NetworkUtil.isNetworkConnected2() && bTime > 0) {
                CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
                response.mRtt = eTime - bTime;
                response.mEventType = "BindMobile/http";
                response.mSucceed = 0;
                response.mErrType = 0;
                response.mErrCode = 0;
                response.mTraceId = traceId;
                response.mChannel = ChannelName.HTTP;

                response.mQuicResult = quicResult;
                response.mTotalRtt = eTime - startTime;
                CHidoReport.getInstance().report2Hido(response);
                CHidoReport.getInstance().report2Metric(response);
            }
            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    onSuccess(0);
                }
            });
        } else {
            quicResult = CHidoReport.QuicResult.AUTH_ERROR;
            onBindPhoneFailed(bTime, traceId, ResCodeDef.Type.AUTH_SRV_CODE,
                    res.getErrcodeValue(), res.getDescription());
        }
        return quicResult;
    }

    public void onBindPhoneFailed(long bTime, int errType, int errCode, String description) {
        onBindPhoneFailed(bTime, traceId, errType, errCode, description);
    }

    private void onBindPhoneFailed(long bTime, String traceId, final int errType, final int errCode,
                                   final String description) {
        long eTime = System.currentTimeMillis();
        if (NetworkUtil.isNetworkConnected2() && bTime > 0) {
            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
            response.mRtt = eTime - bTime;
            response.mEventType = "BindMobile/http";
            response.mSucceed = 2;
            response.mErrType = errType + 1;
            response.mErrCode = errCode;
            response.mErrDesc = description;
            response.mTraceId = traceId;
            response.mChannel = ChannelName.HTTP;

            response.mQuicResult = quicResult;
            response.mTotalRtt = eTime - startTime;
            CHidoReport.getInstance().report2Hido(response);
            CHidoReport.getInstance().report2Metric(response);
        }

        ThreadManager.executeOnMainThread(new Runnable() {
            @Override
            public void run() {
                onFail(-1, errType, errCode, description);
            }
        });
    }

    private int quicResult = CHidoReport.QuicResult.ENABLE_QUIC;

    public int getQuicResult() {
        return quicResult;
    }

    @Override
    public void onSuccess(int requestId) {
        callbackLock.lock();
        if (callback != null) {
            callback.onSuccess(requestId);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onNext(int requestId, NextVerify dynVerify) {

    }

    @Override
    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
        callbackLock.lock();
        if (callback != null) {
            callback.onFail(requestId, codeType, resCode, resDesc);
        }
        callback = null;
        callbackLock.unlock();
    }
}
