package com.yy.platform.loginlite;

import com.google.protobuf.InvalidProtocolBufferException;
import com.yy.platform.loginlite.proto.BindMobileReq;
import com.yy.platform.loginlite.proto.BindMobileRsp;
import com.yy.platform.loginlite.proto.ClientRegisterErr;
import com.yy.platform.loginlite.utils.CodeUtils;
import com.yy.platform.loginlite.utils.EventTypeUtils;
import com.yy.platform.loginlite.utils.ThreadManager;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import okhttp3.Call;

/**
 * Created by chenkaicai on 2019/7/10.
 */

public class BindMobilePhoneByOkHttp extends BaseOkHttp implements IBindMobilePhoneCallback {
    private static final String fun = "bindMobilePhone ";
    private String phoNum;
    private long uid;
    private long startTime;
    private Lock callbackLock;
    private IBindMobilePhoneCallback callback;

    private BindMobileReq bindMobileReq;
    private Map<String, String> map;
    private int timeout;
    private long bTime;
    private String path;

    public BindMobilePhoneByOkHttp(
            int timeout,
            long sTime,
            String phoNum,
            long uid,
            String smsCode,
            IBindMobilePhoneCallback callback
    ) {
        this.timeout = timeout;
        this.phoNum = phoNum;
        this.uid = uid;
        this.callback = callback;
        this.callbackLock = new ReentrantLock();
        this.startTime = sTime;

        bindMobileReq = BindMobileReq.newBuilder().build().newBuilder()
                .setUser(String.valueOf(uid))
                .setMobile(phoNum)
                .setSmscode(smsCode)
                .setOtp(new String(AuthInfo.getOtp("", uid)))
                .setPrheader(AuthInfo.getHeader())
                .build();
        path = "UdbApp.RegisterServer.RegisterObj/BindMobile";

        map = new HashMap<>();
        map.put("Context", "BindMobile");
        map.put("AppId", AuthInfo.getAppId());
        map.put("Uid", String.valueOf(uid));
        map.put("ServiceName", "UdbApp.RegisterServer.RegisterObj");
        map.put("FunctionName", "BindMobile");
        map.put("ProtoType", "http");
//        map.put("InstId", "BindMobile");
//        map.put("ServerId", "BindMobile");

        tag = fun;
    }

    public void execute() {
        bTime = System.currentTimeMillis();
        quicResult = (CHidoReport.QuicResult.ONGOING);
        ALog.i(fun + "phoNum:" + phoNum + ", uid:" + uid);
        executeInner(path, map, bindMobileReq.toByteArray(), timeout);
    }

    private void onBindPhoneFailed(long bTime, final int errType, final int errCode,
                                   final String description) {
        long eTime = System.currentTimeMillis();
        if (bTime > 0) {
            CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
            response.mRtt = eTime - bTime;
            response.mEventType = getEventType();
            response.mSucceed = 2;
            response.mErrType = errType + 1;
            response.mErrCode = errCode;
            response.mErrDesc = description;
            response.mTraceId = traceId;
            response.mChannel = ChannelName.HTTP;

//            response.mQuicResult = quicResult;
            response.mTotalRtt = eTime - startTime;
            CHidoReport.getInstance().report2Hido(response);
            CHidoReport.getInstance().report2Metric(response);
        }

        ThreadManager.executeOnMainThread(new Runnable() {
            @Override
            public void run() {
                onFail(-1, errType, errCode, description);
            }
        });
    }

    private int quicResult = CHidoReport.QuicResult.ENABLE_QUIC;

    public int getQuicResult() {
        return quicResult;
    }

    @Override
    public void onSuccess(int requestId) {
        callbackLock.lock();
        if (callback != null) {
            callback.onSuccess(requestId);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onNext(int requestId, NextVerify dynVerify) {

    }

    @Override
    public void onFail(int requestId, int codeType, int resCode, String resDesc) {
        callbackLock.lock();
        if (callback != null) {
            callback.onFail(requestId, codeType, resCode, resDesc);
        }
        callback = null;
        callbackLock.unlock();
    }

    @Override
    public void onSuccess(Call call, byte[] data, int httpCode, long useTime) {
        BindMobileRsp res;
        try {
            res = BindMobileRsp.parseFrom(data);
        } catch (InvalidProtocolBufferException e) {
            String msg = e.getMessage();
            quicResult = (CHidoReport.QuicResult.RESPONSE_IO_EXCEPTION);
            String errInfo = fun + "IOException, err:" + msg + ", code: " + httpCode;
            ALog.i(errInfo);
            int code = CodeUtils.makeCode(httpCode, CodeUtils.bindMobilePhone);
            onBindPhoneFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, code, msg);
            return;
        }

        ALog.i(fun + "success, authSrvCode:" + res.getErrcodeValue() +
                ",authSrvDesc:" + res.getDescription());

        if (res.getErrcode() == ClientRegisterErr.CSUCCESS) {
            quicResult = (CHidoReport.QuicResult.SUCCESS);
            long eTime = System.currentTimeMillis();
            if (bTime > 0) {
                CHidoReport.CReportResponse report = new CHidoReport.CReportResponse();
                report.mRtt = eTime - bTime;
                report.mEventType = getEventType();
                report.mSucceed = 0;
                report.mErrType = 0;
                report.mErrCode = 0;
                report.mTraceId = traceId;
                report.mChannel = ChannelName.HTTP;

//                report.mQuicResult = quicResult;
                report.mTotalRtt = eTime - startTime;
                CHidoReport.getInstance().report2Hido(report);
                CHidoReport.getInstance().report2Metric(report);
            }
            ThreadManager.executeOnMainThread(new Runnable() {
                @Override
                public void run() {
                    onSuccess(0);
                }
            });
        } else {
            quicResult = CHidoReport.QuicResult.AUTH_ERROR;
            onBindPhoneFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE,
                    res.getErrcodeValue(), res.getDescription());
        }
    }

    private String getEventType() {
        return compose(EventTypeUtils.bindMobile);
    }

    @Override
    public void onFail(int code, String message, long useTime) {
        quicResult = (CHidoReport.QuicResult.AUTH_ERROR);
        int busiCode = CodeUtils.makeCode(code, CodeUtils.bindMobilePhone);
        ALog.i(fun + "response fail, code: " + code + ", business code: " + busiCode);
        onBindPhoneFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, busiCode, message);
    }

    @Override
    public void onHttpFail(int code, String message, long useTime) {
        quicResult = (CHidoReport.QuicResult.CONNECT_ERROR);
        int busiCode = CodeUtils.makeCode(code, CodeUtils.bindMobilePhone);
        ALog.i(fun + "http fail, code: " + code + ", business code: " + busiCode);
        onBindPhoneFailed(bTime, ResCodeDef.Type.AUTH_SRV_CODE, busiCode, message);
    }
}
