package com.yy.platform.loginlite;

import android.app.Activity;
import android.app.Service;
import android.content.Context;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;

import com.yy.platform.loginlite.proto.ProtoHeader;
import com.yy.platform.loginlite.utils.CodeUtils;
import com.yy.platform.loginlite.utils.EventTypeUtils;
import com.yy.platform.loginlite.utils.HttpClient;
import com.yy.platform.loginlite.utils.NetworkUtil;
import com.yy.platform.loginlite.utils.ThreadManager;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AuthCore implements IAuthCore {

    public static final String TAG = "authsdk";
    public static final int SUCCESS = 0;

    private static volatile AuthCore sInstance = null;
    private static Handler sMainHandler = null;
    private Context appContext;
    public static LogWrapper sLog = null;
    private static String sSessionData = "";
    private static final int retryCount = 3;
    private String subAppId = "";

    private IQuicHandler handler;

    private static ArrayList<Integer> sBRetryStrategy5s =
            new ArrayList<Integer>(Collections.nCopies(12, new Integer(5000)));

    private static ArrayList<Integer> sBRetryStrategy10s =
            new ArrayList<Integer>(Collections.nCopies(5, new Integer(10000)));

    private static final long sQuicDelay = 15 * 1000;

    private static final int NETWORK_ERROR = CodeUtils.makeCode(10, CodeUtils.common);
    private static final int CERROR = CodeUtils.makeCode(20, CodeUtils.param);
    private static final int PARAM = CodeUtils.makeCode(10, CodeUtils.param);
    private Map<String, String> map;

    private AuthCore() {

    }

    /**
     * 设置ABTest开关，2.5.0-snapshot.0版本开始
     * 0--- 保持原来2.3.14时策略service接入
     * 1---优先使用quic，若15s未成功切换回service重试
     *
     * @param abTestSwitch
     */
    public static synchronized void setABTest(int abTestSwitch) {
        AuthInfo.setABTest(abTestSwitch);
    }

    /**
     * 设置UDB 服务使用Service路由的set功能，填国家码，如CN，US，BR
     *
     * @param regionSet
     */
    public static synchronized void setRegionSet(String regionSet) {
        AuthInfo.setRegionSet(regionSet);
    }

    protected static NetworkReceiver sNetWorkReceiver = null;

    private RiskManager mRiskManager = null;
    
    //    /**
//     * 初始化海外登录 UDB SDK
//     *
//     * @param appContext App Context
//     * @param appId      申请的服务AppId
//     * @param subAppId   hago业务分配的appId
//     * @param deviceType Hago业务新增字段
//     * @param langCode   语言代码，参考{https://blog.csdn.net/xiaozhu54321/article/details/48196301}
//     * @param logger     写日志
//     * @return
//     */
//    public static synchronized IAuthCore init(
//            Context appContext, String appId,
//            String subAppId, String deviceType,
//            String langCode, ILog logger) {
//        return init(appContext, appId, subAppId, deviceType, langCode, "", logger);
//    }
    public static synchronized IAuthCore init(
            Context appContext, String appId,
            String subAppId, String deviceType,
            String langCode, String antiBizName,
            String deviceId, ILog logger) {
        return init(appContext, appId, subAppId, deviceType,
                langCode, antiBizName, deviceId, null, logger);
    }

    public void setExtMap(Map<String, String> map) {
        this.map = map;
        AuthInfo.setExtMap(map);
    }


    /**
     * 初始化海外登录 UDB SDK
     *
     * @param appContext  App Context
     * @param appId       申请的服务AppId
     * @param subAppId    hago业务分配的appId，可为空
     * @param deviceType  hago业务新增字段，可为空
     * @param langCode    语言代码，参考{https://blog.csdn.net/xiaozhu54321/article/details/48196301}
     * @param antiBizName 使用反外挂的业务app名
     * @param deviceId    hdid
     * @param logger      写日志
     * @return
     */
    public static synchronized IAuthCore init(
            Context appContext, String appId,
            String subAppId, String deviceType,
            String langCode, String antiBizName,
            String deviceId, Map<String, String> map, ILog logger) {
        if (null == sInstance) {
            CHidoReport.CReportResponse.mAppId = appId;
            CHidoReport.CReportResponse.mSys = 2;
            CHidoReport.CReportResponse.mDevice = Build.MANUFACTURER + "_" + Build.MODEL;
            CHidoReport.CReportResponse.mOS = "Android" + Build.VERSION.RELEASE;

//            YYLoadLibraryUtils.loadLibrary(appContext, "gnustl_shared");
            YYLoadLibraryUtils.loadLibrary(appContext, "c++_shared");
            YYLoadLibraryUtils.loadLibrary(appContext, "crypto.1.1");
            YYLoadLibraryUtils.loadLibrary(appContext, "ssl.1.1");
            YYLoadLibraryUtils.loadLibrary(appContext, "yyauthlite");
//            YYLoadLibraryUtils.loadLibrary(appContext, "DeviceIdentifier");

            sLog = new LogWrapper(logger);

            sInstance = new AuthCore();

            // 初始化风控
            sInstance.mRiskManager = new RiskManager(appContext, appId);

            if (map == null) {
                map = new HashMap<>();
            }
            // ID扩展字段
            map.put(AuthInfo.Key_DEVICEID, "");
            map.put(AuthInfo.Key_HDID, deviceId);   // 目前Hago传的deviceId就是hdid
            String pcid = sInstance.mRiskManager.getPcid();
            if (pcid == null) pcid = "";
            map.put(AuthInfo.Key_PCID, pcid);

            AuthInfo.init(appContext, appId, subAppId, deviceType, langCode, antiBizName,
                    deviceId, map);

            sInstance.mRiskManager.setOnPcidChangedListener(new RiskManager.OnPcidChangedListener() {
                @Override
                public void onPcidChanged(String pcid) {
                    HashMap map = new HashMap<>();
                    map.put(AuthInfo.Key_PCID, pcid);
                    sInstance.map.put(AuthInfo.Key_PCID, pcid);
                    AuthInfo.setExtMap(map);
                }
            });
//            sMainHandler = new Handler(appContext.getMainLooper());
            sMainHandler = ThreadManager.getMainHandler();

            if (appContext instanceof Activity) {
                sInstance.appContext = ((Activity) appContext).getApplication();
            } else if (appContext instanceof Service) {
                sInstance.appContext = ((Service) appContext).getApplication();
            } else {
                sInstance.appContext = appContext;
            }
            sInstance.subAppId = subAppId == null ? "" : subAppId;
            sInstance.map = map;

            sNetWorkReceiver = new NetworkReceiver(appContext);
            sNetWorkReceiver.getNetWorkType();

            if (AuthInfo.getABTest() == 1) {
                ThreadManager.init();
            }
//            //ArgoWrapper.initArgo(appContext);

            IntentFilter mFilter = new IntentFilter();
            mFilter.addAction(ConnectivityManager.CONNECTIVITY_ACTION);
            appContext.registerReceiver(sNetWorkReceiver, mFilter);

            HttpClient.init();
        }
        return sInstance;
    }

    @Override
    public RiskManager getRisk() {
        return mRiskManager;
    }

    public static synchronized IAuthCore getInstance() {
        return sInstance;
    }

    public static synchronized String getSessionData() {
        return sSessionData;
    }

    public static synchronized void setSessionData(String sessionData) {
        sSessionData = sessionData;
    }

    public static class LogWrapper {
        private static ILog sLog = null;

        LogWrapper(ILog logger) {
            sLog = logger;
        }

        public static synchronized void i(String tag, String msg) {
            if (sLog != null) {
                sLog.i(tag, msg);
            } else {
                Log.i(tag, msg);
            }
        }
    }

    @Override
    public void setHiidoMetricsApi(ILoginliteListener.ILoginliteHiidoMetricsStatisApi listener) {
        CHidoReport.getInstance().setHiidoMetricsStatisApi(listener);
    }

    private void reportNetworkError(String eventType, int errCode, String userInfo) {
        if (TextUtils.isEmpty(eventType)) {
            return;
        }
        CHidoReport.CReportResponse response = new CHidoReport.CReportResponse();
        response.mRtt = 0;
        response.mEventType = eventType;
        response.mSucceed = 2;
        response.mErrType = ResCodeDef.Type.AUTH_SRV_CODE + 1;
        response.mErrCode = errCode;
        response.mErrDesc = "network error";
        response.mTraceId = "";
        response.mChannel = ChannelName.HTTP;
        response.mUserInfo = userInfo == null ? "" : userInfo;

        response.mTotalRtt = 0;
        CHidoReport.getInstance().report2Hido(response);
        CHidoReport.getInstance().report2Metric(response);
    }

    @Override
    public int getSms(String phone, String smsType, String smsLength, String dynCode,
                      String whatsappToken, IGetSmsCallback callback) {
        if (TextUtils.isEmpty(phone)) {
            ALog.i("getSms: phone is null or empty");
            return PARAM;
        }
        if (callback == null) {
            ALog.i("getSms: IGetSmsCallback is null");
            return PARAM;
        }
        if (!NetworkUtil.isNetworkConnected()) {
            ALog.i("getSms network error");
            reportNetworkError(EventTypeUtils.withHttps(EventTypeUtils.getSms), CERROR, phone);
            callback.onFail(-1, ResCodeDef.Type.NETWORK_CODE, CERROR, "network error");
            return CERROR;
        }
        return getSmsByOkHttp(phone, smsType, smsLength, dynCode, whatsappToken, callback);
    }

    private GetSmsHttp getSms;
    private GetSmsByOkHttp getSmsByOkHttp;

    private int getSmsByOkHttp(
            final String userPhoneNumber,
            final String smsType,
            final String smsLength,
            final String dynCode,
            final String token,
            final IGetSmsCallback callback
    ) {
        if (getSmsByOkHttp != null) {
            getSmsByOkHttp.cancel();
        }
        final long startTime = System.currentTimeMillis();
        int timeout = NetworkUtil.getTimeout(appContext);
        ALog.e("getSms timeout " + timeout);
        getSmsByOkHttp = new GetSmsByOkHttp(timeout, appContext, startTime, userPhoneNumber, smsType,
                smsLength, dynCode, token, callback);
        getSmsByOkHttp.execute();
        return SUCCESS;
    }

    private int getSmsByHttp(
            final String userPhoneNumber,
            final String smsType,
            final String smsLength,
            final String dynCode,
            final String token,
            final IGetSmsCallback callback
    ) {
        if (getSms != null) {
            getSms.cancel();
        }
        final long startTime = System.currentTimeMillis();
        getSms = new GetSmsHttp(appContext, startTime, userPhoneNumber, smsType,
                smsLength, dynCode, token, callback);

        ThreadManager.executeOnNetWorkThread(new Runnable() {
            @Override
            public void run() {
                for (int i = 0; i < retryCount; i++) {
                    if (getSms.isCancel()) {
                        break;
                    }
                    int httpResult = getSms.execute();
                    if (httpResult >= CHidoReport.QuicResult.CONNECT_IO_EXCEPTION
                            && (httpResult <= CHidoReport.QuicResult.TIMEOUT)) {
                        ALog.e("getSms use time " + (System.currentTimeMillis() - startTime));
                        if (i == retryCount - 1) {
                            getSms.onGetSmsFailed(startTime, ResCodeDef.Type.NETWORK_CODE,
                                    NETWORK_ERROR, "network error");
                        }
                    } else {
                        break;
                    }
                }
            }
        });
        //ArgoWrapper.queryConfigs(0);
        return SUCCESS;
    }

    private int smsRegister(final String account, final String smsCode, final String password,
                            final ISmsRegisterCallback callback) {
        if (TextUtils.isEmpty(account)) {
            ALog.i("smsRegister: account is null or empty");
            return -1;
        }
        if (TextUtils.isEmpty(smsCode)) {
            ALog.i("smsRegister: smsCode is null or empty");
            return -1;
        }
        if (callback == null) {
            ALog.i("smsRegister: ISmsRegisterCallback is null");
            return -1;
        }
        if (!NetworkUtil.isNetworkConnected2(appContext)) {
            ALog.i("smsRegister network error");
            callback.onFail(-1, ResCodeDef.Type.NETWORK_CODE, CERROR, "network error");
            return -1;
        }
        return smsRegisterByHttp(account, smsCode, password, callback);
    }

    private SmsRegisterHttp smsRegister;

    private int smsRegisterByHttp(final String account, final String smsCode, final String password,
                                  final ISmsRegisterCallback callback) {
        if (smsRegister != null) {
            smsRegister.cancel();
        }
        final long startTime = System.currentTimeMillis();

        smsRegister = new SmsRegisterHttp(startTime, account, smsCode, password, callback);
        ThreadManager.executeOnNetWorkThread(new Runnable() {
            @Override
            public void run() {
                for (int i = 0; i < retryCount; i++) {
                    if (smsRegister.isCancel()) {
                        break;
                    }
                    int httpResult = smsRegister.execute();
                    if (httpResult >= CHidoReport.QuicResult.CONNECT_IO_EXCEPTION
                            && (httpResult <= CHidoReport.QuicResult.TIMEOUT)) {
                        if (i == retryCount - 1) {
                            smsRegister.onSmsRegisterFailed(startTime, ResCodeDef.Type.NETWORK_CODE,
                                    NETWORK_ERROR, "network error");
                        }
                    } else {
                        break;
                    }
                }
            }
        });
        //ArgoWrapper.queryConfigs(0);
        return SUCCESS;
    }

    @Override
    public int smsLogin(String phone, String smsCode, String dynCode, String otp, ISmsLoginCallback callback) {
        if (TextUtils.isEmpty(phone)) {
            ALog.i("smsLogin: phone is null or empty");
            return PARAM;
        }
        if (TextUtils.isEmpty(smsCode)) {
            ALog.i("smsLogin: smsCode is null or empty");
            return PARAM;
        }
        if (callback == null) {
            ALog.i("smsLogin: IGetSmsCallback is null");
            return PARAM;
        }
        if (!NetworkUtil.isNetworkConnected()) {
            ALog.i("smsLogin network error");
            reportNetworkError(EventTypeUtils.withHttps(EventTypeUtils.smsLogin), CERROR, phone);
            callback.onFail(-1, ResCodeDef.Type.NETWORK_CODE, CERROR, "network error");
            return CERROR;
        }
//        if (TextUtils.isEmpty(dynCode)) {
//            return smsLoginByHttpAndQuic(phone, smsCode, dynCode, otp, callback);
//        } else {
//            return smsLoginByHttp(phone, smsCode, dynCode, otp, callback);
//        }
        if (smsLoginByOkHttp != null) {
            smsLoginByOkHttp.cancel();
        }

        final long startTime = System.currentTimeMillis();
        int timeout = NetworkUtil.getTimeout(appContext);
        ALog.e("smsLogin timeout " + timeout);
        smsLoginByOkHttp = new SmsLoginByOkHttp(timeout, appContext, startTime, phone,
                smsCode, dynCode, otp, callback);
        smsLoginByOkHttp.execute();
        return SUCCESS;
    }

    @Override
    public int smsLogin(final String userPhoneNumber, final String smsCode,
                        final String dynCode, final ISmsLoginCallback callback) {
        return smsLogin(userPhoneNumber, smsCode, dynCode, "", callback);
    }

//    private int smsLoginByHttpAndQuic(
//            final String phoneNumber,
//            final String smsCode,
//            final String dynCode,
//            final String otp,
//            final ISmsLoginCallback callback
//    ) {
//        boolean[] strategy = NetworkStrategy.getInstance().choiceStrategy();
//        if (handler == null) {
//            strategy[0] = true;
//        }
//
//        SmsLoginCallbackProxy proxy = new SmsLoginCallbackProxy(callback);
//        final long startTime = System.currentTimeMillis();
//        if (strategy[0]) {
//            proxy.increUseCount();
//            final SmsLoginHttp http = new SmsLoginHttp(appContext, startTime, phoneNumber,
//                    smsCode, dynCode, otp, proxy);
//            ThreadManager.executeOnNetWorkThread(new Runnable() {
//                @Override
//                public void run() {
//                    for (int i = 0; i < retryCount; i++) {
//                        int httpResult = http.execute();
//                        ALog.e("smsLogin http retry =" + i + ", result=" + httpResult);
//                        if (httpResult >= CHidoReport.QuicResult.CONNECT_IO_EXCEPTION
//                                && (httpResult <= CHidoReport.QuicResult.TIMEOUT)) {
//                            if (i == retryCount - 1) {
//                                http.onSmdLoginFailed(startTime, ResCodeDef.Type.NETWORK_CODE, -1, "network error");
//                            }
//                        } else {
//                            break;
//                        }
//                    }
//                }
//            });
//        }
//
////        if (handler != null && strategy[1]) {
////            proxy.increUseCount();
////            final SmsLoginQuic quic = new SmsLoginQuic(appContext, handler, startTime,
////                    phoneNumber, smsCode, dynCode, otp, proxy);
////            ThreadManager.executeOnNetWorkThread(new Runnable() {
////                @Override
////                public void run() {
////                    for (int i = 0; i < retryCount; i++) {
////                        int quicResult = quic.run();
////                        ALog.e("smsLogin quic retry =" + i + ", result=" + quicResult);
////                        if (quicResult >= CHidoReport.QuicResult.CONNECT_IO_EXCEPTION
////                                && (quicResult <= CHidoReport.QuicResult.TIMEOUT)) {
////                            if (i == 2) {
////                                quic.onSmdLoginFailed(startTime, ResCodeDef.Type.NETWORK_CODE, -1, "network error");
////                                NetworkStrategy.getInstance().clear();
////                            }
////                        } else {
////                            break;
////                        }
////                    }
////                }
////            });
////            ThreadManager.executeOnSubThread(new Runnable() {
////                @Override
////                public void run() {
////                    //关闭QuicHttp
////                    quic.stop();
////                }
////            }, sQuicDelay);
////        }
//        //ArgoWrapper.queryConfigs(0);
//        return SUCCESS;
//    }

    private SmsLoginHttp smsLogin;
    private SmsLoginByOkHttp smsLoginByOkHttp;

    private int smsLoginByHttp(
            final String phoneNumber,
            final String smsCode,
            final String dynCode,
            final String otp,
            final ISmsLoginCallback callback
    ) {
        if (smsLogin != null) {
            smsLogin.cancel();
        }
//        SmsLoginCallbackProxy proxy = new SmsLoginCallbackProxy(callback);
//        proxy.increUseCount();
        final long startTime = System.currentTimeMillis();
        smsLogin = new SmsLoginHttp(appContext, startTime, phoneNumber,
                smsCode, dynCode, otp, callback);

        ThreadManager.executeOnNetWorkThread(new Runnable() {
            @Override
            public void run() {
                for (int i = 0; i < retryCount; i++) {
                    if (smsLogin.isCancel()) {
                        break;
                    }
                    int httpResult = smsLogin.execute();
                    ALog.e("smsLogin http retry =" + i + ", result=" + httpResult);
                    if (httpResult >= CHidoReport.QuicResult.CONNECT_IO_EXCEPTION
                            && (httpResult <= CHidoReport.QuicResult.TIMEOUT)) {
                        if (i == retryCount - 1) {
                            smsLogin.onSmdLoginFailed(startTime, ResCodeDef.Type.NETWORK_CODE,
                                    NETWORK_ERROR, "network error");
                        }
                    } else {
                        break;
                    }
                }
            }
        });
        return SUCCESS;
    }

    @Override
    public int creditLogin(final long yyuid, String stoken, final ICreditLoginCallback callback) {
        if (callback == null) {
            ALog.i("creditLogin: ICreditLoginCallback is null");
            return PARAM;
        }
        if (!NetworkUtil.isNetworkConnected()) {
            ALog.i("creditLogin network error");
            reportNetworkError(EventTypeUtils.withHttps(EventTypeUtils.creditLogin),
                    CERROR, String.valueOf(yyuid));
            callback.onFail(-1, ResCodeDef.Type.NETWORK_CODE, CERROR, "network error");
            return CERROR;
        }
        return creditLoginByOkHttp(yyuid, stoken, callback);
    }

    private CreditLoginHttp1 creditLoginHttp1;
    private CreditLoginByOkhttp creditLoginByOkhttp;

    private int creditLoginByHttp(final long yyuid, String stoken, final ICreditLoginCallback callback) {
        if (creditLoginHttp1 != null) {
            creditLoginHttp1.cancel();
        }
//        CreditLoginCallbackProxy proxy = new CreditLoginCallbackProxy(callback);
        if (stoken == null) {
            stoken = "";
        }
        ProtoHeader header = AuthInfo.getHeaderBuilder().putExtmap("sT", stoken).build();
        final long startTime = System.currentTimeMillis();
//        proxy.increUseCount();
        int timeout = NetworkUtil.getTimeout(appContext);
        ALog.e("creditLogin timeout " + timeout);
        creditLoginHttp1 = new CreditLoginHttp1(timeout, startTime, yyuid, header, callback);
        ThreadManager.executeOnNetWorkThread(new Runnable() {
            @Override
            public void run() {
                creditLoginHttp1.run();
            }
        });
//        if (handler != null && strategy[1]) {
//            proxy.increUseCount();
//            final CreditLoginQuic quic = new CreditLoginQuic(handler, startTime, yyuid, header, proxy);
//            ThreadManager.executeOnNetWorkThread(new Runnable() {
//                @Override
//                public void run() {
//                    int quicResult = quic.run();
//                    if (quicResult >= CHidoReport.QuicResult.CONNECT_IO_EXCEPTION
//                            && (quicResult <= CHidoReport.QuicResult.TIMEOUT)) {
//                        quic.onCreditLoginFailed(startTime, ResCodeDef.Type.NETWORK_CODE, -1, "network error");
//                    }
//                }
//            });
//            ThreadManager.executeOnSubThread(new Runnable() {
//                @Override
//                public void run() {
//                    //关闭QuicHttp
//                    quic.stop();
//                }
//            }, sQuicDelay);
//        }
        //ArgoWrapper.queryConfigs(yyuid);
        return SUCCESS;
    }

    private int creditLoginByOkHttp(final long yyuid, String stoken, final ICreditLoginCallback callback) {
        if (creditLoginByOkhttp != null) {
            creditLoginByOkhttp.cancel();
        }
        if (stoken == null) {
            stoken = "";
        }
        ProtoHeader header = AuthInfo.getHeaderBuilder().putExtmap("sT", stoken).build();
        final long startTime = System.currentTimeMillis();
        int timeout = NetworkUtil.getTimeout(appContext);
        ALog.e("creditLogin timeout " + timeout);
        creditLoginByOkhttp = new CreditLoginByOkhttp(timeout, startTime, yyuid, header, callback);
        creditLoginByOkhttp.execute();
        return SUCCESS;
    }

    @Override
    public int thirdLogin(String channel, String token, int tokenType,
                          String openid, String authUrl, String extInfo,
                          IThirdLoginCallback callback) {
        return thirdLoginByHttp(channel, token, tokenType, openid, authUrl, extInfo, null, callback);
    }

    @Override
    public int thirdLogin(String channel, String token, int tokenType,
                          String openid, String authUrl, String extInfo,
                          Map<String, String> headers,
                          IThirdLoginCallback callback) {
        return thirdLoginByHttp(channel, token, tokenType, openid, authUrl, extInfo, headers, callback);
    }

    private ThirdLoginHttp1 thirdLoginHttp1;
    private ThirdLoginByOkHttp thirdLoginByOkHttp;

    private int thirdLoginByHttp(final String channel, final String token, final int tokenType,
                                 final String openid, final String authUrl, String extInfo,
                                 final Map<String, String> headers,
                                 final IThirdLoginCallback callback) {
        if (TextUtils.isEmpty(channel)) {
            ALog.i("thirdLogin: channel is null or emtpy");
            return PARAM;
        }
        if (callback == null) {
            ALog.i("thirdLogin: IThirdLoginCallback is null");
            return PARAM;
        }
        if (!NetworkUtil.isNetworkConnected()) {
            ALog.i("thirdLogin network error");
            reportNetworkError(EventTypeUtils.withHttps(EventTypeUtils.thirdLogin), CERROR, token);
            callback.onFail(-1, ResCodeDef.Type.NETWORK_CODE, CERROR, "network error");
            return CERROR;
        }

        try {
            JSONObject json;
            if (TextUtils.isEmpty(extInfo)) {
                json = new JSONObject();
            } else {
                json = new JSONObject(extInfo);
            }
            String appV = AuthInfo.getAppVer();
            json.put("app_ver", appV == null ? "" : appV);
            json.put(AuthInfo.Key_SubAppid, subAppId);
            json.put(AuthInfo.Key_DEVICEID, "");
            json.put(AuthInfo.Key_HDID, AuthInfo.getHeader().getDeviceId());
            String pcid = "";
            if (getRisk() != null) {
                pcid = getRisk().getPcid();
                if (pcid == null)
                    pcid = "";
            }
            json.put(AuthInfo.Key_PCID, pcid);
            if (map != null && map.size() > 0) {
                for (String key : map.keySet()) {
                    json.put(key, map.get(key));
                }
            }
            extInfo = json.toString();
        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (thirdLoginByOkHttp != null) {
            thirdLoginByOkHttp.cancel();
        }
        int timeout = NetworkUtil.getTimeout(appContext);
        ALog.e("thirdLogin timeout " + timeout);
        thirdLoginByOkHttp = new ThirdLoginByOkHttp(timeout, System.currentTimeMillis(), channel, token,
                tokenType, openid, authUrl, extInfo, headers, callback);
        thirdLoginByOkHttp.execute();

//        final long startTime = System.currentTimeMillis();
//        final ThirdLoginHttp http = new ThirdLoginHttp(startTime, channel, token, tokenType,
//                openid, authUrl, extInfo, headers, callback);
//        ThreadManager.executeOnNetWorkThread(new Runnable() {
//            @Override
//            public void run() {
//                for (int i = 0; i < 3; i++) {
//                    int quicResult = http.run();
//                    if (quicResult >= CHidoReport.QuicResult.CONNECT_IO_EXCEPTION
//                            && (quicResult <= CHidoReport.QuicResult.TIMEOUT)) {
//                        if (i == 2) {
//                            http.onThirdLoginFailed(startTime, ResCodeDef.Type.NETWORK_CODE, -1, "network error");
//                        }
//                    } else {
//                        break;
//                    }
//                }
//            }
//        });

        //ArgoWrapper.queryConfigs(0);
        return SUCCESS;

    }

    @Override
    public byte[] getOtp(String destAppId, long uid) {
        return AuthInfo.getOtp(destAppId, uid);
    }

    @Override
    public byte[] getServiceToken(long uid) {
        return AuthInfo.getServiceOtp(uid);
    }

    @Override
    public void logout(boolean enableAutoLoginNext) {
        AuthInfo.logout(enableAutoLoginNext);
    }

    private BindMobilePhoneHttp bindMobilePhone;
    private BindMobilePhoneByOkHttp bindMobilePhoneByOkHttp;

    @Override
    public int bindMobilePhone(final String phoNum, final long uid, String smsCode,
                               final IBindMobilePhoneCallback callback) {
        if (TextUtils.isEmpty(phoNum)) {
            ALog.i("bindMobilePhone: phoNum is null or empty");
            return PARAM;
        }

        if (TextUtils.isEmpty(smsCode)) {
            ALog.i("bindMobilePhone: smsCode is null or empty");
            return PARAM;
        }

        if (callback == null) {
            ALog.i("bindMobilePhone: IBindMobilePhoneCallback is null ");
            return PARAM;
        }

        if (!NetworkUtil.isNetworkConnected()) {
            ALog.i("bindMobilePhone network error");
            reportNetworkError(EventTypeUtils.withHttps(EventTypeUtils.bindMobile),
                    CERROR, "");
            callback.onFail(-1, ResCodeDef.Type.NETWORK_CODE, CERROR, "network error");
            return CERROR;
        }

        if (bindMobilePhoneByOkHttp != null) {
            bindMobilePhoneByOkHttp.cancel();
        }
        final long startTime = System.currentTimeMillis();
        int timeout = NetworkUtil.getTimeout(appContext);
        ALog.e("bindMobilePhone timeout " + timeout);
        bindMobilePhoneByOkHttp = new BindMobilePhoneByOkHttp(timeout, startTime, phoNum, uid,
                smsCode, callback);
        bindMobilePhoneByOkHttp.execute();

//        bindMobilePhone = new BindMobilePhoneHttp(startTime, phoNum, uid, smsCode,
//                callback);
//        ThreadManager.executeOnNetWorkThread(new Runnable() {
//            @Override
//            public void run() {
//                for (int i = 0; i < retryCount; i++) {
//                    if (bindMobilePhone.isCancel()) {
//                        break;
//                    }
//                    int httpResult = bindMobilePhone.execute();
//                    if (httpResult >= CHidoReport.QuicResult.CONNECT_IO_EXCEPTION
//                            && (httpResult <= CHidoReport.QuicResult.TIMEOUT)) {
//                        if (i == retryCount - 1) {
//                            bindMobilePhone.onBindPhoneFailed(
//                                    startTime,
//                                    ResCodeDef.Type.NETWORK_CODE,
//                                    NETWORK_ERROR,
//                                    "network error"
//                            );
//                        }
//                    } else {
//                        break;
//                    }
//                }
//            }
//        });
        return SUCCESS;
    }

    private BindThirdTokenHttp bindThirdToken;
    private BindThirdTokenByOkHttp bindThirdTokenByOkHttp;

    @Override
    public int bindThirdToken(
            String channel,
            String token,
            int tokenType,
            String openid,
            String uid,
            String optToken,
            String authUrl,
            String extInfo,
            IThirdLoginCallback callback
    ) {
        if (TextUtils.isEmpty(channel)) {
            ALog.i("bindThirdToken channel is null or empty");
            return PARAM;
        }

        if (callback == null) {
            ALog.i("bindThirdToken IBindThirdTokenCallback is null or empty");
            return PARAM;
        }

        if (!NetworkUtil.isNetworkConnected()) {
            ALog.i("bindThirdToken network error");
            reportNetworkError(EventTypeUtils.withHttps(EventTypeUtils.bindThird), CERROR, token);
            callback.onFail(-1, ResCodeDef.Type.NETWORK_CODE, CERROR, "network error");
            return CERROR;
        }
        if (bindThirdTokenByOkHttp != null) {
            bindThirdTokenByOkHttp.cancel();
        }
        final long startTime = System.currentTimeMillis();
        int timeout = NetworkUtil.getTimeout(appContext);
        ALog.e("bindThirdToken timeout " + timeout);
        bindThirdTokenByOkHttp = new BindThirdTokenByOkHttp(timeout, startTime, channel, token,
                tokenType, openid, uid, optToken, authUrl, extInfo, callback);
        bindThirdTokenByOkHttp.execute();
        return SUCCESS;
    }

    private GuestLoginHttp guestLogin;
    private GuestLoginByOkhttp guestLoginByOkhttp;

    @Override
    public int guestLogin(final String dynCode, final IGuestLoginCallback callback) {
        if (callback == null) {
            ALog.i("guestLogin: IGuestLoginCallback is null");
            return PARAM;
        }
        if (!NetworkUtil.isNetworkConnected()) {
            ALog.i("guestLogin network error");
            reportNetworkError(EventTypeUtils.withHttps(EventTypeUtils.guestLogin), CERROR,
                    AuthInfo.getHeader().getDeviceId());
            callback.onFail(-1, ResCodeDef.Type.NETWORK_CODE, CERROR, "network error");
            return CERROR;
        }
        guestLoginByOkhttp(dynCode, callback);
        //ArgoWrapper.queryConfigs(0);
        return SUCCESS;
    }

    private void guestLoginByOkhttp(String dynCode, IGuestLoginCallback callback) {
        if (guestLoginByOkhttp != null) {
            guestLoginByOkhttp.cancel();
        }
        final long startTime = System.currentTimeMillis();
        int timeout = NetworkUtil.getTimeout(appContext);
        ALog.e("guestLogin timeout " + timeout);
        guestLoginByOkhttp = new GuestLoginByOkhttp(timeout, startTime, dynCode, callback);
        guestLoginByOkhttp.execute();
    }

    private void guestLoginByHttp(String dynCode, IGuestLoginCallback callback) {
        if (guestLogin != null) {
            guestLogin.cancel();
        }
        final long startTime = System.currentTimeMillis();
        guestLogin = new GuestLoginHttp(startTime, dynCode, callback);
        ThreadManager.executeOnNetWorkThread(new Runnable() {
            @Override
            public void run() {
                for (int i = 0; i < retryCount; i++) {
                    if (guestLogin.isCancel()) {
                        break;
                    }
                    int httpResult = guestLogin.execute();
                    if (httpResult >= CHidoReport.QuicResult.CONNECT_IO_EXCEPTION
                            && (httpResult <= CHidoReport.QuicResult.TIMEOUT)) {
                        if (i == retryCount - 1) {
                            guestLogin.onGuestLoginFailed(startTime, ResCodeDef.Type.NETWORK_CODE,
                                    NETWORK_ERROR, "network error");
                        }
                    } else {
                        break;
                    }
                }
            }
        });
    }

    @Override
    public void setQuicHandler(IQuicHandler handler) {
        this.handler = handler;
    }

    @Override
    public String getLogTag() {
        return TAG;
    }

    @Override
    public int findOpenId(String url, long appid, long uid, byte[] otp, IFindOpenIdCallback callback) {
        if (otp == null) {
            ALog.i("findOpenId: otp is null");
            return PARAM;
        }
        if (callback == null) {
            ALog.i("findOpenId: IFindOpenIdCallback is null");
            return PARAM;
        }
        if (!NetworkUtil.isNetworkConnected()) {
            ALog.i("findOpenId network error");
            callback.onFail(-1, "" + CERROR, "network error");
            return CERROR;
        }
        String normal = "https://os-lgn.yy.com/lgn/ws/openid.do";
        String realUrl;
        if (TextUtils.isEmpty(url)) {
            realUrl = normal;
        } else {
            realUrl = url;
        }
        FindOpenidHttp http = new FindOpenidHttp(realUrl, appid, uid, new String(otp));
        ThreadManager.executeOnNetWorkThread(new Runnable() {
            @Override
            public void run() {
                for (int i = 0; i < retryCount; i++) {
                    final String[] httpResult = http.run();
                    if (httpResult == null || !httpResult[0].equals("200")) {
                        if (i == retryCount - 1) {
                            final int httpCode = http.getCode();
                            ThreadManager.executeOnMainThread(new Runnable() {
                                @Override
                                public void run() {
                                    int fCode = CodeUtils.makeCode(httpCode, CodeUtils.common);
                                    ALog.e("findOpenId fCode: " + fCode + ", code: " + httpCode);
                                    callback.onFail(-1, "" + fCode, httpResult[1]);
                                }
                            });
                        }
                    } else {
                        ThreadManager.executeOnMainThread(new Runnable() {
                            @Override
                            public void run() {
                                callback.onSuccess(0, httpResult[1]);
                            }
                        });
                        break;
                    }
                }
            }
        });
        return SUCCESS;
    }

    @Override
    public int getWhatsappToken(final String context, final IGetWhatsappTokenCallback callbcak) {
        if (callbcak == null) {
            ALog.i("getWhatsappToken callback is null");
            return PARAM;
        }
        if (!NetworkUtil.isNetworkConnected()) {
            ALog.i("getWhatsappToken network error");
            callbcak.onFail(CERROR, "network error");
            return CERROR;
        }
        GetWhatsappTokenHttp http = new GetWhatsappTokenHttp(context, callbcak);
        ThreadManager.executeOnNetWorkThread(new Runnable() {
            @Override
            public void run() {
                for (int i = 0; i < retryCount; i++) {
                    int httpResult = http.run();
                    if (httpResult >= CHidoReport.QuicResult.CONNECT_IO_EXCEPTION
                            && (httpResult <= CHidoReport.QuicResult.TIMEOUT)) {
                        if (i == retryCount - 1) {
                            http.onGetWhatsappTokenFailed(NETWORK_ERROR, "network error");
                        }
                    } else {
                        break;
                    }
                }
            }
        });
        return SUCCESS;
    }

    @Override
    public void cancel() {
        if (creditLoginByOkhttp != null) {
            creditLoginByOkhttp.cancel();
            creditLoginByOkhttp = null;
        }

        if (thirdLoginByOkHttp != null) {
            thirdLoginByOkHttp.cancel();
            thirdLoginByOkHttp = null;
        }

        if (getSmsByOkHttp != null) {
            getSmsByOkHttp.cancel();
            getSmsByOkHttp = null;
        }

        if (smsLoginByOkHttp != null) {
            smsLoginByOkHttp.cancel();
            smsLoginByOkHttp = null;
        }

        if (smsLogin != null) {
            smsLogin.cancel();
            smsLogin = null;
        }

        if (bindMobilePhone != null) {
            bindMobilePhone.cancel();
            bindMobilePhone = null;
        }

        if (bindMobilePhoneByOkHttp != null) {
            bindMobilePhoneByOkHttp.cancel();
            bindMobilePhoneByOkHttp = null;
        }

        if (bindThirdToken != null) {
            bindThirdToken.cancel();
            bindThirdToken = null;
        }

        if (bindThirdTokenByOkHttp != null) {
            bindThirdTokenByOkHttp.cancel();
            bindThirdTokenByOkHttp = null;
        }

        if (guestLogin != null) {
            guestLogin.cancel();
            guestLogin = null;
        }

        if (guestLoginByOkhttp != null) {
            guestLoginByOkhttp.cancel();
            guestLoginByOkhttp = null;
        }
    }


    protected static native byte[] getOtp(long yyuid,
                                          //单位是s
                                          long createtime,
                                          byte[] credit,
                                          byte[] appid,
                                          byte[] descAppid,
                                          byte[] deviceId,
                                          byte[] nonce);

    protected static native byte[] getAntiParamForPcid();

}
