package com.yy.platform.loginlite;

import android.content.Context;
import android.util.Base64;
import android.util.Log;

import com.dw.android.itna.DwItna;
import com.dw.android.itna.YYDTCProtect;
import com.google.protobuf.ByteString;
import com.yy.platform.loginlite.proto.AntiGetSdkCodeReqHw;
import com.yy.platform.loginlite.proto.AntiGetSdkCodeRspHw;
import com.yy.platform.loginlite.proto.AntiVerifySdkResultReqHw;
import com.yy.platform.loginlite.proto.AntiVerifySdkResultRspHw;
import com.yy.platform.loginlite.utils.ServiceUrls;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AntiHelper {

    private static Executor executor;
    private static final int SUCCESS = 200;
    private static final int TIMEOUT = 10 * 1000;
    private static final int count = 3;

    protected static Executor getExecutor() {
        if (executor == null) {
            synchronized (AntiHelper.class) {
                if (executor == null) {
                    executor = new ThreadPoolExecutor(1, 2,
                            5, TimeUnit.SECONDS,
                            new LinkedBlockingQueue<Runnable>());
                }
            }
        }

        return executor;
    }

    public static int checkAntiCodeHw(long yyuid) {
        checkAntiCodeHwHttp(yyuid);
        return 0;
    }

    private static void runAntiCodeHwHttp(final long yyuid, final byte[] code) {
        final String bizName = AuthInfo.getAntiBizName();
        if (bizName == null || bizName.isEmpty()) {
            ALog.i("no anti bizName for run anticodeHw");
            return;
        }
        getExecutor().execute(new Runnable() {
            @Override
            public void run() {
                DwItna.setUdbId(AuthInfo.getHeader().getDeviceId());
                byte[] execCode = DwItna.exec(AuthInfo.getAppContext(),
                        code == null ? "".getBytes() : code,
                        AuthInfo.getAppId(), 0);
                byte[] token = AuthInfo.getServiceOtp(yyuid);
                AntiVerifySdkResultReqHw req = AntiVerifySdkResultReqHw.newBuilder()
                        .setBizName(bizName)
                        .setUid(yyuid)
                        .setResult(ByteString.copyFrom(execCode == null ? "".getBytes() : execCode))
                        .setIp(0)
                        .setTokenType(0)
                        .setToken(ByteString.copyFrom(token == null ? "".getBytes() : token))
                        .build();

                final String serverName = "svc_anti_codegetverify_service_hw";
                final String funcName = "AntiVerifySdkResultReqHw";

                for (int i = 0; i < count; i++) {
                    final String traceId = UUID.randomUUID().toString();
                    HttpURLConnection conn = null;
                    final String url = ServiceUrls.getHttpUrl() + serverName + "/" + funcName;
                    ALog.i("执行反外挂 yyuid:" + yyuid + ", traceId: " + traceId + ", url: " + url);
                    try {
                        URL httpURL = new URL(url);
                        conn = (HttpURLConnection) httpURL.openConnection();
                        conn.setRequestMethod(ServiceUrls.POST);
                        conn.setDoInput(true);
                        conn.setDoOutput(true);
                        conn.setConnectTimeout(TIMEOUT);
                        conn.setReadTimeout(TIMEOUT);

                        conn.addRequestProperty("Context", funcName);
                        conn.addRequestProperty("AppId", AuthInfo.getAppId());
                        conn.addRequestProperty("Uid", String.valueOf(yyuid));
                        conn.addRequestProperty("ServiceName", serverName);
                        conn.addRequestProperty("FunctionName", funcName);
                        conn.addRequestProperty("TraceId", traceId);
                        // conn.addRequestProperty("Content-Type", "application/yyrpc-pb");
                        conn.addRequestProperty("ProtoType", "http");
                        conn.addRequestProperty("InstId", funcName);
                        conn.addRequestProperty("ServerId", funcName);

                        OutputStream os = conn.getOutputStream();
                        req.writeTo(os);
                        conn.connect();

                        int code = conn.getResponseCode();
                        ALog.i("执行反外挂 http code: " + code);
                        AntiVerifySdkResultRspHw res = AntiVerifySdkResultRspHw.newBuilder()
                                .mergeFrom(conn.getInputStream()).build();
                        if (res != null) {
                            ALog.i("执行反外挂成功");
                            break;
                        } else {
                            ALog.i("执行反外挂失败");
                        }
                    } catch (IOException e) {
                        e.printStackTrace();
                        ALog.i("执行反外挂 exception:" + e.getMessage());
                    } finally {
                        if (conn != null) {
                            conn.disconnect();
                        }
                    }
                }

            }
        });
    }

    public static int checkAntiCodeHwHttp(final long yyuid) {
        String bizName = AuthInfo.getAntiBizName();
        if (bizName == null || bizName.isEmpty()) {
            ALog.i("no anti_hw bizName for check anticode");
            return -1;
        }
        final AntiGetSdkCodeReqHw req = AntiGetSdkCodeReqHw.newBuilder()
                .setBizName(bizName)
                .setUid(yyuid)
                .setIp(0)
                .build();
        final String serverName = "svc_anti_codegetverify_service_hw";
        final String funcName = "AntiGetSdkCodeReqHw";

        getExecutor().execute(new Runnable() {
            @Override
            public void run() {
                for (int i = 0; i < count; i++) {
                    final String traceId = UUID.randomUUID().toString();
                    HttpURLConnection conn = null;
                    final String url = ServiceUrls.getHttpUrl() + serverName + "/" + funcName;
                    ALog.i("风控 yyuid:" + yyuid + ", traceId: " + traceId + ", url: " + url);
                    try {
                        URL httpURL = new URL(url);
                        conn = (HttpURLConnection) httpURL.openConnection();
                        conn.setRequestMethod(ServiceUrls.POST);
                        conn.setDoInput(true);
                        conn.setDoOutput(true);
                        conn.setConnectTimeout(TIMEOUT);
                        conn.setReadTimeout(TIMEOUT);

                        conn.addRequestProperty("Context", funcName);
                        conn.addRequestProperty("AppId", AuthInfo.getAppId());
                        conn.addRequestProperty("Uid", String.valueOf(yyuid));
                        conn.addRequestProperty("ServiceName", serverName);
                        conn.addRequestProperty("FunctionName", funcName);
                        conn.addRequestProperty("TraceId", traceId);
                        conn.addRequestProperty("ProtoType", "http");
                        conn.addRequestProperty("InstId", funcName);
                        conn.addRequestProperty("ServerId", funcName);

                        OutputStream os = conn.getOutputStream();
                        req.writeTo(os);
                        conn.connect();

                        int code = conn.getResponseCode();
                        ALog.i("获取风控code http:" + code);
                        AntiGetSdkCodeRspHw res = AntiGetSdkCodeRspHw.newBuilder().
                                mergeFrom(conn.getInputStream()).build();
                        if (res != null) {
                            ALog.i("获取风控code成功");
                            //执行反外挂码
                            ByteString codeByte = res.getCode();
                            runAntiCodeHwHttp(res.getUid(),
                                    codeByte == null ? "".getBytes() : codeByte.toByteArray());
                            break;
                        } else {
                            ALog.i("获取风控code失败 ");
                        }
                    } catch (IOException e) {
                        e.printStackTrace();
                        String errInfo = "获取风控code connect exception, " + e.getMessage();
                        ALog.i(errInfo);
                    } finally {
                        if (conn != null) {
                            conn.disconnect();
                        }
                    }
                }
            }
        });
        return 1;
    }


    /**
     * 反外挂PCID加密接口
     * -------------------------------------------------------------------------
     */

    private final static String HEX = "0123456789ABCDEF";
    private static final int keyLenght = 16;
    private static final String defaultV = "0";

    /**
     * 从安全SDK获取PCID。
     * 因为安全sdk内部有持久化存取的操作，该接口有一定耗时，大约15ms左右
     * @param context
     * @return
     */
    @YYDTCProtect
    public static String getPcidDecode(Context context) {
        try {
//        String enjson = "JAAAAJdlCAAAABAREhMUFRYXEgAQAAAALjxNi9XVW1TgEG/Bd1q7Rg==";
            String enjson = new String(AuthCore.getAntiParamForPcid());
            byte[] tmpruncode = Base64.decode(enjson, Base64.DEFAULT);
            byte[] rs = DwItna.exec(context, tmpruncode);

            ALog.i(String.format("gjj===== runLocalCode rs len: %d", rs == null ? 0 : rs.length));
            ALog.i(String.format("gjj===== runLocalCode rs data: %s", tohexstring(rs)));

            if (rs != null && rs.length > 0) {
                String res = new String(rs);
                if (res.equals("UNKNOW"))
                    return null;
            }

            byte[] bytes_pcid = Base64.decode(tohexstring(rs), Base64.DEFAULT);

            byte[]  bts_Pcid = decrypt(toMakekey("UmpreU5rTTVSRU5GUVVJelJFTTVNdz09", keyLenght, defaultV).getBytes(), bytes_pcid);
            ALog.i(String.format("gjj===== runLocalCode rs data decode: %s", tohexstring(bts_Pcid)));
            if (bts_Pcid == null || bts_Pcid.length == 0) {
                return null;
            } else {
                return tohexstring(bts_Pcid);
            }
        } catch (Exception e) {
            ALog.i("<Anti> getPcidDecode() error!!");
            e.printStackTrace();
        }
        return null;
    }

    private static void appendHex(StringBuffer sb, byte b) {
        sb.append(HEX.charAt((b >> 4) & 0x0f)).append(HEX.charAt(b & 0x0f));
    }

    public static String tohexstring(byte[] buf){
        if (buf == null)
            return "";
        StringBuffer result = new StringBuffer(2 * buf.length);
        for (int i = 0; i < buf.length; i++) {
            result.append((char)buf[i]);
        }
        return result.toString();
    }

    public static String toHex(byte[] buf) {
        if (buf == null)
            return "";
        StringBuffer result = new StringBuffer(2 * buf.length);
        for (int i = 0; i < buf.length; i++) {
            appendHex(result, buf[i]);
        }
        return result.toString();
    }


    public static String toHex(String txt) {
        return toHex(txt.getBytes());
    }

    public static String decrypt(String key, String encrypted) throws Exception {
        byte[] rawKey = toMakekey(key, keyLenght, defaultV).getBytes();// key.getBytes();
        byte[] enc = toByte(encrypted);
        // enc = Base64.decode(enc, Base64.DEFAULT);
        byte[] result = decrypt(rawKey, enc);
        // /result = Base64.decode(result, Base64.DEFAULT);
        return new String(result, "utf-8");
    }

    private static byte[] decrypt(byte[] key, byte[] encrypted) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(Cipher.DECRYPT_MODE, skeySpec, new IvParameterSpec(new byte[cipher.getBlockSize()]));
        byte[] decrypted = cipher.doFinal(encrypted);
        return decrypted;
    }


    public static String encrypt(String key, String src) throws Exception {
        // /src = Base64.encodeToString(src.getBytes(), Base64.DEFAULT);
        byte[] rawKey = toMakekey(key, keyLenght, defaultV).getBytes();// key.getBytes();
        byte[] result = encrypt(rawKey, src.getBytes("utf-8"));
        Log.i("encrypt", " len:"+result.length);
        Log.i("encrypt", " base64:" + Base64.encodeToString(result, Base64.DEFAULT));
        // result = Base64.encode(result, Base64.DEFAULT);
        return toHex(result);
    }

    private static String toMakekey(String str, int strLength, String val) {

        int strLen = str.length();
        if (strLen < strLength) {
            while (strLen < strLength) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(str).append(val);
                str = buffer.toString();
                strLen = str.length();
            }
        }
        return str;
    }

    public static byte[] toByte(String hexString) {
        int len = hexString.length() / 2;
        byte[] result = new byte[len];
        for (int i = 0; i < len; i++)
            result[i] = Integer.valueOf(hexString.substring(2 * i, 2 * i + 2), 16).byteValue();
        return result;
    }


    private static byte[] encrypt(byte[] key, byte[] src) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(Cipher.ENCRYPT_MODE, skeySpec, new IvParameterSpec(new byte[cipher.getBlockSize()]));
        byte[] encrypted = cipher.doFinal(src);
        return encrypted;
    }
}
