/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud.video.serviceConfig;

import com.yy.yylivesdk4cloud.helper.ThunderLog;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class TranscodingConfigManager {
    private static final String TAG = "cfg_transcodingCfgMgr";
    private static final String TRANSCODING_MODE = "thunderBolt_transcoding_mode";
    private static final String JSONARRAY_NAME = "transcoding";
    private static final String MODE_NAME = "id";
    private static final String CFG_DESCRIPTION = "desc";
    private Map<Integer, String> mMode2CfgDesc = new HashMap<Integer, String>();
    private String mode = null;
    private String config = null;
    public static final String[] ARGO_CONFIG_KEYS = new String[]{"thunderBolt_transcoding_mode"};

    public static TranscodingConfigManager instance() {
        return SingletonHolder.INSTANCE;
    }

    public TranscodingConfigManager() {
        this.makeDefaultTranscodingCfg();
    }

    public void onConfig(String key, String config) {
        if (key == null || config == null) {
            return;
        }
        if (key.equals(TRANSCODING_MODE)) {
            this.parseTranscodingCfg(config);
        }
    }

    public String getTranscodingCfgByMode(int mode) {
        return this.mMode2CfgDesc.get(mode);
    }

    private void parseTranscodingCfg(String config) {
        try {
            JSONObject jsonObject = new JSONObject(config);
            JSONArray jsonArray = jsonObject.getJSONArray(JSONARRAY_NAME);
            this.mMode2CfgDesc = this.getTranscodingMode2Cfg(jsonArray);
        }
        catch (Exception e) {
            ThunderLog.error(TAG, " parseTranscodingCfg error :" + e.toString());
        }
    }

    private HashMap<Integer, String> getTranscodingMode2Cfg(JSONArray jsonArray) {
        StringBuffer sb = new StringBuffer();
        HashMap<Integer, String> mode2Cfg = new HashMap<Integer, String>();
        try {
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject item = jsonArray.getJSONObject(i);
                int mode = item.optInt(MODE_NAME);
                String cfgDesc = item.optJSONObject(CFG_DESCRIPTION).toString();
                mode2Cfg.put(mode, cfgDesc);
                sb.append("mode: " + String.valueOf(mode) + ", ");
                sb.append(" Cfg: " + cfgDesc + "; ");
            }
            ThunderLog.info(TAG, "getTranscodingMode2Cfg from argo size " + mode2Cfg.size() + ": " + sb.toString());
        }
        catch (Exception e) {
            ThunderLog.error(TAG, " parseTranscodingCfg error :" + e.toString());
        }
        return mode2Cfg;
    }

    private void makeDefaultTranscodingCfg() {
        String desc_180p = "{\"video\":{\"encode\":100,\"bitrate\":150,\"fps\":15,\"gop\":30,\"height\":180,\"width\":320},\"audio\":{\"encode\":1,\"bitrate\":128,\"sample\":44100,\"channel\":2}}";
        String desc_240p = "{\"video\":{\"encode\":100,\"bitrate\":200,\"fps\":15,\"gop\":30,\"height\":240,\"width\":320},\"audio\":{\"encode\":1,\"bitrate\":128,\"sample\":44100,\"channel\":2}}";
        String desc_360p = "{\"video\":{\"encode\":100,\"bitrate\":500,\"fps\":15,\"gop\":30,\"height\":360,\"width\":640},\"audio\":{\"encode\":1,\"bitrate\":128,\"sample\":44100,\"channel\":2}}";
        String desc_480p = "{\"video\":{\"encode\":100,\"bitrate\":500,\"fps\":15,\"gop\":30,\"height\":480,\"width\":640},\"audio\":{\"encode\":1,\"bitrate\":128,\"sample\":44100,\"channel\":2}}";
        String desc_540p = "{\"video\":{\"encode\":100,\"bitrate\":1000,\"fps\":24,\"gop\":48,\"height\":544,\"width\":960},\"audio\":{\"encode\":1,\"bitrate\":128,\"sample\":44100,\"channel\":2}}";
        String desc_720p = "{\"video\":{\"encode\":100,\"bitrate\":1600,\"fps\":24,\"gop\":48,\"height\":720,\"width\":1280},\"audio\":{\"encode\":1,\"bitrate\":128,\"sample\":44100,\"channel\":2}}";
        String desc_1080p = "{\"video\":{\"encode\":100,\"bitrate\":4500,\"fps\":24,\"gop\":48,\"height\":1080,\"width\":1920},\"audio\":{\"encode\":1,\"bitrate\":128,\"sample\":44100,\"channel\":2}}";
        this.mMode2CfgDesc.put(1, desc_180p);
        this.mMode2CfgDesc.put(2, desc_240p);
        this.mMode2CfgDesc.put(3, desc_360p);
        this.mMode2CfgDesc.put(4, desc_480p);
        this.mMode2CfgDesc.put(5, desc_540p);
        this.mMode2CfgDesc.put(6, desc_720p);
        this.mMode2CfgDesc.put(7, desc_1080p);
    }

    private static class SingletonHolder {
        private static final TranscodingConfigManager INSTANCE = new TranscodingConfigManager();

        private SingletonHolder() {
        }
    }
}

