/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud.video;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.provider.Settings;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ThunderVideoHiidoUtil {
    private static final String TAG = "ThunderVideoHiidoUtil";
    private Context mContext;
    private BatteryMonitor batteryMonitor;
    private IntentFilter filter;
    private static ContentResolver contentResolver;
    private static int current;
    private static LinkedHashMap<String, Object> mAudienceHashMap;
    private static LinkedHashMap<String, Object> mAnchorHashMap;
    private boolean mBatteryReceiverRegistered = false;
    private Object syncLock = new Object();

    public ThunderVideoHiidoUtil(Context context) {
        this.mContext = context;
        contentResolver = this.mContext.getContentResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() {
        IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        this.batteryMonitor = new BatteryMonitor();
        if (this.mContext != null) {
            Object object = this.syncLock;
            synchronized (object) {
                this.mContext.registerReceiver((BroadcastReceiver)this.batteryMonitor, filter);
                this.mBatteryReceiverRegistered = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegister() {
        if (this.mContext != null) {
            Object object = this.syncLock;
            synchronized (object) {
                if (this.mBatteryReceiverRegistered) {
                    this.mContext.unregisterReceiver((BroadcastReceiver)this.batteryMonitor);
                    this.mBatteryReceiverRegistered = false;
                }
            }
        }
        this.batteryMonitor = null;
        contentResolver = null;
        this.filter = null;
    }

    public static String getAnchorStatInfo() {
        mAnchorHashMap.put("dr39", ThunderVideoHiidoUtil.getCurrentBatteryState());
        mAnchorHashMap.put("dr40", ThunderVideoHiidoUtil.getSystemBrightness());
        return ThunderVideoHiidoUtil.getParamsOrderByKey(mAudienceHashMap);
    }

    public static String getAudienceStatInfo() {
        mAudienceHashMap.put("dr39", ThunderVideoHiidoUtil.getCurrentBatteryState());
        mAudienceHashMap.put("dr40", ThunderVideoHiidoUtil.getSystemBrightness());
        return ThunderVideoHiidoUtil.getParamsOrderByKey(mAudienceHashMap);
    }

    private static String getParamsOrderByKey(Map<String, Object> paramValues) {
        String params = "";
        if (paramValues != null) {
            ArrayList<String> paramNames = new ArrayList<String>(paramValues.size());
            paramNames.addAll(paramValues.keySet());
            Collections.sort(paramNames);
            for (String paramName : paramNames) {
                params = params + "&" + paramName + "=" + paramValues.get(paramName);
            }
        }
        return params;
    }

    private static int getCurrentBatteryState() {
        if (current < 0) {
            return 0;
        }
        return current;
    }

    private static int getSystemBrightness() {
        int systemBrightness = 0;
        try {
            if (contentResolver != null) {
                systemBrightness = Settings.System.getInt((ContentResolver)contentResolver, (String)"screen_brightness");
            }
        }
        catch (Settings.SettingNotFoundException e) {
            ThunderLog.release(TAG, "get SCREEN_BRIGHTNESS:" + e.getMessage());
        }
        return systemBrightness;
    }

    static {
        current = 0;
        mAudienceHashMap = new LinkedHashMap();
        mAnchorHashMap = new LinkedHashMap();
    }

    private class BatteryMonitor
    extends BroadcastReceiver {
        private BatteryMonitor() {
        }

        public void onReceive(Context context, Intent intent) {
            current = intent.getExtras().getInt("level");
        }
    }

    private static interface AudienceHiidoStatInfoKey {
        public static final String BatteryState = "dr39";
        public static final String ScreenBrightness = "dr40";
    }

    private static interface AnchorHiidoStatInfoKey {
        public static final String BatteryState = "dr39";
        public static final String ScreenBrightness = "dr40";
    }
}

