/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.util.Log;
import com.yy.yylivesdk4cloud.ITransConfigCallbackInterface;
import com.yy.yylivesdk4cloud.ITransJsonParseInterface;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONObject;

public class TransJsonParseImp
implements ITransJsonParseInterface {
    private static final String TAG = "TransJsonParseImp";
    private HandlerThread mProcessTransJsonParseThread;
    private Handler mProcessTransJsonParseHandler;
    private ITransConfigCallbackInterface mCallback;
    private boolean mReady = false;
    private static final int MESSAGE_COMMON_CONFIG = 0;

    public TransJsonParseImp(ITransConfigCallbackInterface callBack) {
        this.mCallback = callBack;
        this.mProcessTransJsonParseThread = new HandlerThread("TransJsonParseThread");
        this.mProcessTransJsonParseThread.start();
        this.mProcessTransJsonParseHandler = new Handler(this.mProcessTransJsonParseThread.getLooper()){

            public void handleMessage(Message msg) {
                if (!TransJsonParseImp.this.mReady) {
                    ThunderLog.warn(TransJsonParseImp.TAG, " mProcessTransJsonParseThread not Ready !");
                    return;
                }
                try {
                    String data = (String)msg.obj;
                    switch (msg.what) {
                        case 0: {
                            TransJsonParseImp.this.handleParseCommonConfig(data);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    ThunderLog.error(TransJsonParseImp.TAG, " mProcessTransJsonParseThread deal error :" + e.toString());
                }
            }
        };
        this.mReady = true;
    }

    private void handleParseCommonConfig(String config) {
        if (config == null || config.isEmpty()) {
            return;
        }
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        try {
            JSONObject configJson = new JSONObject(config);
            Iterator iterator = configJson.keys();
            while (iterator.hasNext()) {
                String keyStr = iterator.next().toString();
                int key = (int)Long.parseLong(keyStr);
                int val = (int)configJson.getLong(keyStr);
                result.put(key, val);
                Log.d((String)TAG, (String)String.format("key:%d, val:%d", key, val));
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("error" + e.toString()));
            return;
        }
        this.mCallback.notifyCommonConfigResult(result);
    }

    @Override
    public void parseCommonConfig(String response) {
        if (this.mReady) {
            Message msg = Message.obtain();
            msg.what = 0;
            msg.obj = response;
            this.mProcessTransJsonParseHandler.sendMessage(msg);
        }
    }
}

