/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import android.graphics.Bitmap;
import android.graphics.Rect;
import com.yy.mediaframework.gpuimage.custom.OrangeFilterWrapper;
import com.yy.yylivesdk4cloud.ThunderAudioCapture;
import com.yy.yylivesdk4cloud.ThunderBridgeLib;
import com.yy.yylivesdk4cloud.ThunderChannelLayout;
import com.yy.yylivesdk4cloud.ThunderDefaultCamera;
import com.yy.yylivesdk4cloud.ThunderDefaultMic;
import com.yy.yylivesdk4cloud.ThunderLayout;
import com.yy.yylivesdk4cloud.ThunderPreviewView;
import com.yy.yylivesdk4cloud.ThunderPublishAudioConfig;
import com.yy.yylivesdk4cloud.ThunderPublishInfo;
import com.yy.yylivesdk4cloud.ThunderPublishRoom;
import com.yy.yylivesdk4cloud.ThunderPublishVideoConfig;
import com.yy.yylivesdk4cloud.ThunderVideoCapture;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;
import java.util.ArrayList;
import java.util.HashMap;

class ThunderPublishRoomImp
implements ThunderPublishRoom {
    private ThunderVideoCapture mVideoCapture = null;
    private ThunderAudioCapture mAudioCapture = null;
    private ThunderDefaultCamera mDefaultCamera = new ThunderDefaultCamera();
    private ThunderDefaultMic mDefaultMic = new ThunderDefaultMic();
    private String mChannelId = null;
    private long mUid = 0L;
    private boolean mOwner = false;
    private boolean mPublishing = false;
    private boolean mAudioOnly = false;
    private boolean mEnableVideo = false;
    private boolean mEnableAudio = false;
    private int mPublishMode = -1;
    private int mPlayType = 0;
    private int mCamaraPosition = 0;
    private int mPubOrientation = 0;
    private int mChannelProfile = 0;
    private int mAudioProfile = 0;
    private int mCommunitMode = 0;
    private int mScenarioMode = 0;

    ThunderPublishRoomImp() {
    }

    @Override
    public int startVideoPreview(int playType, int publishMode) {
        this.mPlayType = playType;
        this.mPublishMode = publishMode;
        ThunderLog.info("ycall-Java", "startVideoPreview ");
        int convertType = this.convertPlayType(playType);
        return ThunderNative.startVideoPreview(convertType, publishMode);
    }

    @Override
    public int stopVideoPreview() {
        ThunderLog.info("ycall-Java", "stopVideoPreview");
        return ThunderNative.stopVideoPreview();
    }

    @Override
    public int startLiveInteract(ThunderLayout layout) {
        if (this.mChannelId == null) {
            ThunderLog.info("ycall-Java", "startLiveInteract roomId null");
            return -1;
        }
        if (layout == null) {
            ThunderLog.info("ycall-Java", "startLiveInteract layout error");
            return -1;
        }
        if (layout.layouts.size() == 0 || layout.speakers.size() == 0) {
            ThunderLog.info("ycall-Java", "startLiveInteract param error");
            return -1;
        }
        this.mAudioOnly = false;
        this.mPlayType = 1;
        ThunderPublishVideoConfig videoConfig = this.convertVideoConfig();
        ThunderPublishAudioConfig audioConfig = this.convertAudioConfig();
        if (layout.layouts.size() == 1) {
            ThunderChannelLayout channelLayout = layout.layouts.get(0);
            if (this.mPublishing) {
                ThunderNative.updatePublishLive(channelLayout.roomId, true, videoConfig, audioConfig, layout);
            } else {
                this.mPublishing = true;
                if (this.mAudioCapture == null) {
                    ThunderNative.attachAudioCapture(this.mDefaultMic);
                }
                ThunderNative.startPublishLive(channelLayout.roomId, true, videoConfig, audioConfig, layout);
            }
            this.mOwner = channelLayout.owner;
        } else {
            for (ThunderChannelLayout channelLayout : layout.layouts) {
                ThunderLayout liveLayout = this.convertLayout(layout, channelLayout);
                ThunderNative.updatePublishLive(channelLayout.roomId, false, videoConfig, audioConfig, liveLayout);
            }
            this.mOwner = true;
        }
        ThunderLog.info("ycall-Java", "startLiveInteract %s", layout.toString());
        return 0;
    }

    @Override
    public int stopLiveInteract() {
        ThunderLog.info("ycall-Java", "stopLiveInteract %b", this.mOwner);
        if (this.mOwner) {
            this.mAudioOnly = false;
            this.mPlayType = 0;
            ThunderPublishVideoConfig videoConfig = this.convertVideoConfig();
            ThunderPublishAudioConfig audioConfig = this.convertAudioConfig();
            ThunderLayout layout = this.makeLayout(null);
            return ThunderNative.updatePublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
        }
        return this.stopSinglePublish();
    }

    @Override
    public int startAudioInteract(ArrayList<String> speakers) {
        if (this.mChannelId == null) {
            ThunderLog.info("ycall-Java", "startAudioInteract roomId null");
            return -1;
        }
        if (speakers == null) {
            ThunderLog.info("ycall-Java", "startAudioInteract speakers error");
            return -1;
        }
        this.mAudioOnly = true;
        this.mPlayType = 0;
        ThunderPublishVideoConfig videoConfig = this.convertVideoConfig();
        ThunderPublishAudioConfig audioConfig = this.convertAudioConfig();
        ThunderLayout layout = this.makeLayout(speakers);
        if (this.mPublishing) {
            ThunderNative.updatePublishLive(this.mChannelId, true, videoConfig, audioConfig, layout);
        } else {
            this.mPublishing = true;
            if (this.mAudioCapture == null) {
                ThunderNative.attachAudioCapture(this.mDefaultMic);
            }
            videoConfig.encodeResolutionHeight = 0;
            videoConfig.encodeResolutionWidth = 0;
            ThunderNative.startPublishLive(this.mChannelId, true, videoConfig, audioConfig, layout);
        }
        ThunderChannelLayout channelLayout = layout.getChannelLayout(0);
        this.mOwner = channelLayout.owner;
        ThunderLog.info("ycall-Java", "startAudioInteract %s", layout.toString());
        return 0;
    }

    @Override
    public int stopAudioInteract() {
        ThunderLog.info("ycall-Java", "stopAudioInteract %b", this.mOwner);
        if (this.mOwner) {
            this.mAudioOnly = false;
            this.mPlayType = 0;
            ThunderPublishVideoConfig videoConfig = this.convertVideoConfig();
            ThunderPublishAudioConfig audioConfig = this.convertAudioConfig();
            ThunderLayout layout = this.makeLayout(null);
            return ThunderNative.updatePublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
        }
        return this.stopSinglePublish();
    }

    @Override
    public int startSinglePublish(int playType, int publishMode) {
        if (this.mUid == 0L) {
            return 0;
        }
        if (this.mChannelId == null) {
            ThunderLog.info("ycall-Java", "startPublish roomId null");
            return -1;
        }
        this.mPlayType = playType;
        this.mPublishMode = publishMode;
        this.mPublishing = true;
        this.mAudioOnly = false;
        this.mOwner = true;
        if (this.mAudioCapture == null) {
            ThunderNative.attachAudioCapture(this.mDefaultMic);
        }
        ThunderPublishVideoConfig videoConfig = this.convertVideoConfig();
        ThunderPublishAudioConfig audioConfig = this.convertAudioConfig();
        ThunderLayout layout = this.makeLayout(null);
        ThunderLog.info("ycall-Java", "startPublish %s", layout.toString());
        return ThunderNative.startPublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
    }

    @Override
    public int setLocalVideoView(ThunderPreviewView view) {
        ThunderLog.info("ycall-Java", "setLocalVideoCanvas");
        return ThunderNative.setLocalVideoView(view);
    }

    @Override
    public int stopSinglePublish() {
        ThunderLog.info("ycall-Java", "stopPublish %s", this.mChannelId);
        if (this.mChannelId == null) {
            return 0;
        }
        this.mPublishing = false;
        this.mOwner = false;
        this.mAudioOnly = false;
        return ThunderNative.stopPublishLive(this.mChannelId);
    }

    @Override
    public int updatePublishMode(int publishMode) {
        if (this.mPublishMode == publishMode) {
            ThunderLog.info("ycall-Java", "updatePublishMode ignore same");
            return 0;
        }
        if (!this.mPublishing) {
            this.mPublishMode = publishMode;
            ThunderLog.info("ycall-Java", "updatePublishMode not publishing");
            return 0;
        }
        boolean bSuport = false;
        int convertType = this.convertPlayType(this.mPlayType);
        HashMap<Integer, String> modeMap = ThunderNative.getSupportModeInfoWithPlayType(convertType);
        if (modeMap.size() == 0) {
            ThunderLog.info("ycall-Java", "updatePublishMode empty");
            return -1;
        }
        for (Integer key : modeMap.keySet()) {
            if (key != publishMode) continue;
            bSuport = true;
            break;
        }
        if (bSuport) {
            this.mPublishMode = publishMode;
            ThunderPublishVideoConfig videoConfig = this.convertVideoConfig();
            if (this.mPlayType == 1) {
                ThunderNative.updateVideoConfig(videoConfig);
                return 0;
            }
            ThunderPublishAudioConfig audioConfig = this.convertAudioConfig();
            ThunderLayout layout = this.makeLayout(null);
            ThunderNative.updatePublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
        }
        ThunderLog.info("ycall-Java", "updatePublishMode %d %b", publishMode, bSuport);
        return 0;
    }

    @Override
    public HashMap<Integer, String> getPublishMode(int playType) {
        int convertType = this.convertPlayType(playType);
        return ThunderNative.getSupportModeInfoWithPlayType(convertType);
    }

    @Override
    public int getDefaultPublishMode(int playType) {
        int convertType = this.convertPlayType(playType);
        return ThunderNative.getDefaultPublishVideoMode(convertType);
    }

    @Override
    public ThunderPublishInfo getCurrentPublishInfo() {
        ThunderPublishInfo publishInfo = ThunderNative.getPublishInfo();
        if (publishInfo != null) {
            publishInfo.publishOrientation = this.mPubOrientation;
            publishInfo.cameraPosition = this.mCamaraPosition;
        }
        return publishInfo;
    }

    @Override
    public boolean setCameraPosition(int position) {
        this.mCamaraPosition = position;
        ThunderLog.info("ycall-Java", "setCameraPosition %d", position);
        return ThunderNative.setCameraPosition(position);
    }

    @Override
    public void setPublishOrientation(int orientation) {
        this.mPubOrientation = orientation;
        ThunderNative.setOrientation(orientation);
    }

    @Override
    public int setWatermark(int posX, int posY, Bitmap image) {
        ThunderLog.info("ycall-Java", "setWatermark in (%d,%d)", posX, posY);
        return ThunderNative.setWatermark(posX, posY, image);
    }

    @Override
    public int setFaceBeautyLevel(float level) {
        if (level >= 1.000001f) {
            level = 1.0f;
        } else if (level < 1.0E-6f) {
            level = 0.0f;
        }
        ThunderLog.info("ycall-Java", "setFaceBeautyLevel %f", Float.valueOf(level));
        return ThunderNative.setFaceBeautyLevel(level);
    }

    @Override
    public boolean setMicVolume(int volume) {
        if (volume < 0) {
            volume = 0;
        } else if (volume > 100) {
            volume = 100;
        }
        ThunderLog.info("ycall-Java", "setMicVolume %d", volume);
        return ThunderNative.setMicVolume(volume);
    }

    @Override
    public OrangeFilterWrapper getBeautyFilter() {
        return ThunderBridgeLib.getInstance().getBeautyFilter();
    }

    public ThunderDefaultMic getDefaluteMic() {
        return this.mDefaultMic;
    }

    @Override
    public void attachAudioCapture(ThunderAudioCapture capture) {
        this.mAudioCapture = capture == null ? this.mDefaultMic : capture;
        ThunderLog.info("ycall-Java", "attachAudioCapture %s", this.mAudioCapture.toString());
        ThunderNative.attachAudioCapture(this.mAudioCapture);
    }

    @Override
    public void attachVideoCapture(ThunderVideoCapture capture) {
        this.mVideoCapture = capture;
        ThunderLog.info("ycall-Java", "attachVideoCapture %s", this.mVideoCapture.toString());
        ThunderNative.attachVideoCapture(this.mVideoCapture);
    }

    @Override
    public void setChannelId(String channelId) {
        this.mChannelId = channelId;
    }

    @Override
    public void syncUserInfo(long uid, int userRole) {
        ThunderLog.info("ycall-Java", "syncUserInfo" + uid);
        this.mUid = uid;
    }

    @Override
    public void updateProfile(int channelProfile, int audioProfile, int commutMode, int scenarioMode) {
        this.mChannelProfile = channelProfile;
        this.mAudioProfile = audioProfile;
        this.mCommunitMode = commutMode;
        this.mScenarioMode = scenarioMode;
    }

    @Override
    public int startCapture() {
        ThunderLog.info("ycall-Java", "start capture");
        return ThunderNative.startCapture();
    }

    @Override
    public int stopCapture() {
        ThunderLog.info("ycall-Java", "stop capture");
        return ThunderNative.stopCapture();
    }

    private ThunderPublishVideoConfig convertVideoConfig() {
        int convertType = this.convertPlayType(this.mPlayType);
        ThunderPublishVideoConfig config = ThunderNative.getRemoteVideoConfig(convertType, this.mPublishMode);
        return config;
    }

    private ThunderPublishAudioConfig convertAudioConfig() {
        ThunderPublishAudioConfig config = new ThunderPublishAudioConfig(5);
        config.bUseAudioProfile = true;
        config.audioConfig = this.mAudioProfile;
        config.commutMode = this.mCommunitMode;
        config.scenarioMode = this.mScenarioMode;
        config.roomConfig = this.mChannelProfile;
        return config;
    }

    private ThunderLayout convertLayout(ThunderLayout liveLayout, ThunderChannelLayout channelLayout) {
        ArrayList<ThunderChannelLayout> layouts = new ArrayList<ThunderChannelLayout>();
        layouts.add(channelLayout);
        ThunderLayout layout = new ThunderLayout();
        layout.width = liveLayout.width;
        layout.height = liveLayout.height;
        layout.layouts = layouts;
        layout.speakers = liveLayout.speakers;
        return layout;
    }

    private ThunderLayout makeLayout(ArrayList<String> speakers) {
        int convertType = this.convertPlayType(this.mPlayType);
        ThunderPublishVideoConfig config = ThunderNative.getRemoteVideoConfig(convertType, this.mPublishMode);
        Rect rect = new Rect(0, 0, config.encodeResolutionWidth, config.encodeResolutionHeight);
        ThunderChannelLayout channelLayout = new ThunderChannelLayout();
        channelLayout.roomId = this.mChannelId;
        channelLayout.layoutNo = 0;
        channelLayout.layout = rect;
        ArrayList<ThunderChannelLayout> layouts = new ArrayList<ThunderChannelLayout>();
        layouts.add(channelLayout);
        ThunderLayout layout = new ThunderLayout();
        layout.width = 0;
        layout.height = 0;
        layout.layouts = layouts;
        if (speakers == null || speakers.isEmpty()) {
            channelLayout.owner = true;
            ArrayList<String> spk = new ArrayList<String>();
            spk.add(String.valueOf(this.mUid));
            layout.speakers = spk;
        } else {
            channelLayout.owner = this.mPublishing;
            layout.speakers = speakers;
        }
        return layout;
    }

    private int convertPlayType(int playType) {
        if (this.mAudioOnly) {
            return 0;
        }
        switch (playType) {
            case 0: {
                playType = 0;
                break;
            }
            case 1: {
                playType = 1;
                break;
            }
            case 2: {
                playType = 5;
                break;
            }
        }
        return playType;
    }

    @Override
    public void setAudioEnable(boolean enableAudio) {
        if (this.mUid == 0L) {
            return;
        }
        if (this.mEnableAudio == enableAudio) {
            return;
        }
        this.mEnableAudio = enableAudio;
        if (enableAudio) {
            ThunderNative.setAudioSourceType(0);
            if (this.mEnableVideo) {
                this.mAudioOnly = false;
                this.startSinglePublish(this.mPlayType, this.mPublishMode);
            } else {
                this.mAudioOnly = true;
                ThunderPublishAudioConfig audioConfig = this.convertAudioConfig();
                ThunderPublishVideoConfig videoConfig = new ThunderPublishVideoConfig();
                ThunderLayout layout = this.makeLayout(null);
                if (this.mAudioCapture == null) {
                    ThunderNative.attachAudioCapture(this.mDefaultMic);
                }
                ThunderNative.startPublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
                this.mPublishing = true;
            }
        } else {
            this.mAudioOnly = false;
            if (this.mEnableVideo) {
                ThunderPublishAudioConfig audioConfig = this.convertAudioConfig();
                ThunderPublishVideoConfig videoConfig = this.convertVideoConfig();
                ThunderLayout layout = this.makeLayout(null);
                ThunderNative.stopPublishAudio();
                ThunderNative.updatePublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
            } else {
                ThunderNative.stopPublishLive(this.mChannelId);
                this.mPublishing = false;
            }
        }
    }

    @Override
    public void setVideoEnable(boolean enableVideo) {
        if (this.mUid == 0L) {
            return;
        }
        if (enableVideo == this.mEnableVideo) {
            return;
        }
        this.mEnableVideo = enableVideo;
        if (enableVideo) {
            this.mAudioOnly = false;
            if (this.mEnableAudio) {
                this.startSinglePublish(this.mPlayType, this.mPublishMode);
            } else {
                ThunderPublishVideoConfig videoConfig = this.convertVideoConfig();
                ThunderPublishAudioConfig audioConfig = new ThunderPublishAudioConfig(0);
                ThunderLayout layout = this.makeLayout(null);
                ThunderNative.startPublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
                this.mPublishing = true;
            }
        } else if (this.mEnableAudio) {
            this.mAudioOnly = true;
            ThunderPublishVideoConfig videoConfig = new ThunderPublishVideoConfig();
            ThunderPublishAudioConfig audioConfig = this.convertAudioConfig();
            ThunderLayout layout = this.makeLayout(null);
            ThunderNative.stopPublishVideo();
            ThunderNative.updatePublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
        } else {
            this.mAudioOnly = false;
            ThunderNative.stopPublishLive(this.mChannelId);
            this.mPublishing = false;
        }
    }

    @Override
    public int updatePlayTypeAndPublishMode(int playType, int publishMode) {
        if (this.mPlayType == playType && this.mPublishMode == publishMode) {
            ThunderLog.info("ycall-Java", "updatePlayTypeAndPublishMode ignore same");
            return 0;
        }
        boolean bSupport = this.isPublishParamValid(playType, publishMode);
        ThunderLog.info("ycall-Java", "updatePlayTypeAndPublishMode %d %d %b", playType, publishMode, bSupport);
        if (!bSupport) {
            return -1;
        }
        if (this.mEnableVideo) {
            this.mPlayType = playType;
            this.mPublishMode = publishMode;
            ThunderPublishVideoConfig videoConfig = this.convertVideoConfig();
            ThunderPublishAudioConfig audioConfig = this.convertAudioConfig();
            ThunderLayout layout = this.makeLayout(null);
            ThunderNative.updatePublishLive(this.mChannelId, false, videoConfig, audioConfig, layout);
        } else {
            this.mPlayType = playType;
            this.mPublishMode = publishMode;
            ThunderPublishVideoConfig videoConfig = this.convertVideoConfig();
            ThunderNative.updateVideoConfig(videoConfig);
        }
        return 0;
    }

    private boolean isPublishParamValid(int playType, int publishMode) {
        int convertType = this.convertPlayType(playType);
        HashMap<Integer, String> modeMap = ThunderNative.getSupportModeInfoWithPlayType(convertType);
        if (modeMap.size() == 0) {
            ThunderLog.info("ycall-Java", "updatePlayTypeAndPublishMode empty");
            return false;
        }
        if (publishMode == -1) {
            return true;
        }
        for (Integer key : modeMap.keySet()) {
            if (key != publishMode) continue;
            return true;
        }
        return false;
    }
}

