/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.SurfaceView;
import android.widget.FrameLayout;
import com.yy.mediaframework.facedetection.IFaceDetection;
import com.yy.mediaframework.gpuimage.custom.IGPUProcess;
import com.yy.yylivesdk4cloud.ExternalAudioSource;
import com.yy.yylivesdk4cloud.ExternalVideoSource;
import com.yy.yylivesdk4cloud.IThunderLogCallback;
import com.yy.yylivesdk4cloud.LiveTranscoding;
import com.yy.yylivesdk4cloud.ScreenRecordSource;
import com.yy.yylivesdk4cloud.ThunderAPI;
import com.yy.yylivesdk4cloud.ThunderAudioFilePlayer;
import com.yy.yylivesdk4cloud.ThunderBoltImage;
import com.yy.yylivesdk4cloud.ThunderCustomVideoSource;
import com.yy.yylivesdk4cloud.ThunderDefaultCamera;
import com.yy.yylivesdk4cloud.ThunderEventHandler;
import com.yy.yylivesdk4cloud.ThunderGroup;
import com.yy.yylivesdk4cloud.ThunderNotification;
import com.yy.yylivesdk4cloud.ThunderPlayerView;
import com.yy.yylivesdk4cloud.ThunderPreviewConfig;
import com.yy.yylivesdk4cloud.ThunderPreviewView;
import com.yy.yylivesdk4cloud.ThunderPublishAudioConfig;
import com.yy.yylivesdk4cloud.ThunderStream;
import com.yy.yylivesdk4cloud.ThunderVideoCanvas;
import com.yy.yylivesdk4cloud.ThunderVideoEncoderConfiguration;
import com.yy.yylivesdk4cloud.audio.IAudioFrameObserver;
import com.yy.yylivesdk4cloud.helper.ThunderHttpsRequestHandler;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;
import com.yy.yylivesdk4cloud.helper.UidMap;
import com.yy.yylivesdk4cloud.video.IVideoCaptureObserver;
import com.yy.yylivesdk4cloud.video.IVideoDecodeObserver;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONObject;

public class ThunderEngine {
    private static final String TAG = "RtcEngine";
    private static boolean mIsInited = false;
    private static int sMyAppId = 0;
    private static long sMySceneId = 0L;
    private static ThunderEventHandler mRtcEventHandler;
    private static ThunderHttpsRequestHandler mHttpsRequestHandler;
    private static int mServiceLinkStatus;
    private static int mTransLinkStatus;
    private long mMyUid = 0L;
    private boolean mIs32bitUid = false;
    private String mMyStrUid = "";
    private boolean mIsUserBanned = false;
    private byte[] mToken;
    private static String mLogPath;
    private static int mLogLevel;
    private static IThunderLogCallback mYyLogCallback;
    private boolean mBGroupSubscribe = false;
    private boolean mBAudioPublish = false;
    private boolean mBVideoPublish = false;
    private String mStringName = "";
    private String mVideoStringName = "";
    private int mRoomAppId = 0;
    private String mRoomName = "";
    private int mRoomConfig = 0;
    private int mAudioConfig = 0;
    private int mCommutMode = 0;
    private int mScenarioMode = 0;
    private boolean mBEnablePlayDataIndication = false;
    private static int s_playVolumeNotifyCount;
    private static int s_playDataNotifyCount;
    private static NotificationHandler mHandler;
    private int[] mEqGains = new int[11];
    private boolean mBEnableEqualizer = false;
    private boolean mBEnableCompressor = false;
    private boolean mBEnableLimiter = false;
    private boolean mBEnableReverbEx = false;
    private ReverbExParameter mReverbExGains = new ReverbExParameter();
    private CompressorParam mCompressorGains = new CompressorParam();
    private LimterParam mLimiterGins = new LimterParam();
    private boolean mBOnlyReleaseCamera = false;
    private Set<ThunderAudioFilePlayer> mAudioFilePlayerSet = new TreeSet<ThunderAudioFilePlayer>();
    private Boolean isJoinRoom = false;
    private Boolean isThunder = false;
    private Boolean isBoltJoin = false;
    private Boolean isEnableAudio = true;
    private Boolean isEnableVideo = true;
    private Boolean isStopAllVideo = false;
    private Boolean isStopAllAudio = false;
    private Boolean isStopLocalVideo = false;
    private Boolean isPreview = false;
    private Boolean isOtherSource = false;
    private Boolean needNotify = false;
    private int accompanyType = -1;
    private static Context appContext;
    private SurfaceView rtcSurfaceView = null;
    private long joinStart = 0L;
    private long joinEnd = 0L;
    private static ThunderPreviewView mLocalPreviewView;
    private ArrayList<ThunderVideoCanvas> remoteCanvas = new ArrayList(0);
    private int thunderBoltProfile = 0;
    private int playType = 0;
    private int resolutionMode = -1;
    private ThunderVideoEncoderConfiguration mThunderVideoEncoderConfiguration = new ThunderVideoEncoderConfiguration();
    private ArrayList<ThunderStream> anchorStreams = new ArrayList(0);
    private ArrayList<ThunderStream> wholeStreams = new ArrayList(0);
    private Map<String, ArrayList<ThunderStream>> channelStreamsList = new HashMap<String, ArrayList<ThunderStream>>();
    private Map<String, Set<String>> subscribeStreamMap = new HashMap<String, Set<String>>();
    private Map<String, Boolean> uidMuteVideoList = new HashMap<String, Boolean>();
    private Map<String, Boolean> uidMuteAudioList = new HashMap<String, Boolean>();
    private final Object streamLock = new Object();
    private ExternalAudioSource mAudioSource = null;
    private boolean mTbSubscribeGroup = false;
    private boolean mTbPublishGroup = false;
    private boolean mRecv64UidMap = false;
    private boolean mIsFrontCamera = true;

    public String getRoomName() {
        return this.mRoomName;
    }

    public String getMyUid() {
        return this.mMyStrUid;
    }

    private ThunderEngine() {
    }

    private static synchronized ThunderEngine createRtcEngine(Context context, String appId, long sceneId, ThunderEventHandler handler) {
        if (SingleonHolder.INSTANCE == null) {
            SingleonHolder.INSTANCE = new ThunderEngine();
        }
        if (!mIsInited) {
            mRtcEventHandler = handler;
            mHttpsRequestHandler = new ThunderHttpsRequestHandler();
            sMyAppId = Integer.parseInt(appId);
            sMySceneId = sceneId;
            System.loadLibrary("ffmpeg-neon");
            System.loadLibrary("Ittiamhevcdec");
            ThunderAPI.sharedInstance().initWithAppId(sMyAppId, sMySceneId, context);
            mIsInited = true;
        }
        return SingleonHolder.INSTANCE;
    }

    public static synchronized ThunderEngine createEngine(Context context, String appId, long sceneId, ThunderEventHandler handler) {
        ThunderEngine rtcEngine = ThunderEngine.createRtcEngine(context, appId, sceneId, handler);
        if (mHandler == null) {
            mHandler = new NotificationHandler(rtcEngine);
        }
        appContext = context;
        return rtcEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStreamsNotify(ThunderNotification.StreamsNotify streamInfo) {
        ArrayList<ThunderStream> curChannelStreams = streamInfo.getStreams();
        if (curChannelStreams == null) {
            return;
        }
        ThunderAPI.sharedInstance().handleTrancodingQuerySubscribeStream(streamInfo);
        ArrayList<ThunderStream> addStreams = new ArrayList<ThunderStream>();
        ArrayList<ThunderStream> removeStreams = new ArrayList<ThunderStream>();
        Object object = this.streamLock;
        synchronized (object) {
            Iterator<ThunderStream> it = curChannelStreams.iterator();
            while (it.hasNext()) {
                Set<String> streamSet;
                Iterator<ThunderStream> strUid;
                ThunderStream stream = it.next();
                if (!stream.strUid.equals(this.mMyStrUid) && stream.speakerUid == this.mMyUid) {
                    ThunderLog.release("yrtc", "onStreamsNotify: duplicated uid=" + stream.speakerUid + " speakerStrUid=" + stream.strUid + " myStrUid=" + this.mMyStrUid);
                    ThunderNative.duplicatedUid(stream.speakerUid, stream.strUid);
                    return;
                }
                if (stream.strUid.length() > 0) {
                    this.addUid2String(stream.speakerUid, stream.strUid);
                }
                if (this.mMyStrUid.equals(strUid = UidMap.getStringUid(stream.speakerUid))) {
                    it.remove();
                    continue;
                }
                if (streamInfo.getRoomId().equals(this.mRoomName) || (streamSet = this.subscribeStreamMap.get(streamInfo.getRoomId())) != null && !streamSet.isEmpty() && (streamSet == null || streamSet.contains(strUid))) continue;
                it.remove();
            }
            ArrayList<ThunderStream> oldStreamsInChannel = this.channelStreamsList.get(streamInfo.getRoomId());
            if (oldStreamsInChannel != null) {
                boolean isFind;
                for (ThunderStream newStream : curChannelStreams) {
                    isFind = false;
                    for (ThunderStream oldStream : oldStreamsInChannel) {
                        if (!newStream.streamName.equals(oldStream.streamName)) continue;
                        isFind = true;
                    }
                    if (isFind) continue;
                    addStreams.add(newStream);
                }
                for (ThunderStream oldStream : oldStreamsInChannel) {
                    isFind = false;
                    for (ThunderStream newStream : curChannelStreams) {
                        if (!newStream.streamName.equals(oldStream.streamName)) continue;
                        isFind = true;
                    }
                    if (isFind) continue;
                    removeStreams.add(oldStream);
                    if (!this.anchorStreams.contains(oldStream)) continue;
                    this.anchorStreams.remove(oldStream);
                }
            } else {
                addStreams.addAll(curChannelStreams);
            }
            this.isJoinRoom = true;
            this.notifyJoinSuccess();
            for (ThunderStream stream : removeStreams) {
                if (stream.bVideo) {
                    ThunderLog.release("yrtc", "onRemoteVideoStopped id:" + stream.speakerUid + " isStop:" + true);
                    mRtcEventHandler.onRemoteVideoStopped(UidMap.getStringUid(stream.speakerUid), true);
                    continue;
                }
                ThunderLog.release("yrtc", "onRemoteAudioStopped id:" + stream.speakerUid + " isStop:" + true);
                mRtcEventHandler.onRemoteAudioStopped(UidMap.getStringUid(stream.speakerUid), true);
            }
            for (ThunderStream stream : addStreams) {
                if (stream.bVideo) {
                    ThunderLog.release("yrtc", "onRemoteVideoStopped id:" + stream.speakerUid + " isStop:" + false);
                    mRtcEventHandler.onRemoteVideoStopped(UidMap.getStringUid(stream.speakerUid), false);
                    continue;
                }
                ThunderLog.release("yrtc", "onRemoteAudioStopped id:" + stream.speakerUid + " isStop:" + false);
                mRtcEventHandler.onRemoteAudioStopped(UidMap.getStringUid(stream.speakerUid), false);
            }
            it = addStreams.iterator();
            while (it.hasNext()) {
                ThunderStream stream;
                stream = it.next();
                boolean isMute = stream.bVideo ? this.isMuteVideoStreamWithUid(stream.speakerUid) : this.isMuteAudioStreamWithUid(stream.speakerUid);
                if (isMute) {
                    it.remove();
                    continue;
                }
                if (!stream.bVideo || this.remoteCanvas == null) continue;
                for (ThunderVideoCanvas canvas : this.remoteCanvas) {
                    if (UidMap.getLongUid(canvas.mUid) != stream.speakerUid) continue;
                    stream.toView = canvas.mView;
                    stream.scaleMode = canvas.mRenderMode;
                }
            }
            this.wholeStreams.clear();
            this.channelStreamsList.put(streamInfo.getRoomId(), curChannelStreams);
            for (Map.Entry<String, ArrayList<ThunderStream>> entry : this.channelStreamsList.entrySet()) {
                this.wholeStreams.addAll((Collection<ThunderStream>)entry.getValue());
            }
            this.anchorStreams.addAll(addStreams);
        }
        if (removeStreams.size() > 0) {
            ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(removeStreams, null);
        }
        if (addStreams.size() > 0) {
            ThunderAPI.sharedInstance().getPlayer().startPlayStreams(addStreams, null);
        }
    }

    private void notifyJoinSuccess() {
        if (this.isJoinRoom.booleanValue() && this.needNotify.booleanValue() && this.mRecv64UidMap) {
            this.joinEnd = System.currentTimeMillis();
            this.needNotify = false;
            int timeElapse = (int)(this.joinEnd - this.joinStart);
            ThunderLog.release("yrtc", "onJoinRoomSuccess:" + this.mMyStrUid + "-" + UidMap.getLongUid(this.mMyStrUid) + "," + timeElapse);
            this.tbGroupSubscribe();
            mRtcEventHandler.onJoinRoomSuccess(this.mRoomName, this.mMyStrUid, timeElapse);
        }
    }

    public static synchronized ThunderEngine createWithLoop(Context context, String appId, long sceneId, ThunderEventHandler handler, Looper loop) {
        ThunderEngine rtcEngine = ThunderEngine.createRtcEngine(context, appId, sceneId, handler);
        if (mHandler == null) {
            mHandler = new NotificationHandler(rtcEngine, loop);
        }
        return rtcEngine;
    }

    public static synchronized void destroyEngine() {
        if (mIsInited) {
            SingleonHolder.INSTANCE.leaveRoom();
            SingleonHolder.INSTANCE.setLocalVideoMirrorMode(0);
            ThunderAPI.sharedInstance().deInit();
            mIsInited = false;
            SingleonHolder.INSTANCE.resetRtcEngine();
            SingleonHolder.INSTANCE = null;
        }
    }

    public static String getVersion() {
        return ThunderAPI.sharedInstance().getVersion();
    }

    public static int setLogFilePath(String filePath) {
        mLogPath = filePath;
        if (filePath == null || filePath.isEmpty()) {
            ThunderAPI.enableLog(false, mLogLevel, mLogPath, null);
        } else {
            ThunderAPI.enableLog(true, mLogLevel, mLogPath, null);
        }
        return 0;
    }

    public static int setLogCallback(IThunderLogCallback callback) {
        mYyLogCallback = callback;
        if (mYyLogCallback != null) {
            ThunderAPI.enableLog(true, mLogLevel, "", mYyLogCallback);
        } else {
            ThunderAPI.enableLog(false, mLogLevel, "", mYyLogCallback);
        }
        return 0;
    }

    public static int setLogLevel(int filter) {
        mLogLevel = filter;
        return 0;
    }

    public int setParameters(String options) {
        try {
            JSONObject obj = new JSONObject(options);
            this.mTbSubscribeGroup = obj.getBoolean("JoinWithSubscribeGroup");
            this.mTbPublishGroup = obj.getBoolean("PublishAudioToGroup");
            ThunderNative.tbPublishGroup(this.mTbPublishGroup);
            ThunderLog.release(TAG, String.format("[tbg] setParameters JoinWithSubscribeGroup=%b PublishAudioToGroup=%b", this.mTbSubscribeGroup, this.mTbPublishGroup));
        }
        catch (Exception exc) {
            ThunderLog.release(TAG, String.format("setParameters err=%s", exc.toString()));
            return -1;
        }
        return 0;
    }

    private void tbGroupSubscribe() {
        ThunderLog.release(TAG, "tbGroupSubscribe");
        if (!this.mTbSubscribeGroup) {
            return;
        }
        if (this.mBGroupSubscribe) {
            return;
        }
        ArrayList<ThunderGroup> audioGroup = new ArrayList<ThunderGroup>(0);
        ThunderGroup oneGroup = new ThunderGroup();
        oneGroup.appId = this.mRoomAppId;
        oneGroup.groupName = "g_" + this.mRoomName;
        audioGroup.add(oneGroup);
        ThunderLog.release(TAG, "[tbg] tbGroupSubscribe");
        ThunderAPI.sharedInstance().getPlayer().startPlayStreams(null, audioGroup);
        this.mBGroupSubscribe = true;
    }

    private void tbStopGroupSubscribe() {
        ThunderLog.release(TAG, "[tbg] tbStopGroupSubscribe");
        if (!this.mTbSubscribeGroup) {
            return;
        }
        if (this.mBGroupSubscribe) {
            ArrayList<ThunderGroup> audioGroup = new ArrayList<ThunderGroup>(0);
            ThunderGroup oneGroup = new ThunderGroup();
            oneGroup.appId = this.mRoomAppId;
            oneGroup.groupName = "g_" + this.mRoomName;
            audioGroup.add(oneGroup);
            ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(null, audioGroup);
            this.mBGroupSubscribe = false;
        }
    }

    public void setSceneId(long sceneId) {
        sMySceneId = sceneId;
        ThunderAPI.sharedInstance().setSceneId(sceneId);
    }

    public int setRoomConfig(int config, int roomConfig) {
        ThunderLog.release("yrtc", "setRoomConfig: config=%d roomConfig:%d", config, roomConfig);
        if (this.joinStart != 0L) {
            return -1;
        }
        if (this.isJoinRoom.booleanValue()) {
            return -2;
        }
        ThunderLog.release("yrtc", "setChannelProfile: working");
        this.isThunder = config == 2 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.mRoomConfig = roomConfig;
        boolean bLowLatency = false;
        switch (this.mRoomConfig) {
            case 0: {
                bLowLatency = false;
                break;
            }
            case 1: 
            case 3: {
                bLowLatency = true;
                break;
            }
            case 4: {
                bLowLatency = true;
                break;
            }
        }
        ThunderAPI.sharedInstance().setRoomConfig(this.mRoomConfig);
        ThunderAPI.sharedInstance().enableLowLatency(bLowLatency);
        return config;
    }

    public int setArea(int area) {
        ThunderLog.release("yrtc", "setArea: area=%d", area);
        int iResult = 0;
        int transSdkArea = 0;
        switch (area) {
            case 0: {
                transSdkArea = 0;
                break;
            }
            case 1: {
                transSdkArea = 100;
                break;
            }
            case 2: {
                transSdkArea = 101;
                break;
            }
            default: {
                iResult = -1;
            }
        }
        ThunderAPI.sharedInstance().setAreaType(transSdkArea);
        return iResult;
    }

    public int enableWebSdkCompatibility(boolean enabled) {
        ThunderNative.enableWebSdkCompatibility(enabled);
        return 0;
    }

    public int setUse64bitUid(boolean is64bitUid) {
        this.mIs32bitUid = !is64bitUid;
        ThunderAPI.sharedInstance().set32BitUid(this.mIs32bitUid);
        return 0;
    }

    public int joinRoom(byte[] token, String roomName, String uid) {
        ThunderLog.release("yrtc", "joinRoom: roomName=%s, uid=%s, is32bitUid=%b, token=%s", this.getPrintString(roomName), this.getPrintString(uid), this.mIs32bitUid, this.getPrintString(token));
        if (!this.isValidRoomStream(roomName)) {
            return -1;
        }
        if (!this.isValidUid(uid)) {
            return -2;
        }
        this.mMyStrUid = uid;
        if (this.mIs32bitUid) {
            try {
                this.mMyUid = Long.parseLong(uid);
                this.mRecv64UidMap = true;
            }
            catch (NumberFormatException exception) {
                return -4;
            }
        }
        this.mRoomName = roomName;
        this.mRoomAppId = sMyAppId;
        if (this.isThunder.booleanValue()) {
            ThunderNative.setVoiceOnlySdk(true);
        } else {
            ThunderNative.setVoiceOnlySdk(false);
        }
        ThunderAPI.sharedInstance().registerNotificationHandler(mHandler);
        ThunderAPI.sharedInstance().updateToken(token);
        ThunderNative.setChannelName(this.mRoomName);
        this.mToken = token;
        ThunderAPI.sharedInstance().updateToken(token);
        if (this.mIs32bitUid) {
            ThunderNative.setUserInfo(this.mMyUid, 0);
            ThunderAPI.sharedInstance().joinMedia(this.mMyUid);
        } else {
            ThunderAPI.sharedInstance().joinMedia(this.mMyStrUid, 0L, 0L);
        }
        ThunderAPI.sharedInstance().setUserRole(1);
        if (this.isThunder.booleanValue()) {
            this.joinRoomThunder();
        } else {
            this.joinRoomThunderBolt();
        }
        this.joinStart = System.currentTimeMillis();
        this.needNotify = true;
        return 0;
    }

    private boolean joinRoomThunder() {
        if (this.mBGroupSubscribe) {
            return false;
        }
        ArrayList<ThunderGroup> audioGroup = new ArrayList<ThunderGroup>(0);
        ThunderGroup oneGroup = new ThunderGroup();
        oneGroup.appId = this.mRoomAppId;
        oneGroup.groupName = "g_" + this.mRoomName;
        audioGroup.add(oneGroup);
        ThunderAPI.sharedInstance().getPlayer().startPlayStreams(null, audioGroup);
        this.mBGroupSubscribe = true;
        this.needNotify = false;
        return true;
    }

    private boolean joinRoomThunderBolt() {
        boolean res = ThunderAPI.sharedInstance().joinRoom(this.mRoomName, this.mMyStrUid, 1, this.mIs32bitUid);
        if (res) {
            this.isBoltJoin = true;
        }
        return true;
    }

    private boolean isValidRoomStream(String roomName) {
        if (roomName == null || roomName.isEmpty()) {
            return false;
        }
        int length = roomName.length();
        if (length > 64) {
            return false;
        }
        int validCharCount = 0;
        for (int i = 0; i < length; ++i) {
            int codePoint = Character.codePointAt(roomName, i);
            if (!(codePoint == 45 || codePoint == 95 || codePoint >= 48 && codePoint <= 57 || codePoint >= 65 && codePoint <= 90) && (codePoint < 97 || codePoint > 122)) continue;
            ++validCharCount;
        }
        if (validCharCount == length) {
            return true;
        }
        ThunderLog.error("yrtc", "found invalid char in roomName!");
        return false;
    }

    private boolean isValidUid(String uid) {
        block9: {
            if (uid == null || uid.isEmpty()) {
                return false;
            }
            if (this.mIs32bitUid) {
                if (!UidMap.isNumeric(uid)) {
                    ThunderLog.error("yrtc", "isValidUid, uid32 has invalid character");
                    return false;
                }
                try {
                    long iUid = Long.parseLong(uid, 10);
                    if (iUid <= 0xFFFFFFFFL) {
                        return true;
                    }
                    break block9;
                }
                catch (NumberFormatException exception) {
                    return false;
                }
            }
            int length = uid.length();
            if (length > 64) {
                ThunderLog.error("yrtc", "isValidUid, StrUid more than 64 character");
                return false;
            }
            int validCharCount = 0;
            for (int i = 0; i < length; ++i) {
                int codePoint = Character.codePointAt(uid, i);
                if (!(codePoint == 45 || codePoint == 95 || codePoint >= 48 && codePoint <= 57 || codePoint >= 65 && codePoint <= 90) && (codePoint < 97 || codePoint > 122)) continue;
                ++validCharCount;
            }
            if (validCharCount == length) {
                return true;
            }
            ThunderLog.error("yrtc", "found invalid character in StrUid");
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int leaveRoom() {
        ThunderLog.release("yrtc", "leaveRoom");
        if (this.isThunder.booleanValue()) {
            this.leaveRoomThunder();
        } else {
            if (!this.isJoinRoom.booleanValue()) {
                return -2;
            }
            this.leaveRoomThunderBolt();
        }
        UidMap.removeAllUid2String();
        this.isStopLocalVideo = false;
        this.accompanyType = -1;
        this.isJoinRoom = false;
        this.isEnableAudio = true;
        this.isEnableVideo = true;
        this.isStopAllVideo = false;
        this.isStopAllAudio = false;
        this.joinStart = 0L;
        this.joinEnd = 0L;
        this.mRoomName = "";
        Object object = this.streamLock;
        synchronized (object) {
            this.wholeStreams.clear();
            this.anchorStreams.clear();
            this.channelStreamsList.clear();
            this.remoteCanvas.clear();
            this.subscribeStreamMap.clear();
        }
        return 0;
    }

    private int leaveRoomThunder() {
        if (!this.mBGroupSubscribe) {
            return -1;
        }
        this.tryStopPublish();
        this.tryStopSubscribe();
        ThunderAPI.sharedInstance().leaveMedia();
        this.mBGroupSubscribe = false;
        return 0;
    }

    private int leaveRoomThunderBolt() {
        this.tbStopGroupSubscribe();
        this.tryStopPublish();
        this.tryStopSubscribe();
        this.tryStopVideoSubscribe();
        this.tryStopVideoPublish();
        ThunderAPI.sharedInstance().getPublishRoom().attachVideoCapture(ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera());
        this.tryStopVideoPreview();
        ThunderAPI.sharedInstance().leaveRoom();
        ThunderEventHandler.RoomStats status = new ThunderEventHandler.RoomStats();
        mRtcEventHandler.onLeaveRoom(status);
        return 0;
    }

    public int updateToken(byte[] token) {
        ThunderLog.release("yrtc", "updateToken: %s ", this.getPrintString(token));
        this.mToken = token;
        ThunderAPI.sharedInstance().updateToken(token);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int enableAudioEngine() {
        ThunderLog.release("yrtc", "enableAudioEngine isThunder:" + this.isThunder);
        this.isEnableAudio = true;
        if (this.isThunder.booleanValue()) {
            if (!this.mBGroupSubscribe) {
                return -1;
            }
            if (this.mBAudioPublish) {
                return -2;
            }
            this.mStringName = "a_" + this.mMyStrUid + "_" + this.mRoomName;
            String groupName = "g_" + this.mRoomName;
            ArrayList<String> groupList = new ArrayList<String>();
            groupList.add(groupName);
            ThunderPublishAudioConfig config = new ThunderPublishAudioConfig(2);
            config.bUseAudioProfile = true;
            config.roomConfig = this.mRoomConfig;
            config.audioConfig = this.mAudioConfig;
            config.commutMode = this.mCommutMode;
            config.scenarioMode = this.mScenarioMode;
            this.mBAudioPublish = true;
            ThunderAPI.sharedInstance().getPublisher().startPublishAudio(this.mStringName, groupList, config);
        } else {
            this.tbGroupSubscribe();
            if (this.mBAudioPublish) {
                return -2;
            }
            if (this.isJoinRoom.booleanValue()) {
                ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);
                Object object = this.streamLock;
                synchronized (object) {
                    for (ThunderStream oneStream : this.wholeStreams) {
                        boolean isMute;
                        if (oneStream.bVideo || this.anchorStreams.contains(oneStream) || (isMute = this.isMuteAudioStreamWithUid(oneStream.speakerUid))) continue;
                        startStreams.add(oneStream);
                        this.anchorStreams.add(oneStream);
                    }
                }
                if (startStreams.size() > 0) {
                    ThunderAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                }
                if (!this.mBAudioPublish) {
                    ThunderAPI.sharedInstance().getPublishRoom().updateProfile(this.mRoomConfig, this.mAudioConfig, this.mCommutMode, this.mScenarioMode);
                    ThunderAPI.sharedInstance().getPublishRoom().setAudioEnable(true);
                    if (this.accompanyType >= 0) {
                        ThunderAPI.sharedInstance().getPublisher().setAudioSourceType(this.accompanyType);
                    }
                    this.mBAudioPublish = true;
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int disableAudioEngine() {
        ThunderLog.release("yrtc", "disableAudioEngine isThunder:" + this.isThunder);
        if (this.isThunder.booleanValue()) {
            this.tryStopPublish();
        } else if (this.isEnableAudio.booleanValue()) {
            this.tbStopGroupSubscribe();
            ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);
            Object object = this.streamLock;
            synchronized (object) {
                for (ThunderStream oneStream : this.anchorStreams) {
                    if (oneStream.bVideo) continue;
                    stopStreams.add(oneStream);
                }
            }
            ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
            this.tryStopPublish();
            ArrayList<ThunderStream> audioStreams = new ArrayList<ThunderStream>(0);
            Object object2 = this.streamLock;
            synchronized (object2) {
                for (ThunderStream oneStream : this.anchorStreams) {
                    if (oneStream.bVideo) continue;
                    audioStreams.add(oneStream);
                }
                for (ThunderStream oneStream : audioStreams) {
                    this.anchorStreams.remove(oneStream);
                }
            }
            audioStreams.clear();
            this.isEnableAudio = false;
        }
        return 0;
    }

    public int setAudioConfig(int profile, int commutMode, int scenarioMode) {
        ThunderLog.release("yrtc", "setAudioConfig: profile=%d, commutMode=%d, scenarioMode=%d", profile, commutMode, scenarioMode);
        this.mAudioConfig = profile;
        this.mCommutMode = commutMode;
        this.mScenarioMode = scenarioMode;
        return 0;
    }

    public int enableVoicePosition(boolean enable) {
        ThunderLog.release("yrtc", "enableVoicePosition: enable=%b", enable);
        if (this.joinStart != 0L) {
            return -1;
        }
        if (this.isJoinRoom.booleanValue()) {
            return -2;
        }
        ThunderLog.release("yrtc", "enableVoicePosition: working");
        ThunderAPI.sharedInstance().enableVoicePosition(enable);
        return 0;
    }

    public int enableLoudspeaker(boolean enabled) {
        ThunderLog.release("yrtc", "enableLoudspeaker: %b", enabled);
        ThunderAPI.sharedInstance().getPlayer().enableLoudSpeaker(enabled);
        return 0;
    }

    public boolean isLoudspeakerEnabled() {
        return ThunderAPI.sharedInstance().getPlayer().getLoudSpeakerEnabled();
    }

    public int setAudioVolumeIndication(int interval, int moreThanThd, int lessThanThd, int smooth) {
        ThunderLog.release("yrtc", "setAudioVolumeIndication: interval=%d,moreThanThd=%d, lessThanThd=%d, smooth=%d", interval, moreThanThd, lessThanThd, smooth);
        ThunderAPI.sharedInstance().setPlayVolumeInterval(interval, moreThanThd, lessThanThd);
        return 0;
    }

    public int enableCaptureVolumeIndication(int interval, int moreThanThd, int lessThanThd, int smooth) {
        ThunderLog.release("yrtc", "enableCaptureVolumeIndication: interval=%d,moreThanThd=%d, lessThanThd=%d, smooth=%d", interval, moreThanThd, lessThanThd, smooth);
        ThunderAPI.sharedInstance().setCaptureVolumeInterval(interval, moreThanThd, lessThanThd);
        return 0;
    }

    public boolean startAudioSaver(String fileName, int saverMode, int fileMode) {
        ThunderLog.release("yrtc", "startAudioSaver: fileName=%s,saverMode=%d, fileMode=%d", this.getPrintString(fileName), saverMode, fileMode);
        if (fileName.isEmpty()) {
            return false;
        }
        return ThunderAPI.sharedInstance().startAudioSaver(fileName, saverMode, fileMode);
    }

    public boolean stopAudioSaver() {
        ThunderLog.release("yrtc", "stopAudioSaver");
        return ThunderAPI.sharedInstance().stopAudioSaver();
    }

    public void setSoundEffect(int mode) {
        ThunderLog.release("yrtc", "ThunderEngine::setSoundEffect %d", mode);
        ThunderAPI.sharedInstance().getPublisher().setSoundEffect(mode);
    }

    public void setVoiceChanger(int mode) {
        ThunderLog.release("yrtc", "ThunderEngine::setVoiceChanger %d", mode);
        ThunderAPI.sharedInstance().getPublisher().setVoiceChanger(mode);
    }

    public int stopLocalAudioStream(boolean stop) {
        ThunderLog.release("yrtc", "stopLocalAudioStream: %b isThunder:%b", stop, this.isThunder);
        if (this.isThunder.booleanValue()) {
            int volume = 80;
            if (stop) {
                volume = 0;
            }
            ThunderAPI.sharedInstance().getPublisher().setMicVolume(volume);
        } else if (stop) {
            if (this.mBAudioPublish) {
                ThunderAPI.sharedInstance().getPublishRoom().setAudioEnable(false);
                this.mBAudioPublish = false;
            }
        } else if (!this.mBAudioPublish && this.isJoinRoom.booleanValue()) {
            ThunderAPI.sharedInstance().getPublishRoom().setAudioEnable(true);
            if (this.accompanyType >= 0) {
                ThunderAPI.sharedInstance().getPublisher().setAudioSourceType(this.accompanyType);
            }
            this.mBAudioPublish = true;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopAllRemoteAudioStreams(boolean stop) {
        ThunderLog.release("yrtc", "stopAllRemoteAudioStreams: %b isThunder:%b isEnableAudio:%b isJoinRoom:%b", stop, this.isThunder, this.isEnableAudio, this.isJoinRoom);
        if (this.isThunder.booleanValue() || this.mTbSubscribeGroup) {
            ThunderAPI.sharedInstance().getPlayer().enableAllMute(stop);
        }
        if (!this.isThunder.booleanValue()) {
            this.isStopAllAudio = stop;
            if (!this.isEnableAudio.booleanValue()) {
                return -2;
            }
            this.uidMuteAudioList.clear();
            if (stop) {
                ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);
                Object object = this.streamLock;
                synchronized (object) {
                    for (ThunderStream oneStream : this.anchorStreams) {
                        if (oneStream.bVideo) continue;
                        stopStreams.add(oneStream);
                    }
                    for (ThunderStream oneStream : stopStreams) {
                        this.anchorStreams.remove(oneStream);
                    }
                }
                if (this.isJoinRoom.booleanValue()) {
                    ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
                }
            } else {
                ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);
                Object object = this.streamLock;
                synchronized (object) {
                    for (ThunderStream oneStream : this.wholeStreams) {
                        boolean isPlaying = false;
                        if (oneStream.bVideo) continue;
                        for (ThunderStream anStream : this.anchorStreams) {
                            if (anStream.speakerUid != oneStream.speakerUid || anStream.bVideo) continue;
                            isPlaying = true;
                            break;
                        }
                        if (isPlaying) continue;
                        startStreams.add(oneStream);
                        this.anchorStreams.add(oneStream);
                    }
                }
                if (this.isJoinRoom.booleanValue()) {
                    ThunderAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopRemoteAudioStream(String uid, boolean stop) {
        ThunderLog.release("yrtc", "stopRemoteAudioStream: uid=%s, %b isThunder:%b isEnableAudio:%b isJoinRoom:%b", this.getPrintString(uid), stop, this.isThunder, this.isEnableAudio, this.isJoinRoom);
        if (this.isThunder.booleanValue() || this.mTbSubscribeGroup) {
            ThunderStream stream = new ThunderStream();
            stream.speakerUid = UidMap.getLongUid(uid);
            if (!this.mIs32bitUid) {
                if (uid == null) {
                    return -2;
                }
                ThunderAPI.sharedInstance().getPlayer().enableMute(stop, uid);
                if (stream.speakerUid == 0L) {
                    return 0;
                }
            }
            ThunderAPI.sharedInstance().getPlayer().enableMute(stop, stream);
        }
        if (!this.isThunder.booleanValue()) {
            if (!this.isEnableAudio.booleanValue()) {
                return -2;
            }
            this.uidMuteAudioList.put(uid, stop);
            long lUid = UidMap.getLongUid(uid);
            if (stop) {
                ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);
                Object object = this.streamLock;
                synchronized (object) {
                    for (ThunderStream oneStream : this.anchorStreams) {
                        if (lUid != oneStream.speakerUid || oneStream.bVideo) continue;
                        stopStreams.add(oneStream);
                    }
                    for (ThunderStream oneStream : stopStreams) {
                        this.anchorStreams.remove(oneStream);
                    }
                }
                if (this.isJoinRoom.booleanValue()) {
                    ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
                }
            } else {
                ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);
                ThunderStream newStream = null;
                boolean alreadyPlay = false;
                Object object = this.streamLock;
                synchronized (object) {
                    for (ThunderStream oneStream : this.wholeStreams) {
                        if (lUid != oneStream.speakerUid || oneStream.bVideo) continue;
                        newStream = oneStream;
                        break;
                    }
                    if (newStream == null) {
                        return 0;
                    }
                    for (ThunderStream oneStream : this.anchorStreams) {
                        if (lUid != oneStream.speakerUid || oneStream.bVideo) continue;
                        alreadyPlay = true;
                        break;
                    }
                    if (!alreadyPlay) {
                        startStreams.add(newStream);
                        this.anchorStreams.add(newStream);
                    }
                }
                if (this.isJoinRoom.booleanValue()) {
                    ThunderAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                }
            }
        }
        return 0;
    }

    public int setLoudSpeakerVolume(int volume) {
        ThunderLog.release("yrtc", "setSpeakerphoneVolume: %d", volume);
        boolean bResult = ThunderAPI.sharedInstance().getPlayer().setSpeakerVolume(volume);
        if (bResult) {
            return 0;
        }
        return -1;
    }

    public int setMicVolume(int volume) {
        ThunderLog.release("yrtc", "setMicVolume: %d", volume);
        boolean bResult = ThunderAPI.sharedInstance().getPublisher().setMicVolume(volume);
        if (bResult) {
            return 0;
        }
        return -1;
    }

    public int setRemoteAudioStreamsVolume(String uid, int volume) {
        ThunderLog.release("yrtc", "setRemoteAudioStreamsVolume: uid=%s, volume=%d", this.getPrintString(uid), volume);
        if (this.isThunder.booleanValue() && !this.mBGroupSubscribe) {
            return -1;
        }
        ThunderStream stream = new ThunderStream();
        stream.speakerUid = UidMap.getLongUid(uid);
        if (!this.mIs32bitUid && stream.speakerUid == 0L) {
            return -2;
        }
        if (ThunderAPI.sharedInstance().getPlayer().setPlayVolume(volume, stream)) {
            return 0;
        }
        return -4;
    }

    public int setRemoteUidVoicePosition(String uid, int azimuth, int gain) {
        ThunderLog.release("yrtc", "setRemoteUidVoicePosition: uid=%s, azimuth=%d, gain=%d", this.getPrintString(uid), azimuth, gain);
        if (this.isThunder.booleanValue() && !this.mBGroupSubscribe) {
            return -1;
        }
        ThunderStream stream = new ThunderStream();
        stream.speakerUid = UidMap.getLongUid(uid);
        if (!this.mIs32bitUid && stream.speakerUid == 0L) {
            return -2;
        }
        if (ThunderAPI.sharedInstance().getPlayer().setRemoteUidVoicePosition(azimuth, gain, stream)) {
            return 0;
        }
        return -4;
    }

    public ThunderAudioFilePlayer createAudioFilePlayer() {
        ThunderLog.release("yrtc", "createAudioFilePlayer");
        ThunderAudioFilePlayer audioFilePlayer = new ThunderAudioFilePlayer();
        this.mAudioFilePlayerSet.add(audioFilePlayer);
        return audioFilePlayer;
    }

    public void destroyAudioFilePlayer(ThunderAudioFilePlayer audioFilePlayer) {
        ThunderLog.release("yrtc", "destroyAudioFilePlayer: %s", this.getPrintString(audioFilePlayer));
        if (audioFilePlayer == null) {
            return;
        }
        audioFilePlayer.destroyAudioFilePlayer();
        this.mAudioFilePlayerSet.remove(audioFilePlayer);
    }

    public int setEnableEqualizer(boolean enabled) {
        this.mBEnableEqualizer = enabled;
        ThunderAPI.sharedInstance().getPublisher().EnableEqualizer(enabled);
        return 0;
    }

    public int setEqGains(int[] gains) {
        if (gains == null) {
            return -1;
        }
        if (gains.length < 11) {
            return -2;
        }
        for (int i = 0; i <= 10; ++i) {
            if (gains[i] >= -12 && gains[i] <= 12) continue;
            return -3;
        }
        this.mEqGains = gains;
        ThunderAPI.sharedInstance().getPublisher().SetGqGains(gains);
        return 0;
    }

    public int setEnableReverb(boolean enabled) {
        this.mBEnableReverbEx = enabled;
        ThunderAPI.sharedInstance().getPublisher().EnableReverb(enabled);
        return 0;
    }

    public int setReverbExParameter(ReverbExParameter param) {
        if (param == null) {
            return -1;
        }
        if ((double)param.mRoomSize < 0.0 || (double)param.mRoomSize > 100.0 || (double)param.mPreDelay < 0.0 || (double)param.mPreDelay > 200.0 || (double)param.mReverberance < 0.0 || (double)param.mReverberance > 100.0 || (double)param.mHfDamping < 0.0 || (double)param.mHfDamping > 100.0 || (double)param.mToneLow < 0.0 || (double)param.mToneLow > 100.0 || (double)param.mToneHigh < 0.0 || (double)param.mToneHigh > 100.0 || (double)param.mWetGain < -20.0 || (double)param.mWetGain > 10.0 || (double)param.mDryGain < -20.0 || (double)param.mDryGain > 10.0 || (double)param.mStereoWidth < 0.0 || (double)param.mStereoWidth > 100.0) {
            return -2;
        }
        this.mReverbExGains = param;
        ThunderAPI.sharedInstance().getPublisher().setReverbExParameter(param.mRoomSize, param.mPreDelay, param.mReverberance, param.mHfDamping, param.mToneLow, param.mToneHigh, param.mWetGain, param.mDryGain, param.mStereoWidth);
        return 0;
    }

    public int setEnableCompressor(boolean enabled) {
        this.mBEnableCompressor = enabled;
        ThunderAPI.sharedInstance().getPublisher().EnableCompressor(enabled);
        return 0;
    }

    public int setCompressorParam(CompressorParam param) {
        if (param == null) {
            return -1;
        }
        if (param.mThreshold < -40 || param.mThreshold > 0 || param.mReleaseTime <= 0 || param.mAttackTime <= 0) {
            return -2;
        }
        this.mCompressorGains = param;
        ThunderAPI.sharedInstance().getPublisher().SetCompressorParam(param.mThreshold, param.mMakeupGain, param.mRatio, param.mKnee, param.mReleaseTime, param.mAttackTime);
        return 0;
    }

    public int setEnableLimiter(boolean enabled) {
        this.mBEnableLimiter = enabled;
        ThunderAPI.sharedInstance().getPublisher().EnableLimiter(enabled);
        return 0;
    }

    public int setLimiterParam(LimterParam param) {
        if (param == null) {
            return -1;
        }
        this.mLimiterGins = param;
        ThunderAPI.sharedInstance().getPublisher().SetLimiterParam(param.fCeiling, param.fThreshold, param.fPreGain, param.fRelease, param.fAttack, param.fLookahead, param.fLookaheadRatio, param.fRMS, param.fStLink);
        return 0;
    }

    public void setExternalAudioProcessor(long eap) {
        ThunderAPI.sharedInstance().setExternalAudioProcessor(eap);
    }

    public void enableAudioPlaySpectrum(boolean enable) {
        ThunderAPI.sharedInstance().enableAudioPlaySpectrum(enable);
    }

    public void setAudioPlaySpectrumInfo(int spectrumLen, int notifyIntervalMS) {
        ThunderAPI.sharedInstance().setAudioPlaySpectrumInfo(spectrumLen, notifyIntervalMS);
    }

    public int sendUserAppMsgData(byte[] msgData) {
        ThunderAPI.sharedInstance().sendUserAppMsgData(msgData);
        return 0;
    }

    public void enableAudioDataIndication(boolean enablePlay) {
        this.mBEnablePlayDataIndication = enablePlay;
        ThunderAPI.sharedInstance().enableAudioDataIndication(enablePlay);
    }

    public void enableCapturePcmDataCallBack(boolean enable, int sampleRate, int channel) {
        ThunderAPI.sharedInstance().enableCapturePcmDataCallBack(enable, sampleRate, channel);
    }

    public boolean enableRenderPcmDataCallBack(boolean enable, int sampleRate, int channel) {
        ThunderLog.release("yrtc", "enableRenderPcmDataCallBack enable = %b sampleRate: %d, channel = %d ", enable, sampleRate, channel);
        return ThunderAPI.sharedInstance().enableRenderPcmDataCallBack(enable, sampleRate, channel);
    }

    public void setAudioSourceType(int sourceType) {
        ThunderLog.release("ycall-Java", "setAudioSourceType: mode=%d", sourceType);
        ThunderAPI.sharedInstance().getPublisher().setAudioSourceType(sourceType);
        this.accompanyType = sourceType;
    }

    public int setEnableInEarMonitor(boolean enable) {
        ThunderLog.release("ycall-Java", "setEnableInEarMonitor: %b", enable);
        if (ThunderAPI.sharedInstance().getPublisher().enableInEarMonitor(enable)) {
            return 0;
        }
        return -1;
    }

    public Object CreateRendererView(Context context, int type) {
        FrameLayout view = null;
        switch (type) {
            case 2: {
                view = new ThunderPlayerView(context);
                break;
            }
            case 1: {
                view = new ThunderPreviewView(context);
            }
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int enableVideoEngine() {
        if (this.isThunder.booleanValue()) {
            return -2;
        }
        this.isEnableVideo = true;
        ThunderLog.release("yrtc", "enableVideoEngine ," + this.isOtherSource);
        if (this.isJoinRoom.booleanValue()) {
            Object object = this.streamLock;
            synchronized (object) {
                ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);
                for (ThunderStream stream : this.wholeStreams) {
                    boolean isMute;
                    if (!stream.bVideo || this.anchorStreams.contains(stream) || (isMute = this.isMuteVideoStreamWithUid(stream.speakerUid))) continue;
                    for (ThunderVideoCanvas canvas : this.remoteCanvas) {
                        if (UidMap.getLongUid(canvas.mUid) != stream.speakerUid) continue;
                        stream.toView = canvas.mView;
                        stream.scaleMode = canvas.mRenderMode;
                    }
                    startStreams.add(stream);
                    this.anchorStreams.add(stream);
                }
                if (startStreams.size() > 0) {
                    ThunderAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                }
            }
        }
        if (this.isJoinRoom.booleanValue() && (this.isPreview.booleanValue() || this.isOtherSource.booleanValue()) && !this.mBVideoPublish) {
            ThunderAPI.sharedInstance().getPublishRoom().setVideoEnable(true);
            this.mBVideoPublish = true;
        }
        return 0;
    }

    public int disableVideoEngine() {
        ThunderLog.release("yrtc", "disableVideoEngine ");
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -1;
        }
        this.tryStopVideoSubscribe();
        this.tryStopVideoPublish();
        ThunderDefaultCamera camera = ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera();
        ThunderPreviewConfig config = (ThunderPreviewConfig)camera.getCaptureConfig();
        config.cameraPosition = 0;
        config.captureOrientation = 0;
        if (this.isPreview.booleanValue()) {
            this.setLocalVideoMirrorMode(0);
        }
        ThunderAPI.sharedInstance().getPublishRoom().attachVideoCapture(ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera());
        this.tryStopVideoPreview();
        mLocalPreviewView = null;
        this.isEnableVideo = false;
        this.isOtherSource = false;
        return 0;
    }

    public int setVideoEncoderConfig(ThunderVideoEncoderConfiguration yyVideoConfig) {
        ThunderLog.release("yrtc", "setVideoEncoderConfig playtype:" + yyVideoConfig.playType + " publishmode:" + yyVideoConfig.publishMode + " isEnableVideo:" + this.isEnableVideo);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        this.mThunderVideoEncoderConfiguration = yyVideoConfig;
        ThunderAPI.sharedInstance().getPublishRoom().updatePlayTypeAndPublishMode(yyVideoConfig.playType, yyVideoConfig.publishMode);
        return 0;
    }

    public int setLocalVideoCanvas(ThunderVideoCanvas local) {
        ThunderLog.release("yrtc", "setLocalVideoCanvas view:" + local.mView + " isEnableVideo:" + this.isEnableVideo);
        if (this.isEnableVideo.booleanValue() && !this.isThunder.booleanValue() && local != null && local.mView != null) {
            if (this.isPreview.booleanValue()) {
                ThunderAPI.sharedInstance().getPublishRoom().setLocalVideoView((ThunderPreviewView)((Object)local.mView));
            }
            mLocalPreviewView = (ThunderPreviewView)((Object)local.mView);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setRemoteVideoCanvas(ThunderVideoCanvas remote) {
        ThunderLog.release("yrtc", "setRemoteVideoCanvas view:" + remote.mView + "uid:" + remote.mUid + " isEnableVideo:" + this.isEnableVideo);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        if (remote == null) {
            return -1;
        }
        boolean isFind = false;
        ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);
        if (remote.mView != null) {
            Object object = this.streamLock;
            synchronized (object) {
                for (ThunderVideoCanvas oneCanvas : this.remoteCanvas) {
                    if (oneCanvas.mView != remote.mView) continue;
                    if (!oneCanvas.mUid.equals(remote.mUid)) {
                        Long lUid = UidMap.getLongUid(oneCanvas.mUid);
                        ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);
                        for (ThunderStream oneStream : this.anchorStreams) {
                            if (!oneStream.bVideo || lUid != oneStream.speakerUid) continue;
                            oneStream.toView = null;
                            oneStream.scaleMode = 1;
                            stopStreams.add(oneStream);
                            ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
                            ThunderAPI.sharedInstance().getPlayer().startPlayStreams(stopStreams, null);
                            break;
                        }
                        for (ThunderStream oneStream : this.wholeStreams) {
                            if (!oneStream.bVideo || lUid != oneStream.speakerUid) continue;
                            oneStream.toView = null;
                            oneStream.scaleMode = 1;
                            break;
                        }
                    }
                    isFind = true;
                    oneCanvas.mUid = remote.mUid;
                    oneCanvas.mRenderMode = remote.mRenderMode;
                    break;
                }
                if (!isFind) {
                    this.remoteCanvas.add(remote);
                }
                Long lUid = UidMap.getLongUid(remote.mUid);
                for (ThunderStream oneStream : this.anchorStreams) {
                    if (!oneStream.bVideo || lUid != oneStream.speakerUid) continue;
                    if (oneStream.toView == remote.mView) break;
                    oneStream.toView = remote.mView;
                    oneStream.scaleMode = remote.mRenderMode;
                    startStreams.add(oneStream);
                    break;
                }
                if (startStreams.size() > 0) {
                    ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(startStreams, null);
                    ThunderAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                    startStreams.clear();
                }
                for (ThunderStream oneStream : this.wholeStreams) {
                    if (!oneStream.bVideo || lUid != oneStream.speakerUid) continue;
                    oneStream.toView = remote.mView;
                    oneStream.scaleMode = remote.mRenderMode;
                    break;
                }
            }
        }
        return 0;
    }

    public int setLocalCanvasScaleMode(int mode) {
        ThunderLog.release("yrtc", "setLocalCanvasScaleMode mode:" + mode + " isEnableVideo:" + this.isEnableVideo);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        ThunderAPI.sharedInstance().setPreviewRenderMode(mode);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setRemoteCanvasScaleMode(String uid, int mode) {
        ThunderLog.release("yrtc", "setRemoteCanvasScaleMode Uid:" + uid + " mode:" + mode + " isEnableVideo:" + this.isEnableVideo);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        Object object = this.streamLock;
        synchronized (object) {
            for (ThunderVideoCanvas oneCanvas : this.remoteCanvas) {
                if (!uid.equals(oneCanvas.mUid)) continue;
                ThunderPlayerView remote = (ThunderPlayerView)((Object)oneCanvas.mView);
                oneCanvas.mRenderMode = mode;
                ThunderNative.setPlayViewScaleMode((Object)remote, mode);
            }
        }
        return 0;
    }

    public int startVideoPreview() {
        ThunderLog.release("yrtc", "startVideoPreview  isEnableVideo:" + this.isEnableVideo);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue() || this.isStopLocalVideo.booleanValue()) {
            return -2;
        }
        if (this.isPreview.booleanValue() && !this.mBOnlyReleaseCamera) {
            return 0;
        }
        if (this.mBVideoPublish && !this.isOtherSource.booleanValue() && this.mBOnlyReleaseCamera) {
            ThunderNative.stopAndRecoverVideoEncode(false);
            this.mBOnlyReleaseCamera = false;
        } else {
            ThunderAPI.sharedInstance().getPublishRoom().startVideoPreview(this.mThunderVideoEncoderConfiguration.playType, this.mThunderVideoEncoderConfiguration.publishMode);
            ThunderAPI.sharedInstance().getPublishRoom().setLocalVideoView(mLocalPreviewView);
        }
        this.isPreview = true;
        return 0;
    }

    public int stopVideoPreview() {
        ThunderLog.release("yrtc", "stopVideoPreview  isEnableVideo:" + this.isEnableVideo + " isPreview " + this.isPreview + " mBVideoPublish " + this.mBVideoPublish);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        if (this.isPreview.booleanValue()) {
            if (this.mBVideoPublish && this.mBOnlyReleaseCamera) {
                ThunderLog.release("yrtc", "stopVideoPreview  isEnableVideo:" + this.isEnableVideo + " isPreview " + this.isPreview + " mBVideoPublish " + this.mBVideoPublish + " mBOnlyReleaseCamera " + this.mBOnlyReleaseCamera);
                return 0;
            }
            if (this.mBVideoPublish && !this.isOtherSource.booleanValue() && !this.mBOnlyReleaseCamera) {
                ThunderNative.stopAndRecoverVideoEncode(true);
                this.mBOnlyReleaseCamera = true;
            } else {
                ThunderAPI.sharedInstance().getPublishRoom().stopVideoPreview();
                this.isPreview = false;
            }
        }
        return 0;
    }

    public int enableLocalVideoCapture(boolean enable) {
        ThunderLog.release("yrtc", "enableLocalVideoCapture  isEnableVideo:" + this.isEnableVideo);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        if (!enable) {
            this.tryStopVideoPublish();
            this.tryStopVideoPreview();
            this.isStopLocalVideo = true;
        } else {
            this.isStopLocalVideo = false;
        }
        return 0;
    }

    public int stopLocalVideoStream(boolean stop) {
        ThunderLog.release("yrtc", "stopVideoPreview stopLocalVideoStream:" + stop + " isEnableVideo:" + this.isEnableVideo + ",isOtherSource" + this.isOtherSource + " isMuteLocalVideo " + this.isStopLocalVideo + " isPreview " + this.isPreview);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue() || this.isStopLocalVideo.booleanValue()) {
            return -2;
        }
        if (stop) {
            if (this.mBVideoPublish) {
                ThunderAPI.sharedInstance().getPublishRoom().setVideoEnable(false);
                this.mBVideoPublish = false;
                this.mVideoStringName = "";
            }
        } else if (this.isJoinRoom.booleanValue() && !this.mBVideoPublish && (this.isPreview.booleanValue() || this.isOtherSource.booleanValue())) {
            ThunderAPI.sharedInstance().getPublishRoom().setVideoEnable(true);
            this.mBVideoPublish = true;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopRemoteVideoStream(String uid, boolean stop) {
        ThunderLog.release("yrtc", "stopRemoteVideoStream Uid:" + uid + " stop:" + stop + " isEnableVideo:" + this.isEnableVideo);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        this.uidMuteVideoList.put(uid, stop);
        long lUid = UidMap.getLongUid(uid);
        if (stop) {
            ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);
            Object object = this.streamLock;
            synchronized (object) {
                for (ThunderStream oneStream : this.anchorStreams) {
                    if (lUid != oneStream.speakerUid || !oneStream.bVideo) continue;
                    stopStreams.add(oneStream);
                }
                for (ThunderStream oneStream : stopStreams) {
                    this.anchorStreams.remove(oneStream);
                }
            }
            if (this.isJoinRoom.booleanValue()) {
                ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
            }
        } else {
            ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);
            ThunderStream newStream = null;
            boolean alreadyPlay = false;
            Object object = this.streamLock;
            synchronized (object) {
                for (ThunderStream oneStream : this.wholeStreams) {
                    if (lUid != oneStream.speakerUid || !oneStream.bVideo) continue;
                    newStream = oneStream;
                    break;
                }
                if (newStream == null) {
                    return 0;
                }
                for (ThunderStream oneStream : this.anchorStreams) {
                    if (lUid != oneStream.speakerUid || !oneStream.bVideo) continue;
                    alreadyPlay = true;
                    break;
                }
                if (!alreadyPlay) {
                    if (this.remoteCanvas != null) {
                        for (ThunderVideoCanvas oneCanvas : this.remoteCanvas) {
                            if (UidMap.getLongUid(oneCanvas.mUid) != newStream.speakerUid) continue;
                            newStream.toView = oneCanvas.mView;
                            newStream.scaleMode = oneCanvas.mRenderMode;
                        }
                    }
                    startStreams.add(newStream);
                    this.anchorStreams.add(newStream);
                }
            }
            if (this.isJoinRoom.booleanValue()) {
                ThunderAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopAllRemoteVideoStreams(boolean stop) {
        ThunderLog.release("yrtc", "stopAllRemoteVideoStreams  stop:" + stop + " isEnableVideo:" + this.isEnableVideo);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        this.isStopAllVideo = stop;
        this.uidMuteVideoList.clear();
        if (stop) {
            ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);
            Object object = this.streamLock;
            synchronized (object) {
                for (ThunderStream oneStream : this.anchorStreams) {
                    if (!oneStream.bVideo) continue;
                    stopStreams.add(oneStream);
                }
                for (ThunderStream oneStream : stopStreams) {
                    this.anchorStreams.remove(oneStream);
                }
            }
            if (this.isJoinRoom.booleanValue()) {
                ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
            }
        } else {
            ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);
            Object object = this.streamLock;
            synchronized (object) {
                for (ThunderStream oneStream : this.wholeStreams) {
                    boolean isPlaying = false;
                    if (!oneStream.bVideo) continue;
                    for (ThunderStream anStream : this.anchorStreams) {
                        if (anStream.speakerUid != oneStream.speakerUid || !anStream.bVideo) continue;
                        isPlaying = true;
                        break;
                    }
                    if (isPlaying) continue;
                    if (this.remoteCanvas != null) {
                        for (ThunderVideoCanvas oneCanvas : this.remoteCanvas) {
                            if (UidMap.getLongUid(oneCanvas.mUid) != oneStream.speakerUid) continue;
                            oneStream.toView = oneCanvas.mView;
                            oneStream.scaleMode = oneCanvas.mRenderMode;
                        }
                    }
                    startStreams.add(oneStream);
                    this.anchorStreams.add(oneStream);
                }
            }
            if (this.isJoinRoom.booleanValue()) {
                ThunderAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
            }
        }
        return 0;
    }

    public int registerFaceDetection(IFaceDetection faceDetection) {
        if (this.isEnableVideo.booleanValue() && !this.isThunder.booleanValue()) {
            ThunderAPI.sharedInstance().getPublisher().setMobileFaceDetection(faceDetection);
            return 0;
        }
        return -2;
    }

    public int registerVideoCaptureTextureObserver(IGPUProcess observer) {
        if (this.isEnableVideo.booleanValue() && !this.isThunder.booleanValue()) {
            ThunderAPI.sharedInstance().getPublisher().setVideoCaptureTexture(observer);
            return 0;
        }
        return -2;
    }

    public int registerVideoCaptureFrameObserver(IVideoCaptureObserver observer) {
        if (this.isEnableVideo.booleanValue() && !this.isThunder.booleanValue()) {
            ThunderAPI.sharedInstance().getPublisher().setVideoCaptureFrame(observer);
            return 0;
        }
        return -2;
    }

    public int registerVideoDecodeFrameObserver(String uid, IVideoDecodeObserver observer) {
        if (this.isEnableVideo.booleanValue() && !this.isThunder.booleanValue()) {
            ThunderAPI.sharedInstance().getPlayer().setVideoFrameObserver(uid, observer);
            return 0;
        }
        return -2;
    }

    public int registerAudioFrameObserver(IAudioFrameObserver observer) {
        return ThunderAPI.sharedInstance().registerAudioFrameObserver(observer);
    }

    public int setRecordingAudioFrameParameters(int sampleRate, int room, int mode, int samplesPerCall) {
        return ThunderAPI.sharedInstance().setRecordingAudioFrameParameters(sampleRate, room, mode, samplesPerCall);
    }

    public int setPlaybackAudioFrameParameters(int sampleRate, int room, int mode, int samplesPerCall) {
        return ThunderAPI.sharedInstance().setPlaybackAudioFrameParameters(sampleRate, room, mode, samplesPerCall);
    }

    public int setVideoWatermark(ThunderBoltImage watermark) {
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        Bitmap bitmap = null;
        int x = 0;
        int y = 0;
        if (watermark != null) {
            x = watermark.x;
            y = watermark.y;
            Bitmap tmpBitmap = BitmapFactory.decodeFile((String)watermark.url);
            int w = tmpBitmap.getWidth();
            int h = tmpBitmap.getHeight();
            Matrix matrix = new Matrix();
            float scaleW = (float)watermark.width / (float)w;
            float scaleH = (float)watermark.height / (float)h;
            matrix.postScale(scaleW, scaleH);
            bitmap = Bitmap.createBitmap((Bitmap)tmpBitmap, (int)0, (int)0, (int)w, (int)h, (Matrix)matrix, (boolean)true);
        }
        return ThunderAPI.sharedInstance().getPublishRoom().setWatermark(x, y, bitmap);
    }

    public int setCustomAudioSource(boolean enabled, int sampleRate, int channel) {
        if (enabled) {
            if (this.mAudioSource == null) {
                this.mAudioSource = new ExternalAudioSource(sampleRate, channel);
            }
        } else {
            this.mAudioSource = null;
        }
        ThunderAPI.sharedInstance().getPublishRoom().attachAudioCapture(this.mAudioSource);
        return 0;
    }

    public int pushCustomAudioFrame(byte[] data, long timeStamp) {
        if (this.mAudioSource == null) {
            ThunderLog.info("yrtc", "ExternalAudioSource is null");
            return -1;
        }
        this.mAudioSource.pushCustomAudioFrame(data, timeStamp);
        return 0;
    }

    public int setCustomVideoSource(ThunderCustomVideoSource videoSource) {
        ThunderLog.release("yrtc", "setCustomVideoSource  isThunder:" + this.isThunder + " isEnableVideo:" + this.isEnableVideo + "videoSource == null ?" + (videoSource == null));
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        if (videoSource == null) {
            ThunderAPI.sharedInstance().getPublishRoom().attachVideoCapture(ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera());
            this.isOtherSource = false;
        } else if (videoSource instanceof ScreenRecordSource) {
            ThunderAPI.sharedInstance().getPublishRoom().attachVideoCapture(((ScreenRecordSource)videoSource).mScreenCapture);
            this.isOtherSource = true;
        } else {
            ExternalVideoSource externalVideoSource = new ExternalVideoSource(videoSource);
            ThunderAPI.sharedInstance().getPublishRoom().attachVideoCapture(externalVideoSource);
            this.isOtherSource = true;
        }
        return 0;
    }

    public int addPublishOriginStreamUrl(String url) {
        return ThunderAPI.sharedInstance().updateSrcStreamUrlSet(true, url);
    }

    public int removePublishOriginStreamUrl(String url) {
        return ThunderAPI.sharedInstance().updateSrcStreamUrlSet(false, url);
    }

    public int addPublishTranscodingStreamUrl(String taskId, String url) {
        return ThunderAPI.sharedInstance().updateTranscodingStreamUrlMap(taskId, true, url);
    }

    public int removePublishTranscodingStreamUrl(String taskId, String url) {
        return ThunderAPI.sharedInstance().updateTranscodingStreamUrlMap(taskId, false, url);
    }

    public int setLiveTranscodingTask(String taskId, LiveTranscoding transcoding) {
        return ThunderAPI.sharedInstance().updateTranscodingMap(taskId, false, transcoding);
    }

    public int removeLiveTranscodingTask(String taskId) {
        return ThunderAPI.sharedInstance().updateTranscodingMap(taskId, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSubscribe(String roomId, String uid) {
        ThunderLog.release("yrtc", "addSubscribe roomId %s, uid %s", roomId, uid);
        if (this.mRoomName.equals(roomId)) {
            return -1;
        }
        Object object = this.streamLock;
        synchronized (object) {
            Set<String> streamSet = this.subscribeStreamMap.get(roomId);
            if (streamSet == null) {
                streamSet = new HashSet<String>();
            }
            streamSet.add(uid);
            this.subscribeStreamMap.put(roomId, streamSet);
        }
        return ThunderAPI.sharedInstance().addSubscribe(roomId, uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeSubscribe(String roomId, String uid) {
        ThunderLog.release("yrtc", "removeSubscribe roomId %s, uid %s", roomId, uid);
        if (this.mRoomName.equals(roomId)) {
            return -1;
        }
        Long lUid = UidMap.getLongUid(uid);
        ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);
        Object object = this.streamLock;
        synchronized (object) {
            Set<String> streamSet;
            ThunderStream stream;
            Iterator<ThunderStream> it = this.anchorStreams.iterator();
            while (it.hasNext()) {
                stream = it.next();
                if (stream == null || lUid != stream.speakerUid) continue;
                stopStreams.add(stream);
                it.remove();
            }
            it = this.wholeStreams.iterator();
            while (it.hasNext()) {
                stream = it.next();
                if (stream == null || lUid != stream.speakerUid) continue;
                it.remove();
            }
            if (stopStreams.size() > 0) {
                ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
            }
            if ((streamSet = this.subscribeStreamMap.get(roomId)) != null && streamSet.contains(uid)) {
                streamSet.remove(uid);
                if (streamSet.size() == 0) {
                    this.subscribeStreamMap.remove(roomId);
                    this.channelStreamsList.remove(roomId);
                    return ThunderAPI.sharedInstance().removeSubscribe(roomId, uid);
                }
            }
        }
        return 0;
    }

    public int switchFrontCamera(boolean bFront) {
        boolean ret = false;
        this.mIsFrontCamera = bFront;
        ret = bFront ? ThunderAPI.sharedInstance().getPublishRoom().setCameraPosition(0) : ThunderAPI.sharedInstance().getPublishRoom().setCameraPosition(1);
        return ret ? 0 : -1;
    }

    public int setVideoCaptureOrientation(int orientation) {
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        ThunderNative.setOrientation(orientation);
        return 0;
    }

    public int setLocalVideoMirrorMode(int mode) {
        ThunderLog.info("ycall-Java", "setLocalVideoMirrorMode %d", mode);
        if (!this.isEnableVideo.booleanValue() || this.isThunder.booleanValue()) {
            return -2;
        }
        if (!this.mIsFrontCamera) {
            return -1;
        }
        switch (mode) {
            case 0: {
                ThunderNative.enablePreviewMirror(true);
                ThunderNative.enableMirror(false);
                break;
            }
            case 1: {
                ThunderNative.enablePreviewMirror(true);
                ThunderNative.enableMirror(true);
                break;
            }
            case 2: {
                ThunderNative.enablePreviewMirror(false);
                ThunderNative.enableMirror(false);
                break;
            }
            case 3: {
                ThunderNative.enablePreviewMirror(false);
                ThunderNative.enableMirror(true);
                break;
            }
            default: {
                ThunderLog.info("ycall-Java", "invalid mirror mode");
                return -1;
            }
        }
        return 0;
    }

    public boolean getIsThunder() {
        return this.isThunder;
    }

    private void tryStopPublish() {
        if (this.isThunder.booleanValue()) {
            if (this.mBAudioPublish) {
                ThunderAPI.sharedInstance().getPublisher().stopPublishAudio();
                this.mBAudioPublish = false;
                this.mStringName = "";
            }
        } else if (this.mBAudioPublish) {
            ThunderAPI.sharedInstance().getPublishRoom().setAudioEnable(false);
            this.mBAudioPublish = false;
            this.mStringName = "";
        }
    }

    private void tryStopVideoPublish() {
        if (this.mBVideoPublish) {
            ThunderAPI.sharedInstance().getPublishRoom().setVideoEnable(false);
            this.mBVideoPublish = false;
            this.mVideoStringName = "";
        }
    }

    private void tryStopSubscribe() {
        if (this.isThunder.booleanValue()) {
            if (this.mBGroupSubscribe) {
                ArrayList<ThunderGroup> audioGroup = new ArrayList<ThunderGroup>(0);
                ThunderGroup oneGroup = new ThunderGroup();
                oneGroup.appId = this.mRoomAppId;
                oneGroup.groupName = "g_" + this.mRoomName;
                audioGroup.add(oneGroup);
                ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(null, audioGroup);
                this.mBGroupSubscribe = false;
            }
        } else {
            ArrayList<ThunderStream> stopSteams = new ArrayList<ThunderStream>(0);
            for (ThunderStream oneStream : this.anchorStreams) {
                if (oneStream.bVideo) continue;
                stopSteams.add(oneStream);
            }
            if (stopSteams.size() > 0) {
                for (ThunderStream oneStream : stopSteams) {
                    this.anchorStreams.remove(oneStream.streamName);
                }
                ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopSteams, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryStopVideoSubscribe() {
        ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);
        Object object = this.streamLock;
        synchronized (object) {
            for (ThunderStream oneStream : this.anchorStreams) {
                if (!oneStream.bVideo) continue;
                stopStreams.add(oneStream);
            }
            ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
            for (ThunderStream oneStream : stopStreams) {
                this.anchorStreams.remove(oneStream);
            }
        }
    }

    private void tryStopVideoPreview() {
        if (this.isPreview.booleanValue()) {
            this.stopVideoPreview();
            this.isPreview = false;
        }
    }

    private void addUid2String(long iUid, String strUid) {
        if (strUid.equals(this.mMyStrUid)) {
            this.mRecv64UidMap = true;
            this.mMyUid = iUid;
            ThunderNative.setUserInfo(iUid, 0);
            this.notifyJoinSuccess();
        }
        UidMap.addUid2String(iUid, strUid);
    }

    private void resetRtcEngine() {
        mHandler = null;
        sMyAppId = 0;
        sMySceneId = 0L;
        mRtcEventHandler = null;
        mHttpsRequestHandler = null;
        this.mMyUid = 0L;
        this.mIs32bitUid = false;
        this.mMyStrUid = "";
        UidMap.removeAllUid2String();
        mLogLevel = 0;
        mLogPath = "";
        mYyLogCallback = null;
        this.mBGroupSubscribe = false;
        this.mBAudioPublish = false;
        this.mRoomAppId = 0;
        this.mRoomConfig = 0;
        this.mAudioConfig = 0;
        this.mCommutMode = 0;
        this.mScenarioMode = 0;
        s_playVolumeNotifyCount = 0;
        s_playDataNotifyCount = 0;
        this.mBEnablePlayDataIndication = false;
        this.mEqGains = new int[11];
        this.mBEnableEqualizer = false;
        this.mBEnableCompressor = false;
        this.mBEnableLimiter = false;
        this.mBEnableReverbEx = false;
        this.mReverbExGains = new ReverbExParameter();
        this.mCompressorGains = new CompressorParam();
        this.mLimiterGins = new LimterParam();
        for (ThunderAudioFilePlayer audioFilePlayer : this.mAudioFilePlayerSet) {
            audioFilePlayer.destroyAudioFilePlayer();
        }
        this.mAudioFilePlayerSet.clear();
        this.accompanyType = -1;
        mLocalPreviewView = null;
        this.isPreview = false;
        this.isStopLocalVideo = false;
    }

    private String getPrintString(String str) {
        String result = "";
        if (str != null) {
            result = str;
        }
        return result;
    }

    private String getPrintString(byte[] data) {
        String result = "";
        if (data != null) {
            result = data.toString();
        }
        return result;
    }

    private String getPrintString(Object obj) {
        String result = "";
        if (obj != null) {
            result = obj.toString();
        }
        return result;
    }

    private boolean isMuteVideoStreamWithUid(long uid) {
        if (!this.isEnableVideo.booleanValue()) {
            return true;
        }
        Boolean result = this.uidMuteVideoList.get(UidMap.getStringUid(uid));
        if (result != null) {
            return result;
        }
        return this.isStopAllVideo;
    }

    private boolean isMuteAudioStreamWithUid(long uid) {
        if (!this.isEnableAudio.booleanValue()) {
            return true;
        }
        Boolean result = this.uidMuteAudioList.get(UidMap.getStringUid(uid));
        if (result != null) {
            return result;
        }
        return this.isStopAllAudio;
    }

    public static void notifyNetworkTypeChanged(int netState) {
        if (mRtcEventHandler != null) {
            int type;
            switch (netState) {
                case 0: {
                    type = 3;
                    break;
                }
                case 1: {
                    type = 4;
                    break;
                }
                case 2: {
                    type = 1;
                    break;
                }
                case 3: {
                    type = 5;
                    break;
                }
                case 4: {
                    type = 6;
                    break;
                }
                case 5: {
                    type = 7;
                    break;
                }
                case 127: {
                    type = 0;
                    break;
                }
                default: {
                    type = 0;
                }
            }
            mRtcEventHandler.onNetworkTypeChanged(type);
        }
    }

    public static void notifyServiceLinkStatus(int status) {
        if ((status == 1 || status == 3 || status == 4) && mHandler != null) {
            int convertStatus = 0;
            switch (status) {
                case 1: {
                    convertStatus = 0;
                    break;
                }
                case 3: {
                    convertStatus = 1;
                    break;
                }
                case 4: {
                    convertStatus = 2;
                }
            }
            Message msg = Message.obtain();
            msg.what = 34;
            msg.obj = new ThunderNotification.ServiceLinkStatus(convertStatus);
            mHandler.sendMessage(msg);
        }
    }

    static {
        mServiceLinkStatus = 2;
        mTransLinkStatus = 2;
        mLogPath = "";
        mLogLevel = 0;
        mYyLogCallback = null;
        s_playVolumeNotifyCount = 0;
        s_playDataNotifyCount = 0;
        mHandler = null;
        appContext = null;
        mLocalPreviewView = null;
    }

    private static class SingleonHolder {
        private static ThunderEngine INSTANCE = new ThunderEngine();

        private SingleonHolder() {
        }
    }

    public static final class LimterParam {
        public float fCeiling = 0.0f;
        public float fThreshold = 0.0f;
        public float fPreGain = 0.0f;
        public float fRelease = 0.0f;
        public float fAttack = 0.0f;
        public float fLookahead = 0.0f;
        public float fLookaheadRatio = 0.0f;
        public float fRMS = 0.0f;
        public float fStLink = 0.0f;
    }

    public static final class CompressorParam {
        public int mThreshold = 0;
        public int mMakeupGain = 0;
        public int mRatio = 0;
        public int mKnee = 0;
        public int mReleaseTime = 0;
        public int mAttackTime = 0;
    }

    public static final class ReverbExParameter {
        public float mRoomSize = 0.0f;
        public float mPreDelay = 0.0f;
        public float mReverberance = 0.0f;
        public float mHfDamping = 0.0f;
        public float mToneLow = 0.0f;
        public float mToneHigh = 0.0f;
        public float mWetGain = 0.0f;
        public float mDryGain = 0.0f;
        public float mStereoWidth = 0.0f;
    }

    private static class NotificationHandler
    extends Handler {
        private final WeakReference<ThunderEngine> mThunderEngine;

        public NotificationHandler(ThunderEngine rtc) {
            this.mThunderEngine = new WeakReference<ThunderEngine>(rtc);
        }

        public NotificationHandler(ThunderEngine rtc, Looper loop) {
            super(loop);
            this.mThunderEngine = new WeakReference<ThunderEngine>(rtc);
        }

        public void handleMessage(Message msg) {
            try {
                switch (msg.what) {
                    case 0: {
                        ThunderNotification.PublishStatusInfo info = (ThunderNotification.PublishStatusInfo)msg.obj;
                        if (info.getStatus() == 0) {
                            int elapsed = (int)(System.currentTimeMillis() - ((ThunderEngine)this.mThunderEngine.get()).joinEnd);
                            if (mRtcEventHandler != null) {
                                if (info.isVideo()) {
                                    mRtcEventHandler.onFirstLocalVideoFrameSent(elapsed);
                                } else {
                                    mRtcEventHandler.onFirstLocalAudioFrameSent(elapsed);
                                }
                            }
                        }
                        ThunderLog.release(ThunderEngine.TAG, String.format("ThunderNotification.PublishStatusInfo stream=%s status=%d", info.getStreamName(), info.getStatus()));
                        break;
                    }
                    case 1: {
                        ThunderNotification.PublishRunTimeInfo info = (ThunderNotification.PublishRunTimeInfo)msg.obj;
                        ThunderLog.info(ThunderEngine.TAG, String.format("ThunderNotification.PublishRunTimeInfo stream=%s fps=%d bitrate=%d audioBitrate=%d resolution=%dx%d", info.getStreamName(), info.getInfo().getFps(), info.getInfo().getBitrate(), info.getInfo().getAudioBitrate(), info.getInfo().getWidth(), info.getInfo().getHeight()));
                        break;
                    }
                    case 2: {
                        ThunderNotification.PlayStatusInfo info = (ThunderNotification.PlayStatusInfo)msg.obj;
                        ThunderLog.release(ThunderEngine.TAG, String.format("ThunderNotification.PlayStatusInfo stream=%s status=%d", info.getStream().streamName, info.getStatus()));
                        if (this.mThunderEngine.get() != null) {
                            switch (info.getStatus()) {
                                case -1: {
                                    break;
                                }
                                case 0: {
                                    if (mRtcEventHandler == null || !((ThunderEngine)this.mThunderEngine.get()).getIsThunder()) break;
                                    ((ThunderEngine)this.mThunderEngine.get()).isJoinRoom = true;
                                    mRtcEventHandler.onJoinRoomSuccess(((ThunderEngine)this.mThunderEngine.get()).getRoomName(), ((ThunderEngine)this.mThunderEngine.get()).getMyUid(), 0);
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    if (mRtcEventHandler == null || !((ThunderEngine)this.mThunderEngine.get()).getIsThunder()) break;
                                    ThunderEventHandler.RoomStats status = new ThunderEventHandler.RoomStats();
                                    mRtcEventHandler.onLeaveRoom(status);
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                                case 4: {
                                    long renderTime = System.currentTimeMillis();
                                    ThunderStream playStream = info.getStream();
                                    ThunderStream findStream = ThunderAPI.sharedInstance().getPlayer().getSubscribeStreamByUid(playStream.speakerUid);
                                    if (findStream == null) break;
                                    int elapseTime = (int)(renderTime - findStream.startSubscribeTime);
                                    mRtcEventHandler.onRemoteVideoPlay(UidMap.getStringUid(findStream.speakerUid), findStream.width, findStream.height, elapseTime);
                                    break;
                                }
                            }
                        }
                        ThunderLog.release(ThunderEngine.TAG, " mThunderEngine = " + this.mThunderEngine.get());
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        ThunderNotification.ThunderAudioCaptureVolume info = (ThunderNotification.ThunderAudioCaptureVolume)msg.obj;
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onCaptureVolumeIndication(info.mVolume, (int)info.mCpt, info.mMicVolume);
                        break;
                    }
                    case 5: {
                        ThunderNotification.AudioVolumeInfo info = (ThunderNotification.AudioVolumeInfo)msg.obj;
                        if (info.getVolumeInfos() == null) break;
                        int maxVol = 0;
                        int index = 0;
                        ArrayList<ThunderEventHandler.AudioVolumeInfo> volInfos = new ArrayList<ThunderEventHandler.AudioVolumeInfo>();
                        for (Map.Entry<Long, ThunderNotification.ThunderVolumeInfo> entry : info.getVolumeInfos().entrySet()) {
                            if (entry.getValue().mActualSpeakerUidList == null || entry.getValue().mActualSpeakerUidList.isEmpty()) continue;
                            for (long uid : entry.getValue().mActualSpeakerUidList) {
                                ThunderEventHandler.AudioVolumeInfo volInfo = new ThunderEventHandler.AudioVolumeInfo();
                                String string = volInfo.uid = ((ThunderEngine)this.mThunderEngine.get()).getIsThunder() ? UidMap.getStringUidFromMap(uid) : UidMap.getStringUid(uid);
                                if (volInfo.uid == null || volInfo.uid.isEmpty()) continue;
                                volInfo.volume = entry.getValue().mVolume;
                                volInfo.pts = (int)entry.getValue().mPts;
                                if (maxVol < volInfo.volume) {
                                    maxVol = volInfo.volume;
                                }
                                ++index;
                                volInfos.add(volInfo);
                                if (s_playVolumeNotifyCount % 200 != 0) continue;
                                ThunderLog.release(ThunderEngine.TAG, String.format("ThunderNotification.AudioPlayVolume, [%d] uid %s, volume %d", index, volInfo.uid.toString(), volInfo.volume));
                            }
                        }
                        int volSize = volInfos.size();
                        if (volSize > 0) {
                            ThunderEventHandler.AudioVolumeInfo[] volList = new ThunderEventHandler.AudioVolumeInfo[volSize];
                            for (int i = 0; i < volSize; ++i) {
                                volList[i] = (ThunderEventHandler.AudioVolumeInfo)volInfos.get(i);
                            }
                            if (mRtcEventHandler != null) {
                                mRtcEventHandler.onPlayVolumeIndication(volList, maxVol);
                                ++s_playVolumeNotifyCount;
                            }
                        }
                        break;
                    }
                    case 6: {
                        ThunderNotification.BizAuthResult result = (ThunderNotification.BizAuthResult)msg.obj;
                        ThunderLog.release(ThunderEngine.TAG, String.format("ThunderNotification.BizAuthResult stream=%s group=%s result=%d", result.getAuthStream() != null ? result.getAuthStream().streamName : "null", result.getAuthGroup() != null ? result.getAuthGroup().groupName : "null", result.getBizAuthResult()));
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onBizAuthResult(result.isPublishAuth(), result.getBizAuthResult());
                        break;
                    }
                    case 7: {
                        ThunderNotification.SdkAuthResult result = (ThunderNotification.SdkAuthResult)msg.obj;
                        ThunderLog.release(ThunderEngine.TAG, String.format("ThunderNotification.SdkAuthResult appId=%d uid=%d result=%d", result.getAppId(), result.getUid(), result.getSdkAuthResult()));
                        if (mRtcEventHandler == null) break;
                        int authResult = result.getSdkAuthResult();
                        switch (authResult) {
                            case 0: {
                                if (!((ThunderEngine)this.mThunderEngine.get()).mIsUserBanned) break;
                                ((ThunderEngine)this.mThunderEngine.get()).mIsUserBanned = false;
                                mRtcEventHandler.onUserBanned(false);
                                break;
                            }
                            case 10005: {
                                mRtcEventHandler.onTokenRequested();
                                break;
                            }
                            case 10007: {
                                mRtcEventHandler.onTokenWillExpire(((ThunderEngine)this.mThunderEngine.get()).mToken);
                                break;
                            }
                            case 10008: {
                                ((ThunderEngine)this.mThunderEngine.get()).mIsUserBanned = true;
                                mRtcEventHandler.onUserBanned(true);
                            }
                        }
                        mRtcEventHandler.onSdkAuthResult(authResult);
                        break;
                    }
                    case 9: {
                        ThunderNotification.UidInt2String result = (ThunderNotification.UidInt2String)msg.obj;
                        if (result.getIsAdd()) {
                            ((ThunderEngine)this.mThunderEngine.get()).addUid2String(result.getUidInt(), result.getUidString());
                        } else {
                            UidMap.removeUid2String(result.getUidInt());
                        }
                        ThunderLog.release(ThunderEngine.TAG, String.format("ThunderNotification.UidInt2String uid=%d str=%s isAdd=%b", result.getUidInt(), result.getUidString(), result.getIsAdd()));
                        break;
                    }
                    case 14: {
                        ThunderNotification.AudioDataInfo result = (ThunderNotification.AudioDataInfo)msg.obj;
                        long uid = result.getUid();
                        String strUid = UidMap.getStringUid(uid);
                        if (!((ThunderEngine)this.mThunderEngine.get()).mIs32bitUid && (strUid == null || strUid.isEmpty())) {
                            return;
                        }
                        int duration = result.getDuration();
                        int cpt = result.getCpt();
                        int pts = result.getPts();
                        byte[] data = result.getData();
                        int len = 0;
                        if (null != data) {
                            len = data.length;
                        }
                        if (s_playDataNotifyCount % 500 == 0) {
                            ThunderLog.release(ThunderEngine.TAG, String.format("ThunderNotification.AudioPlayData,cpt:%d,pts:%d, len:%d", cpt, pts, len));
                        }
                        ++s_playDataNotifyCount;
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onAudioPlayData(data, cpt, pts, strUid, duration);
                        break;
                    }
                    case 15: {
                        ThunderNotification.AudioPlaySpectrumData result = (ThunderNotification.AudioPlaySpectrumData)msg.obj;
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onAudioPlaySpectrumData(result.getData());
                        break;
                    }
                    case 16: {
                        ThunderNotification.AudioCapturePcmData result = (ThunderNotification.AudioCapturePcmData)msg.obj;
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onAudioCapturePcmData(result.getData(), result.getDataSize(), result.getSampleRate(), result.getChannel());
                        break;
                    }
                    case 19: {
                        ThunderNotification.AudioRenderPcmData result = (ThunderNotification.AudioRenderPcmData)msg.obj;
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onAudioRenderPcmData(result.getData(), result.getDataSize(), result.getDuration(), result.getSampleRate(), result.getChannel());
                        break;
                    }
                    case 17: {
                        ThunderNotification.UserAppMsgData result = (ThunderNotification.UserAppMsgData)msg.obj;
                        long uid = result.getUid();
                        String strUid = UidMap.getStringUid(uid);
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onRecvUserAppMsgData(result.getData(), strUid);
                        break;
                    }
                    case 18: {
                        ThunderNotification.AppMsgDataFailedStatus result = (ThunderNotification.AppMsgDataFailedStatus)msg.obj;
                        ThunderLog.info(ThunderEngine.TAG, String.format("ThunderNotification.AppMsgDataFailedStatus status=%d", result.getFailedStatus()));
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onSendAppMsgDataFailedStatus(result.getFailedStatus());
                        break;
                    }
                    case 23: {
                        ThunderNotification.InitiateHttpsRequest result = (ThunderNotification.InitiateHttpsRequest)msg.obj;
                        String reqUrl = result.getReqUrl();
                        int target = result.getTarget();
                        ThunderLog.info(ThunderEngine.TAG, String.format("ThunderNotification.InitiateHttpsRequest reqUrl=%s target=%d", reqUrl, target));
                        if (mHttpsRequestHandler == null) break;
                        mHttpsRequestHandler.send(reqUrl, target);
                        break;
                    }
                    case 22: {
                        ThunderNotification.PublishRoomStreamInfo info = (ThunderNotification.PublishRoomStreamInfo)msg.obj;
                        ThunderLog.info(ThunderEngine.TAG, "*************** (Not deal in thunderbolt)PublishRoomStreamInfo ***************");
                        ThunderLog.info(ThunderEngine.TAG, "ThunderNotification.PublishRoomStreamInfo roomID:" + info.getRoomId() + " streams:" + info.getStreams().size());
                        for (ThunderStream oneStream : info.getStreams()) {
                            ThunderLog.info(ThunderEngine.TAG, String.format("ThunderNotification.PublishRoomStreamInfo stream name:%s speak id:%d appid:%d", oneStream.streamName, oneStream.speakerUid, oneStream.appId));
                        }
                        ThunderLog.info(ThunderEngine.TAG, "*************** *********************************************** ***************");
                        break;
                    }
                    case 24: {
                        ThunderNotification.StreamsNotify info = (ThunderNotification.StreamsNotify)msg.obj;
                        ThunderLog.info(ThunderEngine.TAG, "*************** kThunderAPINotification_StreamsNotify ***************");
                        ThunderLog.info(ThunderEngine.TAG, "ThunderNotification.StreamsNotify roomID:" + info.getRoomId() + " streams:" + info.getStreams().size());
                        for (ThunderStream oneStream : info.getStreams()) {
                            ThunderLog.info(ThunderEngine.TAG, String.format("ThunderNotification.StreamsNotify stream name:%s speak id:%d appid:%d", oneStream.streamName, oneStream.speakerUid, oneStream.appId));
                        }
                        ThunderLog.info(ThunderEngine.TAG, "*************** *********************************************** ***************");
                        ((ThunderEngine)this.mThunderEngine.get()).onStreamsNotify(info);
                        break;
                    }
                    case 13: {
                        ThunderNotification.ResolutionChangeInfo info = (ThunderNotification.ResolutionChangeInfo)msg.obj;
                        ThunderAPI.sharedInstance().getPlayer().setSubscribeStreamWHByUid(info.getStream().speakerUid, info.getWidth(), info.getHeight());
                        mRtcEventHandler.onVideoSizeChanged(UidMap.getStringUid(info.getStream().speakerUid), info.getWidth(), info.getHeight(), 0);
                        break;
                    }
                    case 27: {
                        ThunderNotification.UserMuteAudio result = (ThunderNotification.UserMuteAudio)msg.obj;
                        if (mRtcEventHandler == null || !((ThunderEngine)this.mThunderEngine.get()).getIsThunder()) break;
                        mRtcEventHandler.onRemoteAudioStopped(result.getUid(), result.isMuted());
                        break;
                    }
                    case 28: {
                        ThunderNotification.UserJoined result = (ThunderNotification.UserJoined)msg.obj;
                        if (mRtcEventHandler == null || !((ThunderEngine)this.mThunderEngine.get()).getIsThunder()) break;
                        int elapsed = (int)(System.currentTimeMillis() - ((ThunderEngine)this.mThunderEngine.get()).joinEnd);
                        mRtcEventHandler.onUserJoined(result.getUid(), elapsed);
                        break;
                    }
                    case 29: {
                        ThunderNotification.UserOffline result = (ThunderNotification.UserOffline)msg.obj;
                        if (mRtcEventHandler == null || !((ThunderEngine)this.mThunderEngine.get()).getIsThunder()) break;
                        mRtcEventHandler.onUserOffline(result.getUid(), result.getReason());
                        break;
                    }
                    case 30: {
                        ThunderNotification.NetworkQuality result = (ThunderNotification.NetworkQuality)msg.obj;
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onNetworkQuality(result.getUid(), result.getTxQuality(), result.getRxQuality());
                        break;
                    }
                    case 31: {
                        ThunderNotification.RoomStats result = (ThunderNotification.RoomStats)msg.obj;
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onRoomStats(result);
                        break;
                    }
                    case 32: {
                        ThunderNotification.RtmpStreamNotify2Service result = (ThunderNotification.RtmpStreamNotify2Service)msg.obj;
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onPublishStreamToCDNStatus(result.getUrl(), result.getAction());
                        break;
                    }
                    case 33: {
                        ThunderNotification.TransLinkStatus result = (ThunderNotification.TransLinkStatus)msg.obj;
                        mTransLinkStatus = result.getStatus();
                        this.checkDisconnectedStatus();
                        if (mServiceLinkStatus == 1) {
                            this.removeMessages(35);
                        }
                        if (mRtcEventHandler == null) break;
                        if (((ThunderEngine)this.mThunderEngine.get()).getIsThunder()) {
                            mRtcEventHandler.onConnectionStatus(result.getStatus());
                            break;
                        }
                        if (mTransLinkStatus == 1) {
                            if (mServiceLinkStatus != 1) break;
                            mRtcEventHandler.onConnectionStatus(result.getStatus());
                            break;
                        }
                        mRtcEventHandler.onConnectionStatus(result.getStatus());
                        break;
                    }
                    case 34: {
                        ThunderNotification.ServiceLinkStatus result = (ThunderNotification.ServiceLinkStatus)msg.obj;
                        mServiceLinkStatus = result.getStatus();
                        this.checkDisconnectedStatus();
                        if (mServiceLinkStatus == 1) {
                            this.removeMessages(35);
                        }
                        if (mRtcEventHandler == null || mRtcEventHandler == null) break;
                        if (((ThunderEngine)this.mThunderEngine.get()).isJoinRoom.booleanValue()) {
                            if (mServiceLinkStatus == 1) {
                                if (mTransLinkStatus != 1) break;
                                mRtcEventHandler.onConnectionStatus(mServiceLinkStatus);
                                break;
                            }
                            mRtcEventHandler.onConnectionStatus(mServiceLinkStatus);
                            break;
                        }
                        mRtcEventHandler.onConnectionStatus(mServiceLinkStatus);
                        break;
                    }
                    case 35: {
                        if (mRtcEventHandler == null) break;
                        mRtcEventHandler.onConnectionLost();
                        break;
                    }
                }
            }
            catch (Exception exc) {
                ThunderLog.error(ThunderEngine.TAG, String.format("handleMessage err=%s", exc.toString()));
            }
        }

        public boolean checkDisconnectedStatus() {
            if (mServiceLinkStatus == 2 || mTransLinkStatus == 2) {
                this.removeMessages(35);
                this.sendEmptyMessageDelayed(35, 10000L);
                return true;
            }
            return false;
        }
    }
}

