package com.yy.yylivesdk4cloud.video;

import android.os.DeadSystemException;

import com.yy.yylivesdk4cloud.helper.ThunderLog;

import java.net.UnknownHostException;

import static com.yy.yylivesdk4cloud.ThunderConstant.ThunderLogLevel.THUNDERLOG_LEVEL_DEBUG;
import static com.yy.yylivesdk4cloud.ThunderConstant.ThunderLogLevel.THUNDERLOG_LEVEL_ERROR;
import static com.yy.yylivesdk4cloud.ThunderConstant.ThunderLogLevel.THUNDERLOG_LEVEL_INFO;
import static com.yy.yylivesdk4cloud.ThunderConstant.ThunderLogLevel.THUNDERLOG_LEVEL_TRACE;
import static com.yy.yylivesdk4cloud.ThunderConstant.ThunderLogLevel.THUNDERLOG_LEVEL_WARN;
import static com.yy.yylivesdk4cloud.helper.ThunderLog.YYLogModule.YYLOG_MODULE_VIDEO;

/**
 * Created by xiaojun on 2017/12/28.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */

public class ThunderVideoLogCallback implements com.yy.videoplayer.utils.ILog,
										   com.yy.mediaframework.utils.ILog {

	private static class SingletonHolder {
		private static final ThunderVideoLogCallback INSTANCE = new ThunderVideoLogCallback();
	}

	public static ThunderVideoLogCallback sharedInstance() {
		return SingletonHolder.INSTANCE;
	}

	@Override
	public void verbose(String tag, String text) {
		ThunderLog.logM(THUNDERLOG_LEVEL_TRACE, YYLOG_MODULE_VIDEO, tag, text);
	}

	@Override
	public void debug(String tag, String text) {
		ThunderLog.logM(THUNDERLOG_LEVEL_DEBUG, YYLOG_MODULE_VIDEO, tag, text);
	}

	@Override
	public void info(String tag, String text) {
		ThunderLog.logM(THUNDERLOG_LEVEL_INFO, YYLOG_MODULE_VIDEO, tag, text);
	}

	@Override
	public void warn(String tag, String text) {
		ThunderLog.logM(THUNDERLOG_LEVEL_WARN, YYLOG_MODULE_VIDEO, tag, text);
	}

	@Override
	public void error(String tag, String text) {
		ThunderLog.logM(THUNDERLOG_LEVEL_ERROR, YYLOG_MODULE_VIDEO, tag, text);
	}

	@Override
	public void error(String tag, String text, Throwable tr) {
		if (tr != null) {
			Throwable t = tr;
			while (t != null) {
				if (t instanceof UnknownHostException) {
					break;
				}
				if (t instanceof DeadSystemException) {
					ThunderLog.error(ThunderLog.kLogTagSdk, "DeadSystemException: The system died; "
							+ "earlier logs will point to the root cause");
					break;
				}
				t = t.getCause();
			}
			if (t == null) {
				tr.printStackTrace();
			}
		}

		ThunderLog.logM(THUNDERLOG_LEVEL_ERROR, YYLOG_MODULE_VIDEO, tag, text);
	}
}
