package com.yy.yylivesdk4cloud.audio;

import com.yy.yylivesdk4cloud.ExternalAudioSource;
import com.yy.yylivesdk4cloud.ThunderAudioCapture;
import com.yy.yylivesdk4cloud.ThunderDefaultMic;
import com.yy.yylivesdk4cloud.ThunderPublisher;

/**
 * Created by xiaojun on 2018/4/4.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */
public class ThunderAudioCaptureProxyImp {

	static boolean isDefaultMic(final Object obj) {
		return (obj instanceof ThunderDefaultMic);
	}

	static boolean isExternalSource(final Object obj) {
		return (obj instanceof ExternalAudioSource);
	}

	static boolean isNeedMicData(final Object obj) {
		return isDefaultMic(obj) && ((ThunderDefaultMic) obj).getMicDataCallback() != null;
	}

	static void startCapture(final long ownerPtr, final long capturePtr, final Object obj) {
		((ThunderAudioCapture)obj).startCapture(new ThunderPublisher.IAudioPublisher() {
			@Override
			public void pushAudioData(byte[] samples, long cts) {
				pushCaptureData(ownerPtr, capturePtr, samples, cts);
			}
		});
	}

	static void stopCapture(final Object obj) {
		((ThunderAudioCapture)obj).stopCapture();
	}

	static int getSampleRate(final Object obj) {
		return ((ThunderAudioCapture)obj).getSampleRate();
	}

	static int getChannels(final Object obj) {
		return ((ThunderAudioCapture)obj).getChannels();
	}

	static int getBitDepth(final Object obj) {
		return ((ThunderAudioCapture)obj).getBitDepth();
	}

	static void onCaptureData(final Object obj,
							  byte[] audioSamples,
							  int nBytesPerSample,
							  boolean bActiveAudio) {
		// only inner microphone need this
		if (!isDefaultMic(obj)) {
			return;
		}
		ThunderDefaultMic.IYYLiveDefaultMicDataCallback callback =
				((ThunderDefaultMic)obj).getMicDataCallback();
		if (callback != null) {
			callback.onAudioDataCallback(audioSamples, bActiveAudio);
		}
	}

	private static native void pushCaptureData(long ownerPtr,
											   long capture,
											   byte[] sampleData,
											   long captureStamp);

}
