package com.yy.yylivesdk4cloud.audio;

import android.util.Log;

import com.yy.audioengine.IAudioLibJniInit;
import com.yy.yylivesdk4cloud.helper.ThunderLog;

import java.util.HashMap;

public class AudioConfigManager implements IAudioConfigCallbackInterface{
    private final static String TAG = "cfg_AudioConfigManage";
    private final static String ARGO_CONFIG_KEY_AUDIO_CODEC = "Android_AudioCodec";
    private final static String ARGO_CONFIG_KEY_AUDIO_PREPROC = "Android_AudioPreProcess";
    private final static String ARGO_CONFIG_KEY_AUDIO_OPENSLES = "Android_OpenSlEs";
    private final static String ARGO_CONFIG_KEY_AUDIO_DEVICE_MODE = "Android_Audio_Device_Mode";
    private final static String ARGO_CONFIG_KEY_AUDIO_KARAOKE_COMP = "Android_Audio_Karaoke_Comp";
	private final static String ARGO_CONFIG_KEY_AUDIO_EFFECT = "Android_Audio_Effect";
    public final static String[] ARGO_CONFIG_KEYS = {
            ARGO_CONFIG_KEY_AUDIO_CODEC,
            ARGO_CONFIG_KEY_AUDIO_PREPROC,
            ARGO_CONFIG_KEY_AUDIO_OPENSLES,
            ARGO_CONFIG_KEY_AUDIO_DEVICE_MODE,
            ARGO_CONFIG_KEY_AUDIO_KARAOKE_COMP,
			ARGO_CONFIG_KEY_AUDIO_EFFECT,
    };

    private IAudioJsonParseInterface mAudioJsonParseImp;
    private HashMap<String, AudioCodecConfig[]> mAudioEncodeConfigs = new HashMap<>();
    private HashMap<String, AudioPreProcConfig[]> mAudioPreProcConfigs = new HashMap<>();
    private HashMap<String, AudioOpenSlEsConfig[]> mAudioOpenSlEsConfig = new HashMap<>();
    private HashMap<String, AudioDeviceModeConfig[]> mAudioDeviceModeConfig = new HashMap<>();
    private HashMap<String, AudioKaraokeCompensateConfig[]> mAudioKaraokeCompConfig = new HashMap<>();
	private HashMap<String, AudioEffectConfig[]> mAudioEffectConfig = new HashMap<>();

    private static class SingletonHolder {
		private static final AudioConfigManager INSTANCE = new AudioConfigManager();
	}

    public static AudioConfigManager instance() {
        return SingletonHolder.INSTANCE;
    }

    private AudioConfigManager() {
        mAudioJsonParseImp = new AudioJsonParseImp(this);
    }

    public AudioCodecConfig getAudioCodecConfigByType(int type){
        AudioCodecConfig[] configs = mAudioEncodeConfigs.get(ARGO_CONFIG_KEY_AUDIO_CODEC);
        AudioCodecConfig curConfig = null;
        if (configs != null && type < configs.length) {
            curConfig = configs[type];
        }
        return curConfig;
    }

    public AudioPreProcConfig getAudioPreProcConfigByType(int type){
        AudioPreProcConfig[] configs = mAudioPreProcConfigs.get(ARGO_CONFIG_KEY_AUDIO_PREPROC);
        AudioPreProcConfig curConfig = null;
        //if (configs != null && type < configs.length) {
        //    curConfig = configs[type];
	//}
        if (configs != null) {
            for(int i=0;i<configs.length;i++){
                if(type == configs[i].sceneId)
                    curConfig = configs[i];
            }
        }        
        return curConfig;
    }

    public AudioEffectConfig getAudioEffectConfigByType(int type){
        AudioEffectConfig[] configs = mAudioEffectConfig.get(ARGO_CONFIG_KEY_AUDIO_EFFECT);
        AudioEffectConfig curConfig = null;
        if (configs != null) {
            for(int i=0;i<configs.length;i++){
                if(type == configs[i].id)
                    curConfig = configs[i];
            }
        }
        return curConfig;
    }

    public void onConfig(String key, String config) {
        if (key == null || config == null) {
            return;
        }
        Log.d("AudioConfig", " onConfig " + key + " : " + config);
        switch (key) {
            case ARGO_CONFIG_KEY_AUDIO_CODEC:
                mAudioJsonParseImp.parseAudioEncodeConfig(config);
                break;
            case ARGO_CONFIG_KEY_AUDIO_PREPROC:
                mAudioJsonParseImp.parseAudioPreProcConfig(config);
                break;
            case ARGO_CONFIG_KEY_AUDIO_OPENSLES:
                mAudioJsonParseImp.parseAudioOpensSlEsConfig(config);
                break;
            case ARGO_CONFIG_KEY_AUDIO_DEVICE_MODE:
                mAudioJsonParseImp.parseAudioDeviceModeConfig(config);
                break;
            case ARGO_CONFIG_KEY_AUDIO_KARAOKE_COMP:
                mAudioJsonParseImp.parseAudioKaraokeCompConfig(config);
                break;
			case ARGO_CONFIG_KEY_AUDIO_EFFECT:
	            mAudioJsonParseImp.parseAudioEffectConfig(config);
	            break;
            default:
                break;
        }
    }

    @Override
    public void notifyAudioEncodeJsonConfigResult(AudioCodecConfig[] configs) {
        if(configs == null || configs.length == 0){
            mAudioEncodeConfigs.clear();
            ThunderLog.error(TAG, "Audio Encode JsonParse error!");
            return;
        }

        for (int i = 0; i < configs.length; i++) {
            ThunderLog.info(TAG, " notifyAudioEncodeJsonConfigResult :" + i + ":" + configs[i].toString());
        }
        mAudioEncodeConfigs.put(ARGO_CONFIG_KEY_AUDIO_CODEC, configs);
    }

    @Override
    public void notifyAudioPreProcJsonConfigResult(AudioPreProcConfig[] configs) {
        if(configs == null || configs.length == 0){
            mAudioPreProcConfigs.clear();
            ThunderLog.error(TAG, "Audio PreProc JsonParse error!");
            return;
        }

        for (int i = 0; i < configs.length; i++) {
            ThunderLog.info(TAG, " notifyAudioPreProcJsonConfigResult :" + i + ":" + configs[i].toString());
        }
        mAudioPreProcConfigs.put(ARGO_CONFIG_KEY_AUDIO_PREPROC, configs);
    }

    @Override
    public void notifyAudioOpenSlEsJsonConfigResult(AudioOpenSlEsConfig[] configs) {
        if(configs == null || configs.length == 0){
            mAudioOpenSlEsConfig.clear();
            ThunderLog.error(TAG, "Audio OpenSlEs JsonParse error!");
            return;
        }

        for (int i = 0; i < configs.length; i++) {
            ThunderLog.info(TAG, " notifyAudioOpenSlEsJsonConfigResult :" + i + ":" + configs[i].toString());
        }
        mAudioOpenSlEsConfig.put(ARGO_CONFIG_KEY_AUDIO_OPENSLES, configs);

        IAudioLibJniInit.SetAndroidOpenSlEsParam(configs[0].inputNumSLBuffer, configs[0].inputNum10msBuffer, configs[0].outputNumSLBuffer, configs[0].outputNum10msBuffer, configs[0].openslesPlayerBuffers);
        IAudioLibJniInit.EnableOpenSlEsOutputNewLogic(configs[0].enableOpenSlEsOutputNewLogic);
    }
    @Override
    public void notifyAudioDeviceModeJsonConfigResult(AudioDeviceModeConfig[] configs) {
        try {
            if(configs == null || configs.length == 0){
                mAudioDeviceModeConfig.clear();
                ThunderLog.error(TAG, "Audio Device Mode JsonParse error!");
                return;
            }

            for (int i = 0; i < configs.length; i++) {
                ThunderLog.info(TAG, " notifyAudioDeviceModeJsonConfigResult :" + i + ":" + configs[i].toString());
            }
            mAudioDeviceModeConfig.put(ARGO_CONFIG_KEY_AUDIO_DEVICE_MODE, configs);

            int[] configArr = new int[12];
            configArr[0] = configs[0].audioLoudMode;
            configArr[1] = configs[0].inputLoudStreamType;
            configArr[2] = configs[0].outputLoudStreamType;
            configArr[3] = configs[0].audioMode;
            configArr[4] = configs[0].inputStreamType;
            configArr[5] = configs[0].outputStreamType;
            configArr[6] = configs[0].audioHDMode;
            configArr[7] = configs[0].inputHDStreamType;
            configArr[8] = configs[0].outputHDStreamType;
            configArr[9] = configs[0].openScraPreduction;
            configArr[10] = configs[0].useJavaInputOpenslesOutput;
            configArr[11] = configs[0].oldSoftAecLogicOnLiveBroadcast;

            IAudioLibJniInit.SetAudioAdaptationConfig(configArr);
        } catch (Exception ex) {
            ThunderLog.info(TAG, " notifyAudioDeviceModeJsonConfigResult fail :" + ex.getMessage());
        }
    }
    @Override
    public void notifyAudioKaraokeCompJsonConfigResult(AudioKaraokeCompensateConfig[] configs) {
        try {
            if(configs == null || configs.length == 0){
                mAudioKaraokeCompConfig.clear();
                ThunderLog.error(TAG, "Audio Karaoke Comp JsonParse error!");
                return;
            }

            for (int i = 0; i < configs.length; i++) {
                ThunderLog.info(TAG, " notifyAudioKaraokeCompJsonConfigResult :" + i + ":" + configs[i].toString());
            }
            mAudioKaraokeCompConfig.put(ARGO_CONFIG_KEY_AUDIO_KARAOKE_COMP, configs);

            IAudioLibJniInit.SetAudioKaraokeCompValue(configs[0].compValue);
        } catch (Exception ex) {
            ThunderLog.info(TAG, " notifyAudioKaraokeCompJsonConfigResult fail :" + ex.getMessage());
        }
    }
	
	@Override
    public void notifyAudioEffectJsonConfigResult(AudioEffectConfig[] configs) {
        if(configs == null || configs.length == 0){
            mAudioEffectConfig.clear();
            ThunderLog.error(TAG, "Audio Effect JsonParse error!");
            return;
        }

        for (int i = 0; i < configs.length; i++) {
            ThunderLog.info(TAG, " notifyAudioEffectJsonConfigResult :" + i + ":" + configs[i].toString());
        }
        mAudioEffectConfig.put(ARGO_CONFIG_KEY_AUDIO_EFFECT, configs);
    }
}
