package com.yy.yylivesdk4cloud;

import android.content.Context;

import com.yy.platform.baseservice.IRPCChannel;
import com.yy.platform.baseservice.YYServiceCore;
import com.yy.platform.baseservice.IChannel;
import com.yy.platform.baseservice.IChannelListener;
import com.yy.platform.baseservice.profile.ChannelProfile;
import com.yy.platform.baseservice.profile.LogProfile;
import com.yy.platform.baseservice.profile.ServiceProfileFactory;
import com.yy.platform.baseservice.task.BroadSubOrUnSubTask;
import com.yy.platform.baseservice.task.RPCTask;
import com.yy.platform.baseservice.utils.UserGroupType;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;

import java.util.ArrayList;
import java.util.HashSet;


public class ThunderServiceChannel implements IChannelListener.IServiceBroadcastNotify, IRPCChannel.RPCCallback<BroadSubOrUnSubTask.ResponseParam> {
    private IChannel mServiceChannel;
    private int mServiceChannelStatus = 0;
    private HashSet<UserGroupType> mGrps = new HashSet<UserGroupType>();
    private long mAppid = 0;

   /**
    * 初始化
    */
    public final static int Init = 0;
    /**
     * 正在连接服务器...
     */
    public final static int OnConnecting = 1;
    /**
     * 连接超时!
     */
    public final static int OnConnecttimeout = 2;
    /**
     * 连接成功!
     */
    public final static int OnConnected = 3;
    /**
     * 连接断开了!
     */
    public final static int OnClosed = 4;
    /**
     * 关闭连接
     */
    public final static int Close = 5;
    /**
     * 连接绑定ID状态!
     */
    public final static int Binded = 6;
    /**
     * 连接成功!
     */

    public void init(Context appContext, long appid) {
        //初始化Service通道
        mAppid = appid;
        YYServiceCore.setUseTrans(false);  // 关闭弱网
        mServiceChannel = YYServiceCore.init(appContext, appid, "",
                new ServiceProfileFactory() {
                    @Override
                    public LogProfile logProfile() {
                        return new LogProfile() {
                            @Override
                            public ILog getLog() {
                                return new ILog() {
                                    @Override
                                    public void outputLog(String log) {
                                        ThunderLog.error(ThunderLog.kLogTagCall, log);
                                    }
                                };
                            }

                            @Override
                            public String logPath() {
                                return null;
                            }

                            @Override
                            public boolean isLogCat() {
                                return false;
                            }
                        };
                    }

                    @Override
                    public ChannelProfile channelProfile() {
                        return null;
                    }

                },
                new IChannelListener.IChannelStatusNotify() {
                    @Override
                    public void onStatus(int status) {
                        mServiceChannelStatus = status;
                        ThunderEngine.notifyServiceLinkStatus(status);
                        ThunderLog.error(ThunderLog.kLogTagCall, "ThunderServiceChannel  init status =  %d", status);
                    }
                });
    }

    public void fini() {
        YYServiceCore.deInit();
        mAppid = 0;
        mGrps.clear();
        mServiceChannel = null;
        mServiceChannelStatus = 0;
    }

    public int getServiceChannelStatus() {
        return mServiceChannelStatus;
    }

    public void registBroadcastListener() {
        ThunderLog.error(ThunderLog.kLogTagCall, "ThunderServiceChannel registBroadcastListener");
        mServiceChannel.registBroadcastListener(this);
    }

    public void unregistBroadcastListener() {
        ThunderLog.error(ThunderLog.kLogTagCall, "ThunderServiceChannel unregistBroadcastListener");
        mServiceChannel.unregistBroadcastListener(this);
    }

    public int subscribeBroadcast(String channelId, String uid) {

        String strAppid = Long.toString(mAppid);
        String hashValue = strAppid + "-" + channelId;
        int hashChan = hashString(hashValue);
        UserGroupType groupTypes = new UserGroupType(2147483686l, toUnsigned(hashChan));

        synchronized (mGrps) {
            RPCTask.RequestParam requestParam = new RPCTask.RequestParam("", "svcLog", uid, "".getBytes(), "", null, null, null);


            mServiceChannel.rpcCall(requestParam, null, new IRPCChannel.RPCCallback<RPCTask.ResponseParam>() {
                @Override
                public void onSuccess(int requestId, RPCTask.ResponseParam response) {

                }

                @Override
                public void onFail(int requestId, int sdkResCode, int srvResCode, Exception e) {

                }
            });

            mGrps.add(groupTypes);
            ThunderLog.error(ThunderLog.kLogTagCall, "ThunderServiceChannel subscribeBroadcast channelid = %s, hashchanid = %d , gid = %d", channelId, hashChan, groupTypes.mGroupId);
            ArrayList<UserGroupType> subGrps = new ArrayList<>(mGrps);
            return mServiceChannel.subscribeBroadcast(subGrps, this);
        }
    }

    public int unSubscribeBroadcast() {
        ThunderLog.error(ThunderLog.kLogTagCall, "ThunderServiceChannel unSubscribeBroadcast all");
        synchronized (mGrps) {
            ArrayList<UserGroupType> unSubGrps = new ArrayList<>(mGrps);
            int ret = mServiceChannel.unSubscribeBroadcast(unSubGrps, this);
            mGrps.clear();
            return ret;
        }
    }

    public int unSubscribeBroadcast(String channelId) {

        String strAppid = Long.toString(mAppid);
        String hashValue = strAppid + "-" + channelId;
        int hashChan = hashString(hashValue);
        UserGroupType removeGroupType = new UserGroupType(2147483686l, toUnsigned(hashChan));

        synchronized (mGrps) {
            if (mGrps.contains(removeGroupType)) {
                mGrps.remove(removeGroupType);
                ArrayList<UserGroupType> grps = new ArrayList<>();
                grps.add(removeGroupType);
                ThunderLog.info(ThunderLog.kLogTagCall, "unSubscribeBroadcast roomId: %s", channelId);
                return mServiceChannel.unSubscribeBroadcast(grps, this);
            } else {
                ThunderLog.error(ThunderLog.kLogTagCall, "not subscribeBroadcast roomId: %s", channelId);
                return -2;
            }
        }

    }

    public void onBroadCast(long uid, long grpType, long grpId, String serviceName, String functionName, String protoType, byte[] data) {
        //service 通知线程
        synchronized (mGrps) {
            for (UserGroupType entry : mGrps) {

                if (entry.mGroupId == grpId && entry.mGroupType == grpType) {

                    if (serviceName != null && serviceName.length() != 0 && functionName != null && functionName.length() != 0 && data != null && data.length != 0) {
                        try {
                            ThunderNative.resolveServiceData(String.valueOf(uid), Integer.parseInt(functionName), data);
                        } catch (Exception e) {
                            ThunderLog.error(ThunderLog.kLogTagCall, "onBroadCast exception %s", e.toString());
                        }
                    }
                    break;
                }
            }
        }
    }

    public void onSuccess(int requestId, BroadSubOrUnSubTask.ResponseParam response) {
        ThunderLog.error(ThunderLog.kLogTagCall, "ThunderServiceChannel registBroadcastListener Success mResCode =  %d", response.mResCode);
    }

    public void onFail(int requestId, int sdkResCode, int srvResCode, Exception e) {
        ThunderLog.error(ThunderLog.kLogTagCall, "ThunderServiceChannel registBroadcastListener Fail requestId = %d sdkResCode = %d srvResCode =  %d", requestId, sdkResCode, srvResCode);
    }

    private long toUnsigned(int s) {
        return s & 0xffffffffl;
    }

    private int hashString(String channelId) {
        int lHash = 0xf1e2d3c4;
        for (int i = 0; i < channelId.length(); ++i) {
            char c = channelId.charAt(i);
            lHash <<= 1;
            lHash += c;
        }
        return lHash;
    }
}
