package com.thunder.livesdk.video.serviceConfig;

import java.util.List;

/**
 * Created by Administrator on 2018/8/14.
 */

public class VideoLiveConfig {

    public int playType; //内部保存
    public int entEncode;
    public int bframeswitch;
    public int intervalSecs;    //分辨率档位变更最小间隔
    public List<ResolutionInfo> resolutions;

    public class ResolutionInfo {
        public int key; //视频清晰度（标清、高清、超清）见Level定义，对应key参数
        public int minUsers;
        public int maxUsers;
        public int isDefault; //默认开播
        public int width; //编码视频宽度
        public int height; //编码视频高度
        public int frameRate; //当前设置帧率
        public int bframeNum;

        public int encode_id; //开播编码类型
        public String encode_param; //开播编码param
        public int previewWidth; //摄像头预览宽度
        public int previewHeight; //摄像头预览高度
        public int previewFrameRate; //摄像头预览帧率
        public int codeRate; //传输使用
        public int maxrate; //开播码率上限
        public int minrate; //开播码率下限
        public int currate; // 本档位码率初始值，单位kbps
        public String description; //当前档位描述

        public int transcoding; // 转码配置key
        public List<ModifyInfo> modifyConfig;
    }

    public class ModifyInfo {
        public int width;
        public int height;
        public int maxCodeRate; // kbps
        public int minCodeRate; // kbps
        public int encode_id;
        public String encode_param;
        public int maxFrameRate;
        public int minFrameRate;
    }

    public class EncodeType {
        public static final int PHONE_CODEC_HW_H264 = 200; //h264硬编
        public static final int PHONE_CODEC_X264 = 201; //libx264软编
        public static final int PHONE_CODEC_HW_H265 = 220; //h265硬编
        public static final int PHONE_CODEC_X265 = 221; //libx265软编
    }

    public class DecodeType {
        public static final int CODEC_DECODEC_H264_HW = 1; //h264硬解
        public static final int CODEC_DECODEC_H264_SOFT = 0; //libx264软解
        public static final int CODEC_DECODEC_H265_NO = 0; //不支持265
        public static final int CODEC_DECODEC_H265_SOFT = 1; //libx265软编
        public static final int CODEC_DECODEC_H265_HW = 2; //265硬解
    }

    class PreviewType {
        public static final int PREVIEW_TYPE_SHARE_CTX = 1; //SHARE CONTEXT
        public static final int PREVIEW_TYPE_NO_SHARE_CTX = 0; //NOT SHARE CONTEXT
    }

    class UseClear {
        public static final int USE_CLEAR = 1;
        public static final int NOT_USE_CLEAR = 0;
    }

    public class StreamType {
        public static final int STREAM_TYPE_H264 = 1;   //h264
        public static final int STREAM_TYPE_H265 = 2;   //h265
    }

    public class PlayType {
        public static final int SINGLE = 0;             //单人开播
        //        public static final int LIANMAI_1st = 1;        //连麦 一麦开播
//        public static final int LIANMAI_2st = 2;        //连麦 二麦开播
        public static final int LIANMAI = 1;              //连麦
        public static final int ACROSS = 3;        //跨直播间连麦
        public static final int ARENA_CROSS = 4;        //竞技场跨频道直播
        public static final int SCREEN_CAPTURE = 5;     //手游录屏
        public static final int MULIT_LIVE = 6;        // 多人音视频房主开播
        public static final int MULIT_LIVE_LIANMAI = 7; // 多人音视频连麦开播
        public static final int ONE_TO_ONE = 8;        //一对一音视频聊天
        public static final int PLAYER_H264 = 9;    //H264硬解观看
        public static final int PLAYER_H265 = 10;   //H265观看
        public static final int BEAUTIFYLEVEL = 11;   //美颜等级
        public static final int BLACKENCODEC = 12;   //编码黑名单
        public static final int PLAYTRANSCODING = 13;   //编码黑名单
        public static final int ORIGIN_STREAM = 14;   //YUV推流
        public static final int TOTAL_TYPE = 15;       //玩法种类
        public static final int PREVIEW_SHARECTX = 16;
        public static final int USE_GLCLEAR = 17;
    }
}
