package com.thunder.livesdk.video;

import android.hardware.Camera;

import com.thunder.livesdk.ThunderRtcConstant;
import com.thunder.livesdk.helper.ThunderNative;
import com.yy.mediaframework.extra.YYSeiData;
import com.yy.mediaframework.facedetection.PreviewFrameCallback;
import com.thunder.livesdk.ThunderBridgeLib;

/*
 * camera yuv（NV21）数据回调给业务
 */

public class VideoFrameYuvCapture implements PreviewFrameCallback {

    private IVideoCaptureObserver mVideoCaptureFrameObserver = null;
    private IVideoCaptureFrameObserver mVideoCaptureFrameObserverWithClass = null;
    private static volatile VideoFrameYuvCapture instance;
    private static Object syncLock = new Object();

    public static VideoFrameYuvCapture getInstance() {
        if (instance == null) {
            synchronized (syncLock) {
                if (instance == null) {
                    instance = new VideoFrameYuvCapture();
                }
            }
        }
        return instance;
    }

    private VideoFrameYuvCapture() {
    }


    public int enableVideoCapture(IVideoCaptureObserver observer) {
        if (mVideoCaptureFrameObserverWithClass != null) {
            return ThunderRtcConstant.ThunderRet.THUNDER_RET_ALREADY_EXIST;
        }
        if (observer != null) {
            mVideoCaptureFrameObserver = observer;
            ThunderBridgeLib.getInstance().addPreviewFrameCallback(this);
        } else {
            ThunderBridgeLib.getInstance().removePreviewFrameCallback(this);
            mVideoCaptureFrameObserver = null;
        }
        return ThunderRtcConstant.ThunderRet.THUNDER_RET_SUCCESS;
    }

    public int enableVideoCapture(IVideoCaptureFrameObserver observer) {
        if (mVideoCaptureFrameObserver != null) {
            return ThunderRtcConstant.ThunderRet.THUNDER_RET_ALREADY_EXIST;
        }
        if (observer != null) {
            mVideoCaptureFrameObserverWithClass = observer;
            ThunderBridgeLib.getInstance().addPreviewFrameCallback(this);
        } else {
            ThunderBridgeLib.getInstance().removePreviewFrameCallback(this);
            mVideoCaptureFrameObserverWithClass = null;
        }
        return ThunderRtcConstant.ThunderRet.THUNDER_RET_SUCCESS;
    }


    @Override
    public void onPreviewFrameAvailable(int imageFormat, byte[] data, int width, int height, Camera camera, YYSeiData seiData) {
        if (mVideoCaptureFrameObserver != null) {
            mVideoCaptureFrameObserver.onCaptureVideoFrame(width, height, data, data.length, imageFormat);
        }else if (mVideoCaptureFrameObserverWithClass != null) {
            VideoFrame frame = new VideoFrame(width,height,
                    data,imageFormat,null, seiData.cameraRotation);
            mVideoCaptureFrameObserverWithClass.onCaptureVideoFrame(frame);
            if (frame.seiData != null) {
                seiData.data = frame.seiData;
            }
        }
    }
}
