package com.thunder.livesdk.video;

import com.yy.videoplayer.VideoPlayer;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * VideoDecodeRuntimeInfo 类是用来统计视频流解码的帧率、
 * 码率、解码器类型、分辨率信息，目前仅给demo提供测试，
 * 不对外公开
 */

public class VideoDecodeRuntimeInfo {

    private static VideoDecodeRuntimeInfo mInstance;
    private Map<Long, DecodeRuntimeInfo> mDecodeRuntimeInfoMap = new ConcurrentHashMap<Long, DecodeRuntimeInfo>();

    public static VideoDecodeRuntimeInfo instance() {
        if (mInstance == null) {
            mInstance = new VideoDecodeRuntimeInfo();
        }
        return mInstance;
    }

    public void addVideoStream(long streamId, String strUid) {
        if (!mDecodeRuntimeInfoMap.containsKey(streamId)) {
            mDecodeRuntimeInfoMap.put(streamId, new DecodeRuntimeInfo(strUid));
        }
    }

    public void removeVideoStream(long streamId) {
        if (mDecodeRuntimeInfoMap.containsKey(streamId)) {
            mDecodeRuntimeInfoMap.remove(streamId);
        }
    }

    private String getDecodeTypeName(int decodeType) {
        String name = "UNKNOWN";
        switch(decodeType) {
            case 0:
                name = "DEC_TYPE_H264_HW_OFFSCREEEN";
                break;
            case 1:
                name = "DEC_TYPE_H265_HW_OFFSCREEEN";
                break;
            case 2:
                name = "DEC_TYPE_H264_SW_FFMPEG";
                break;
            case 3:
                name = "DEC_TYPE_H265_SW_ITTIAM";
                break;
            case 4:
                name = "DEC_TYPE_VP8_SW_DECVP8";
                break;
        }
        return name;
    }

    public String getDecodeRuntimeInfoString() {
        String res = "";
        Iterator entrys = mDecodeRuntimeInfoMap.entrySet().iterator();
        while (entrys.hasNext()) {
            Map.Entry entry = (Map.Entry) entrys.next();
            Long streamId = (Long)entry.getKey();
            DecodeRuntimeInfo info = (DecodeRuntimeInfo)entry.getValue();
            if (info != null) {
                info.fps = (int)VideoPlayer.getInstance().getPlayerInfo(streamId,
                        VideoPlayer.VideoPlayerInfoEnum.FRAME);
                info.bitrate = (int)VideoPlayer.getInstance().getPlayerInfo(streamId,
                        VideoPlayer.VideoPlayerInfoEnum.BITRATE)/1000;
                info.decoderType = (int)VideoPlayer.getInstance().getPlayerInfo(streamId,
                        VideoPlayer.VideoPlayerInfoEnum.DECODERTYPE);
                info.resolution = (int)VideoPlayer.getInstance().getPlayerInfo(streamId,
                        VideoPlayer.VideoPlayerInfoEnum.RESOLUTION);
                // fps = -1 的时候表示已订阅视频流，但是没开始解码
                if (info.fps == -1) {
                    continue;
                }
                int width = info.resolution >> 16;
                int height = info.resolution & 0xffff;
                res += "\r\n" + "uid: " + info.strUid + "\r\n" +
                      "fps: " + info.fps + "\r\n" +
                      "bitrate: " + info.bitrate + "kb/s \r\n" +
                      "decoderType: " + getDecodeTypeName(info.decoderType) + "\r\n" +
                      "resolution: " + width + "x" + height + "\r\n";
            }
        }
        return res;
    }

    private class DecodeRuntimeInfo {
        public String strUid;
        public int fps;
        public int bitrate;    // kbps
        public int decoderType;
        public int resolution;

        public DecodeRuntimeInfo(String strUid) {
            this.strUid = strUid;
        }
    }
}
