package com.thunder.livesdk.video;

/**
 * Created by tdx on 2020/7/29.
 */
public class ThunderPublishLowStreamVideoConfig {
  /**
   * 帧率
   */
  public int encodeFrameRate;

  /**
   * 码率
   */
  public int encodeBitrate;

  /**
   * 编码分辨率 - 宽
   */
  public int encodeResolutionWidth;

  /**
   * 编码分辨率 - 高
   */
  public int encodeResolutionHeight;
  /**
   * 小流类型(用于区分多条小流),默认为1
   */
  public int type;

  public ThunderPublishLowStreamVideoConfig() {
    this.encodeFrameRate = 0;
    this.encodeBitrate = 0;
    this.encodeResolutionHeight = 0;
    this.encodeResolutionWidth = 0;
    this.type = 1;
  }

  /**
   * 输出字符串形式的配置信息
   *
   * @return 返回字符串形式的配置信息，用于日志输出
   */
  @Override
  public String toString() {
    return "lowStream{encW=" + this.encodeResolutionWidth +
            " encH=" + this.encodeResolutionHeight +
            " fps=" + this.encodeFrameRate +
            " bitrate=" + this.encodeBitrate +
            " type=" + this.type +
            "}";
  }
}
