package com.thunder.livesdk.video;

import android.content.Context;
import android.util.AttributeSet;
import android.view.SurfaceView;
import android.widget.FrameLayout;

import com.yy.mediaframework.Constant;
import com.yy.mediaframework.UploadStreamStateParams;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.mediaframework.opengles.YMFPreviewView;
import com.yy.mediaframework.opengles.YMFPreviewCanvasView;

/**
 * Created by xiaojun on 2018/4/17.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */
public class ThunderPreviewView extends FrameLayout {
    private SurfaceView mSurfaceView;

    public ThunderPreviewView(Context context) {
        super(context);
        initData();
    }

    public ThunderPreviewView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initData();
    }

    public ThunderPreviewView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initData();
    }

    public SurfaceView getSurfaceView() {
        return mSurfaceView;
    }

    private void initData() {
        if (mSurfaceView == null) {
            if(UploadStreamStateParams.mPreviewMode == Constant.PreviewMode.GlSurfaceMode){
                mSurfaceView = new YMFPreviewView(this.getContext().getApplicationContext());
            }else if(UploadStreamStateParams.mPreviewMode == Constant.PreviewMode.CanvasMode){
                mSurfaceView = new YMFPreviewCanvasView(this.getContext().getApplicationContext());
            }else {
                mSurfaceView = new SurfaceView(this.getContext().getApplicationContext());
            }
            LayoutParams params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
            mSurfaceView.setLayoutParams(params);
            addView(mSurfaceView);
        }
    }

    public boolean checkViewType(Constant.PreviewMode mode){
        if((mode == Constant.PreviewMode.GlSurfaceMode && !(mSurfaceView instanceof YMFPreviewView))
                || (mode == Constant.PreviewMode.CanvasMode && !(mSurfaceView instanceof YMFPreviewCanvasView))
                || (mode == Constant.PreviewMode.TextureMode &&
                (mSurfaceView instanceof YMFPreviewView || mSurfaceView instanceof YMFPreviewCanvasView))){
            return true;
        }
        return false;
    }

    //必须在UI线程
    public void changeViewType(){
        this.removeAllViews();
        mSurfaceView = null;
        initData();
    }

    public void clearViews() {
        this.removeAllViews();
    }

    public void addViews(SurfaceView newView) {
        LayoutParams params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
        newView.setLayoutParams(params);
        this.addView(newView);
    }
}
