package com.thunder.livesdk.video;

import com.yy.videoplayer.VideoDecodeEventNotify;
import com.yy.videoplayer.VideoRenderNotify;

import java.util.ArrayList;

public interface IThunderVideoPlay {
    void onViewStateNotify(final long streamId, final int viewState);
    void onVideoRenderNotify(final ArrayList<VideoRenderNotify> notifys);
    void onVideoDecodeNotify(final VideoDecodeEventNotify notifys);
    void onFirstFrameRenderNotify(long streamId, int width, int height, long pts);
    void onHardwareDecodeErrorNotify(long userGroupId, long streamId, int errorType);
    void onDecodedFrameData(long streamId, int w, int h, byte[] data, int dateLen, long renderTimeMs);
    void onFirstFrameDecodeNotify(final long streamId, final long pts, final long happenTime);
}
