package com.thunder.livesdk.system;

import android.content.Context;

import com.thunder.livesdk.log.ThunderLog;
import com.thunder.livesdk.helper.ThunderNative;

/**
 * Created by xiaojun on 2018/1/12.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */

public class ThunderForeBackgroundListener implements ILifecycleCallbacks {

  private boolean mIsAppOnBackground = false;

  public ThunderForeBackgroundListener(Context context) {

  }

  public void init() {
    LifecycleEventDispatcher.registerCallback(this);
  }

  public void fini() {
    LifecycleEventDispatcher.removeCallback(this);
  }

  @Override
  public void onForeground() {
    if (mIsAppOnBackground) {
      ThunderNative.enterForeground();
      mIsAppOnBackground = false;
    }
    ThunderLog.release(ThunderLog.kLogTagSdk,
        "APP background -> foreground, isAppOnBack:%b",
        mIsAppOnBackground);
  }

  @Override
  public void onBackground() {
    if (!mIsAppOnBackground) {
      ThunderNative.enterBackground();
      mIsAppOnBackground = true;
    }
    ThunderLog.release(ThunderLog.kLogTagSdk,
        "APP foreground -> background, isAppOnBack:%b",
        mIsAppOnBackground);
  }
}
