package com.thunder.livesdk.log;

import android.content.Context;
import android.util.Log;

import com.thunder.livesdk.helper.ThunderNative;
import com.yy.mediaframework.inteligence.framerate.NewFixedFrameRateModify;

import java.util.HashSet;
import java.util.Set;

import static com.thunder.livesdk.ThunderRtcConstant.ThunderLogLevel.THUNDERLOG_LEVEL_DEBUG;
import static com.thunder.livesdk.ThunderRtcConstant.ThunderLogLevel.THUNDERLOG_LEVEL_ERROR;
import static com.thunder.livesdk.ThunderRtcConstant.ThunderLogLevel.THUNDERLOG_LEVEL_INFO;
import static com.thunder.livesdk.ThunderRtcConstant.ThunderLogLevel.THUNDERLOG_LEVEL_RELEASE;
import static com.thunder.livesdk.ThunderRtcConstant.ThunderLogLevel.THUNDERLOG_LEVEL_TRACE;
import static com.thunder.livesdk.ThunderRtcConstant.ThunderLogLevel.THUNDERLOG_LEVEL_WARN;

public class ThunderLog {
    private static volatile ThunderLog instance;
    private static Object syncLock = new Object();

    public static ThunderLog instance() {
        if (instance == null) {
            synchronized (syncLock) {
                if (instance == null) {
                    instance = new ThunderLog();
                }
            }
        }
        return instance;
    }

    public ThunderLog() {

    }

    public static final class YYLogModule {
        public static final int YYLOG_MODULE_UNKNOWN = 0;
        public static final int YYLOG_MODULE_PLATFORM = 100;
        public static final int YYLOG_MODULE_AUDIO = 101;
        public static final int YYLOG_MODULE_VIDEO = 102;
        public static final int YYLOG_MODULE_TRANS = 103;
    }

    public static final String kLogTagRtcEngine = "yrtc";
    public static final String kLogTagCall = "ycall-Java";
    public static final String kLogTagCallback = "ycallback-Java";
    public static final String kLogTagVideo = "yvideo-Java";
    public static final String kLogTagSdk = "ysdk-Java";

    private static int logLevel = THUNDERLOG_LEVEL_RELEASE;

    public static void setLogLevel(int level) {
        logLevel = level;
    }

    public static void trace(String tag, String format, Object... args) {
        logM(THUNDERLOG_LEVEL_TRACE, YYLogModule.YYLOG_MODULE_PLATFORM, tag, format, args);
    }

    public static void trace(String tag, String text) {
        logM(THUNDERLOG_LEVEL_TRACE, YYLogModule.YYLOG_MODULE_PLATFORM, tag, text);
    }

    public static void debug(String tag, String format, Object... args) {
        logM(THUNDERLOG_LEVEL_DEBUG, YYLogModule.YYLOG_MODULE_PLATFORM, tag, format, args);
    }

    public static void debug(String tag, String text) {
        logM(THUNDERLOG_LEVEL_DEBUG, YYLogModule.YYLOG_MODULE_PLATFORM, tag, text);
    }

    public static void info(String tag, String format, Object... args) {
        logM(THUNDERLOG_LEVEL_INFO, YYLogModule.YYLOG_MODULE_PLATFORM, tag, format, args);
    }

    public static void info(String tag, String text) {
        logM(THUNDERLOG_LEVEL_INFO, YYLogModule.YYLOG_MODULE_PLATFORM, tag, text);
    }

    public static void warn(String tag, String format, Object... args) {
        logM(THUNDERLOG_LEVEL_WARN, YYLogModule.YYLOG_MODULE_PLATFORM, tag, format, args);
    }

    public static void warn(String tag, String text) {
        logM(THUNDERLOG_LEVEL_WARN, YYLogModule.YYLOG_MODULE_PLATFORM, tag, text);
    }

    public static void error(String tag, String format, Object... args) {
        logM(THUNDERLOG_LEVEL_ERROR, YYLogModule.YYLOG_MODULE_PLATFORM, tag, format, args);
    }

    public static void error(String tag, String text) {
        logM(THUNDERLOG_LEVEL_ERROR, YYLogModule.YYLOG_MODULE_PLATFORM, tag, text);
    }

    public static void release(String tag, String format, Object... args) {
        logM(THUNDERLOG_LEVEL_RELEASE, YYLogModule.YYLOG_MODULE_PLATFORM, tag, format, args);
    }

    public static void release(String tag, String text) {
        logM(THUNDERLOG_LEVEL_RELEASE, YYLogModule.YYLOG_MODULE_PLATFORM, tag, text);
    }

    public static void logM(int level, int module, String tag, String text) {
        ThunderNative.logText(level, module, tag, text);
    }

    public static void logM(int level, int module, String tag, String format, Object... args) {
        if (level >= logLevel) {
            String text = String.format(format, args);
            ThunderNative.logText(level, module, tag, text);
        }
    }

    public static boolean isInfoValid()
    { 
        return logLevel <= THUNDERLOG_LEVEL_INFO; 
    }

    public static boolean isWarnValid()
    {
        return logLevel <= THUNDERLOG_LEVEL_WARN;
    }

    public static boolean isErrorValid()
    {
        return logLevel <= THUNDERLOG_LEVEL_ERROR;
    }

    public void enableConsoleLogger(boolean bEnable)
    {
        // TODO: 要实现
        Log.v("TLog", "enableConsoleLogger, bEnable " + bEnable);
    }
}
