package com.thunder.livesdk.helper;

/**
 * Created by xiaojun on 2017/11/22.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */

public class HPMarshaller extends Marshallable {
    public IMshBuffer mMshBuffer = null;

    public HPMarshaller() {
        super(false);
    }

    /**
     * 此基类的子类的marshall操作都使用HPmarshall函数, buffer内存作为参数传进来
     * 如果直接使用marshall参数, 则会 产生崩溃.
     */
    public byte[] HPmarshall(IMshBuffer buffer) {
        mMshBuffer = buffer;
        mBuffer = mMshBuffer.getByteBuffer();
        return marshall();
    }

    public void pushMarshallable(IMshBuffer buffer) {
        mMshBuffer = buffer;
        mBuffer = mMshBuffer.getByteBuffer();
        marshall(mBuffer);
    }

    public void popMarshallable(IMshBuffer buffer) {
        mMshBuffer = buffer;
        mBuffer = mMshBuffer.getByteBuffer();
        unmarshall(mBuffer);
    }

    public IMshBuffer getMshBuffer() {
        return mMshBuffer;
    }

    @Override
    protected void increase_capacity(int minIncrement) {
        mMshBuffer.increase_capacity(minIncrement);
        mBuffer = mMshBuffer.getByteBuffer();
    }
}