package com.thunder.livesdk;

/**
 * @brief 文字水印
 */
public class TranscodingText {
    public int x; // 以左上角为原点横轴坐标,默认0
    public int y; // 以左上角为原点纵轴坐标,默认0
    public String content; // 文字内容,默认空值
    public String font; // 字体,目前仅支持NotoSansCJK一种字体,默认空值
    public int size; // 字体大小,默认0
    public int color; // 字体颜色,RGB定义下的Hex值,默认值黑色#000000
    public int backgroundColor; // 背景色,RGB定义下的Hex值,默认值-1表示不设置背景色
    public float alpha; // 透明度,取值范围为[0.0, 1.0],0.0完全透明,1.0完全不透明,默认1.0

    public TranscodingText() {
      this.x = 0;
      this.y = 0;
      this.content = "";
      this.font = "";
      this.size = 0;
      this.color = 0;
      this.backgroundColor = -1;
      this.alpha = 1.0f;
    }

    public String toString() {
      return "[TranscodingText: x" + x + ", y " + y + ", content " + content + ", font " + font + ", "
          + font + ", size " + size + ", color " + Integer.toHexString(color) + ", backgroundColor "
          + ((backgroundColor == -1) ? "" : Integer.toHexString(backgroundColor)) + ", alpha " + alpha + "]";
    }
}
