package com.thunder.livesdk;

public class ThunderVideoEncoderParam {

  public ThunderVideoEncoderParam() {
    this.width = 0;
    this.height = 0;
    this.frameRate = 0;
    this.bitrate = 0;
    this.minBitrate = 0;
    this.degradationStrategy = ThunderRtcConstant.ThunderDegradationStrategy.THUNDER_DEGRADATION_QUALITY;
    this.cameraOutputStrategy = ThunderRtcConstant.ThunderCameraCaptureOutputStrategy.THUNDER_CAPTURE_OUTPUT_AUTO;
  }
  public ThunderVideoEncoderParam(ThunderVideoResolution resolution, int frameRate, int bitrate, int minBitrate, int degradationStrategy, int cameraOutputStrategy) {
    this.width = resolution.width;
    this.height = resolution.height;
    this.frameRate = frameRate;
    this.bitrate = bitrate;
    this.minBitrate = minBitrate;
    this.degradationStrategy = degradationStrategy;
    this.cameraOutputStrategy = cameraOutputStrategy;
  }

  public int width; // video width
  public int height; // video height
  public int frameRate; // video frameRate
  public int bitrate; // video bitrate
  public int minBitrate; // video minimum bitrate, must not bigger than bitrate
  public int degradationStrategy; // video degradation strategy in weak network, see {@link ThunderRtcConstant.DegradationStrategy}
  public int cameraOutputStrategy; // camera capture output strategy, see {@link ThunderRtcConstant.CameraCaptureOutputStrategy}

  public String toString() {
    return "{ThunderVideoEncoderParameter width " + width + ", height " + height
        + ", frameRate " + frameRate + ", bitrate " + bitrate + ", minBitrate " + minBitrate
        + ", degradationStrategy " + degradationStrategy + ", camera cameraOutputStrategy " + cameraOutputStrategy + "}";
  }
}
