package com.thunder.livesdk;

/**
 * definition video resolution configuration under different network
 */
public class ThunderRtcVideoTransParam {
  public static final int MAXIMUM_TRANSCODING_COUNT = 5; // Support up to 5 transcoding parameter configurations
  public ThunderRtcVideoTransParam() {
    rtcVideoTransId = 0;
    width = 0;
    height = 0;
    frameRate = 0;
    bitrate = 0;
    codecType = ThunderRtcConstant.ThunderVideoCodecType.VIDEO_CODEC_UNKNOW;
    audienceMode = ThunderRtcConstant.ThunderAudienceMode.THUNDER_AUDIENCE_MODE_ORIGINAL;
  }

  public String toString() {
    return "{RtcVideoTransParam transId " + rtcVideoTransId + ", width " + width + ", height " + height
        + ", frameRate " + frameRate + ", bitrate " + bitrate + ", codecType " + codecType + "audienceMode" + audienceMode + "}";
  }

  public int rtcVideoTransId; // unique index in transcoding gears,ranges [0, 254]
  public int width;
  public int height;
  public int frameRate;
  public int bitrate;
  public int codecType; // Codec type, see {@link ThunderRtcConstant.ThunderVideoCodecType}
  public int audienceMode; // 观众网模式 see {@link ThunderRtcConstant.ThunderAudienceMode}
}
