package com.thunder.livesdk;

import com.thunder.livesdk.video.ThunderVideoLogCallback;
import com.yy.mediaframework.utils.YMFLog;

import javax.microedition.khronos.egl.EGLContext;

/**
 * Created by xiongxiong on 2017/10/30.
 */

public class ThunderPublisher {

    /**
     * 外部推音频数据的接口集
     * <br>开始采集时{@link ThunderAudioCapture#startCapture(IAudioPublisher)}会传出一个它的实现的实例。
     * 外部通过该实例调用接口向内部推送音频数据
     */
    public interface IAudioPublisher {
        /**
         * 推送原始音频数据
         *
         * @param samples 原始音频数据
         * @param cts     音频采集时间戳
         */
        void pushAudioData(byte[] samples, long cts);
    }

    public interface IVideoPublisher {

        /**
         * 推送原始视频数据
         *
         * @param data      Byte Array 型的数据数据
         * @param format    像素格式：
         *                  RGBA:  public static final int THUNDER_PIXEL_FORMAT_RGBA = 0;
         *                  I420:  public static final int THUNDER_PIXEL_FORMAT_I420 = 1;
         *                  NV21   public static final int THUNDER_PIXEL_FORMAT_NV21 = 2;
         * @param width     视频帧的宽度
         * @param height    视频帧的高度
         * @param rotation  视频帧顺时针旋转的角度。如果设置了旋转角度，媒体引擎会对图像进行旋转。
         *                  你可以根据需要将角度值设为 0 度、90 度、180 度和 270 度，如果设置为其他数字，系统会自动忽略
         * @param timestamp 传入的视频帧的时间戳。开发者必须为每一个视频帧设置一个时间戳
         */
        void pushVideoData(byte[] data, int format, int width, int height, int rotation, long timestamp);

        /**
         * 推送编码后的视频数据
         *
         * @param encodedData 编码后的视频数据（一帧）
         * @param type        编码类型
         * @param dts         当前帧编码时的系统时间，单位ms
         * @param pts         当前帧显示时的系统时间，单位ms
         */
        void pushVideoData(byte[] encodedData, ThunderConstant.ThunderVideoEncodeType type, long dts, long pts);

        /**
         * 推送原始视频数据 texture 纹理模式
         * @param textureID 视频帧所使用的 Texture ID
         * @param textureFormat 传入 texture 传入的格式
         * @param width 纹理的宽度
         * @param height 纹理的高度
         * @param rotation 旋转角度
         * @param timeStamp 传入的视频帧的时间戳，以毫秒为单位。不正确的时间戳会导致丢帧或者音视频不同步
         * @param transform 传入一个 4x4 的纹理矩阵，典型值是传入一个单位矩阵

         */
        void pushVideoTexture(int textureID, int textureFormat, int width, int height,
                              int rotation, long timeStamp,float[] transform);


        void pushVideoFrame(ThunderExternalVideoFrame frame);
    }

    private ThunderDefaultMic mDefaultMic = new ThunderDefaultMic();
    private ThunderDefaultCamera mDefaultCamera = new ThunderDefaultCamera();

    ThunderPublisher() {
        if (BuildConfig.__YY_VIDEO_SUPPORT__) {
            YMFLog.registerLogger(ThunderVideoLogCallback.sharedInstance());
        }
    }

    /**
     * 获取本地麦克风，它是YYLiveAudioCapture的子类，实现了调用麦克风采集数据
     *
     * @return 本地麦克风对象
     * @see ThunderDefaultMic
     */
    public ThunderDefaultMic getDefaluteMic() {
        if (!BuildConfig.__YY_AUDIO_SUPPORT__) {
            return null;
        }
        return mDefaultMic;
    }

    /**
     * 获取本地麦克风，它是YYLiveVideoCapture的子类，实现了调用麦克风采集数据
     *
     * @return 本地摄像头对象
     * @see ThunderDefaultCamera
     */
    public ThunderDefaultCamera getDefaluteCamera() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return null;
        }
        return mDefaultCamera;
    }
}
