package com.thunder.livesdk;

public abstract class ThunderExternalVideoSource implements ThunderCustomVideoSource {

    public static final int THUNDER_EXTERNAL_VIDEO_TYPE_BUFFER = 1; // using Raw Data buffer type
    public static final int THUNDER_EXTERNAL_VIDEO_TYPE_TEXTURE = 2; // using texture type

    /**
     * Initialize the video source
     *
     * @param consumer Get the object of interface about external video source sending {@link ThunderVideoFrameConsumer},
     * Call consumer.consumeByteArrayFrame to send the video stream from external source
     * @return
     */
    @Override
    public boolean onInitialize(ThunderVideoFrameConsumer consumer) {
        return false;
    }

    /**
     * Enable the video source
     *
     * @return
     */
    @Override
    public boolean onStart() {
        return false;
    }

    /**
     * Disable the video source
     */
    @Override
    public boolean onStop() {
        return false;
    }

    /**
     * Release the video source
     */
    @Override
    public boolean onDispose() {
        return false;
    }

    /**
     * Format of the currently pushed external video source that the SDK gets from the client, which is Raw Data buffer by default.
     * @return {@link ThunderExternalVideoSource#THUNDER_EXTERNAL_VIDEO_TYPE_BUFFER : The video is in Raw Data format}
     *         {@link ThunderExternalVideoSource#THUNDER_EXTERNAL_VIDEO_TYPE_TEXTURE : The video is in textureID format}
     */
    public int getThunderVideoBufferType()
    {
        return THUNDER_EXTERNAL_VIDEO_TYPE_BUFFER;
    }
}
