package com.thunder.livesdk;

/**
 * Receive video frames or texture frames in ByteArray type
 *
 * @member：data Data in Byte Array type
 * @member：format    Pixel format: {@link ThunderRtcConstant.ExternalVideoPixelFormat}
 *                  RGBA:  public static final int THUNDER_PIXEL_FORMAT_RGBA = 0;
 *                  I420:  public static final int THUNDER_PIXEL_FORMAT_I420 = 1;
 *                  NV21   public static final int THUNDER_PIXEL_FORMAT_NV21 = 2;
 * @member：textureID 视频帧所使用的 Texture ID
 * @member：textureFormat 传入 texture 传入的格式
 * @member：transform 传入一个 4x4 的纹理矩阵，典型值是传入一个单位矩阵
 * @member：width     Width of video frame
 * @member：height    Height of video frame
 * @member：rotation  Clockwise rotation angle of video frame If rotation angle is defined, media engine will rotate image.
 *                 You may set angle value to 0, 90, 180 or 270 degrees as needed. If it is set to other values, the system will automatically ignore
 * @member：timestamp Timestamp of transmitted video frame Developer must set a timestamp for each video frame
 * @member：scaleMode clipMode {@link ThunderRtcConstant.ThunderVideoRenderMode}
 */
public class ThunderExternalVideoFrame {
    public byte[] data;
    public int format;
    public int textureID;
    public int textureFormat;
    public float[] transform;
    public int width;
    public int height;
    public int rotation;
    public long timeStamp;
    public int scaleMode;
}
