package com.thunder.livesdk;

public interface ThunderCustomVideoSource {

    /**
     * Initialize the video source
     *
     * @param consumer Get the object of interface about external video source sending {@link ThunderVideoFrameConsumer},
     * Call consumer.consumeByteArrayFrame to send the video stream from external source
     * @return
     */
    boolean onInitialize(ThunderVideoFrameConsumer consumer);

    /**
     * Enable the video source
     *
     * @return
     */
    boolean onStart();

    /**
     * Disable the video source
     */
    boolean onStop();

    /**
     * Release the video source
     */
    boolean onDispose();

}
