package com.thunder.livesdk;

import com.thunder.livesdk.log.ThunderLog;

import javax.microedition.khronos.egl.EGLContext;

public class ExternalVideoSource extends ThunderVideoCapture {

    ThunderCustomVideoSource mVideoSource = null;
    ThunderPublisher.IVideoPublisher mPublisher = null;
    private int mVideoBuffType = ThunderExternalVideoSource.THUNDER_EXTERNAL_VIDEO_TYPE_BUFFER; // 默认为data buffer类型

    public ExternalVideoSource(ThunderCustomVideoSource videoSource) {
        mVideoSource = videoSource;
    }

    public void setVideoBufferType(int type) {
        mVideoBuffType = type;
    }

    @Override
    public void startCapture(ThunderPublisher.IVideoPublisher proxy) {
        mPublisher = proxy;
        if (mVideoSource != null) {

            mVideoSource.onInitialize(new ThunderVideoFrameConsumer() {
                @Override
                public void consumeByteArrayFrame(byte[] data, int format, int width, int height, int rotation,
                                                  long timestamp) {
                    if (mPublisher != null) {
                        mPublisher.pushVideoData(data, format, width, height, rotation, timestamp);
                    }
                }

                @Override
                public void consumeTextureFrame(int textureID, int textureFormat, int width, int height,
                                                int rotation, long timeStamp,float[] transform) {
                    if (mPublisher != null) {
                        mPublisher.pushVideoTexture(textureID, textureFormat, width, height, rotation, timeStamp, transform);
                    }
                }

                @Override
                public void consumeVideoFrame(ThunderExternalVideoFrame frame) {
                    if (mPublisher != null) {
                        mPublisher.pushVideoFrame(frame);
                    }
                }
            });

            mVideoSource.onStart();
        } else {
if (ThunderLog.isInfoValid()) {
            ThunderLog.info(ThunderLog.kLogTagRtcEngine, "warning,  need set videoSource...");
}
        }
    }

    @Override
    public void stopCapture() {
        if (mVideoSource != null) {
            mVideoSource.onStop();
            mVideoSource.onDispose();
        } else {
if (ThunderLog.isInfoValid()) {
            ThunderLog.info(ThunderLog.kLogTagRtcEngine, "warning,  need set videoSource...");
}
        }
    }

    @Override
    public ThunderVideoCaptureConfig getCaptureConfig() {
        return null;
    }

    public int getExternalVideoBuffType() {
        return mVideoBuffType;
    }
}
