package com.thunder.livesdk;

public class CustomTranscodingOptions {
    public int videoCodecType = 0; // Encoding type: H264 or H265
    public int videoBitrate = 0; // Video bitrate (required for video streams), range: (0,10000], unit: kbps
    public int videoFps = 0; // Video frame rate (required for video streams)，range: (0,60]
    public int videoGop = 0; // Video GOP in frames (required for video streams), which is a multiple of fps (If the set value does not meet this condition, gop will be rounded up to the next multiple of fps); range: (0,200], unit: fps
    public int videoHeight = 0; //  Video height (required for video streams), which should be mutiples of 4, range: (0,1920]
    public int videoWidth = 0;  // Video width (required for video streams), which should be mutiples of 4, range: (0,1920]
    public int audioCodecType = 0; // Audio encoding type：AAC / eAAC+，default value:0
    public int audioSample = 41000; // Audio sampling rate：32kHz/44.1kHz / 48kHz，default value:44.1kHz
    public int audioBitrate = 64; // Audio bit rate：default value：64kbps，range: [24，192]
    public int audioChannel = 2; // Audio channel：range: [1,2]，1 - mono channel, 2 - stereo,default value:2,Audio in EAAC + format does not support mono channel
}
