#pragma once

#define SCLOG_MACRO(flg, mod, tg, fnct, frmt, ...)				\
		do {sclog_do(flg, mod, tg, __FILE__, fnct, __LINE__, frmt, ##__VA_ARGS__);} while(0)

#define SCLOG_MAYBE(lvl, flg, mod, tag, fnct, frmt, ...)		\
		do { if(lvl & flg) SCLOG_MACRO(flg, mod, tag, fnct, frmt, ##__VA_ARGS__); } while(0)

#define SCLOG_MODULE_LOG_LEVEL(mod)								\
		(SpiderCrab::SCLogLevelVerbose)

#define SCLogModuelErrorTag(mod, tag, fnct, frmt, ...)			\
	SCLOG_MAYBE(SCLOG_MODULE_LOG_LEVEL(mod), SpiderCrab::SCLogFlagError, mod, tag, fnct, frmt, ##__VA_ARGS__)
#define SCLogModuelWarnTag(mod, tag, fnct, frmt, ...)			\
	SCLOG_MAYBE(SCLOG_MODULE_LOG_LEVEL(mod), SpiderCrab::SCLogFlagWarning, mod, tag, fnct, frmt, ##__VA_ARGS__)
#define SCLogModuelInfoTag(mod, tag, fnct, frmt, ...)			\
	SCLOG_MAYBE(SCLOG_MODULE_LOG_LEVEL(mod), SpiderCrab::SCLogFlagInfo, mod, tag, fnct, frmt, ##__VA_ARGS__)
#define SCLogModuelDebugTag(mod, tag, fnct, frmt, ...)			\
	SCLOG_MAYBE(SCLOG_MODULE_LOG_LEVEL(mod), SpiderCrab::SCLogFlagDebug, mod, tag, fnct, frmt, ##__VA_ARGS__)
#define SCLogModuelVerboseTag(mod, tag, fnct, frmt, ...)		\
	SCLOG_MAYBE(SCLOG_MODULE_LOG_LEVEL(mod), SpiderCrab::SCLogFlagVerbose, mod, tag, fnct, frmt, ##__VA_ARGS__)

#define SCLogModuelErrorTagTrace(mod, frmt, ...)	SCLogModuelErrorTag		(mod, NULL, __FUNCTION__, frmt, ##__VA_ARGS__)
#define SCLogModuelWarnTagTrace(mod, frmt, ...)		SCLogModuelWarnTag		(mod, NULL, __FUNCTION__, frmt, ##__VA_ARGS__)
#define SCLogModuelInfoTagTrace(mod, frmt, ...)		SCLogModuelInfoTag		(mod, NULL, __FUNCTION__, frmt, ##__VA_ARGS__)
#define SCLogModuelDebugTagTrace(mod, frmt, ...)	SCLogModuelDebugTag		(mod, NULL, __FUNCTION__, frmt, ##__VA_ARGS__)
#define SCLogModuelVerboseTagTrace(mod, frmt, ...)	SCLogModuelVerboseTag(mod, NULL, __FUNCTION__, frmt, ##__VA_ARGS__)

#define SCLogModuelError(mod, frmt, ...)			SCLogModuelErrorTag		(mod, NULL, "", frmt, ##__VA_ARGS__)
#define SCLogModuelWarn(mod, frmt, ...)				SCLogModuelWarnTag		(mod, NULL, "", frmt, ##__VA_ARGS__)
#define SCLogModuelInfo(mod, frmt, ...)				SCLogModuelInfoTag		(mod, NULL, "", frmt, ##__VA_ARGS__)
#define SCLogModuelDebug(mod, frmt, ...)			SCLogModuelDebugTag		(mod, NULL, "", frmt, ##__VA_ARGS__)
#define SCLogModuelVerbose(mod, frmt, ...)			SCLogModuelVerboseTag	(mod, NULL, "", frmt, ##__VA_ARGS__)

#define SCLogErrorTag(tag, frmt, ...)				SCLogModuelErrorTag		(NULL, tag, "", frmt, ##__VA_ARGS__)
#define SCLogWarnTag(tag, frmt, ...)				SCLogModuelWarnTag		(NULL, tag, "", frmt, ##__VA_ARGS__)
#define SCLogInfoTag(tag, frmt, ...)				SCLogModuelInfoTag		(NULL, tag, "", frmt, ##__VA_ARGS__)
#define SCLogDebugTag(tag, frmt, ...)				SCLogModuelDebugTag		(NULL, tag, "", frmt, ##__VA_ARGS__)
#define SCLogVerboseTag(tag, frmt, ...)				SCLogModuelVerboseTag(NULL, tag, "", frmt, ##__VA_ARGS__)

#define SCLogError(frmt, ...)						SCLogErrorTag	(NULL, frmt, ##__VA_ARGS__)
#define SCLogWarn(frmt, ...)						SCLogWarnTag	(NULL, frmt, ##__VA_ARGS__)
#define SCLogInfo(frmt, ...)						SCLogInfoTag	(NULL, frmt, ##__VA_ARGS__)
#define SCLogDebug(frmt, ...)						SCLogDebugTag	(NULL, frmt, ##__VA_ARGS__)
#define SCLogVerbose(frmt, ...)						SCLogVerboseTag	(NULL, frmt, ##__VA_ARGS__)

