/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.effect;

import com.yy.appbase.account.AccountUtil;
import com.yy.base.event.kvo.KvoFieldAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroadcastInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftComboInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.SendGiftExpand;
import com.yy.hiyo.wallet.gift.effect.a;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;

public class GiftEffectInfo
extends KvoSource {
    private static final String TAG = "FTGiftEffectInfo";
    private static final long COMBO_INTERVAL = 500L;
    private GiftBroadcastInfo giftBroInfo;
    private GiftComboInfo giftComboInfo;
    final Queue<GiftComboInfo> giftComboInfoQueue = new PriorityBlockingQueue<GiftComboInfo>();
    GiftItemInfo giftInfo;
    SendGiftExpand expand;
    int level;
    public static final String kvo_state = "state";
    @KvoFieldAnnotation(name="state")
    private int state = -1;
    private int lastState = -1;
    public static final String kvo_everyEffectFinish = "everyEffectFinish";
    @KvoFieldAnnotation(name="everyEffectFinish")
    private int everyEffectFinish;
    private long lastComboStamp;
    private int lastHit = 0;
    private boolean isStop = false;
    private Runnable mNextTask = new a(this);

    public void setGiftBroInfo(GiftBroadcastInfo giftBroadcastInfo) {
        this.giftBroInfo = giftBroadcastInfo;
        this.lastComboStamp = System.currentTimeMillis();
        YYTaskExecutor.removeTask((Runnable)this.mNextTask);
        YYTaskExecutor.postToMainThread((Runnable)this.mNextTask, (long)500L);
    }

    public void setGiftComboInfo(GiftComboInfo giftComboInfo) {
        this.giftComboInfo = giftComboInfo;
        this.lastComboStamp = System.currentTimeMillis();
        if (giftComboInfo.getComboHits() % 7 == 0) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"setGiftComboInfo report play effect finish every 7 combo", (Object[])new Object[0]);
            }
            this.playOnceEffectFinish(this.level);
        }
    }

    void updateGiftBroInfo(GiftBroadcastInfo giftBroadcastInfo) {
        this.giftBroInfo = giftBroadcastInfo;
    }

    public void finish(GiftBroadcastInfo giftBroadcastInfo, int n2) {
        boolean bl = this.isSameBro(giftBroadcastInfo);
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"finish should Show: %s, this.state: %s, effect: %s, isSame: %b, combo size: %d, finish bro: %s, cur bro: %s", (Object[])new Object[]{this.needShow(n2), Integer.toBinaryString(this.state), Integer.toBinaryString(n2), bl, this.giftComboInfoQueue.size(), giftBroadcastInfo, this.giftBroInfo});
        }
        if (!bl) {
            return;
        }
        this.lastState = this.state | n2;
        if (!this.giftComboInfoQueue.isEmpty()) {
            this.nextCombo();
            return;
        }
        int n3 = this.lastState;
        this.setState(n3);
    }

    private boolean isSameBro(GiftBroadcastInfo giftBroadcastInfo) {
        return giftBroadcastInfo != null && this.giftBroInfo != null && giftBroadcastInfo.equals((Object)this.giftBroInfo);
    }

    public boolean isFinish(int n2) {
        return (this.state & n2) == n2 || !this.needShow(n2);
    }

    public void setState(int n2) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"setState this.state: %s, state: %s, level: %s", (Object[])new Object[]{Integer.toBinaryString(this.state), Integer.toBinaryString(n2), Integer.toBinaryString(this.level)});
        }
        this.notifyKvoEvent(kvo_state);
    }

    private void setEffectFinish(int n2) {
        this.notifyKvoEvent(kvo_everyEffectFinish);
    }

    public void playOnceEffectFinish(int n2) {
        int n3 = this.everyEffectFinish + 1;
        this.setEffectFinish(n3);
    }

    public void reset() {
        YYTaskExecutor.removeTask((Runnable)this.mNextTask);
        this.state = -1;
        this.lastState = -1;
        this.everyEffectFinish = 0;
        this.lastHit = 0;
        this.lastComboStamp = 0L;
        this.giftComboInfoQueue.clear();
        this.giftBroInfo = null;
        this.giftComboInfo = null;
        this.giftInfo = null;
        this.expand = null;
    }

    void start() {
        this.isStop = false;
        this.state = 0;
        this.lastState = 0;
    }

    void stop() {
        this.isStop = true;
        this.giftComboInfoQueue.clear();
        this.state = this.lastState;
    }

    public boolean isStop() {
        return this.isStop;
    }

    public void setGiftComboInfoQueue(Queue<GiftComboInfo> queue, boolean bl) {
        MLog.info((Object)TAG, (String)"setGiftComboInfoQueue size: %d, cur size: %d", (Object[])new Object[]{FP.size(queue), this.giftComboInfoQueue.size()});
        if (!FP.empty(queue)) {
            for (GiftComboInfo giftComboInfo : queue) {
                this.addCombo(giftComboInfo, bl);
            }
        }
    }

    void addCombo(GiftComboInfo giftComboInfo, boolean bl) {
        MLog.info((Object)TAG, (String)"addCombo giftComboInfoQueue.size: %d, comboInfo: %s, cur combo: %s", (Object[])new Object[]{this.giftComboInfoQueue.size(), giftComboInfo, this.giftComboInfo});
        if (giftComboInfo == null || giftComboInfo.getComboHits() == 1) {
            return;
        }
        this.lastHit = giftComboInfo.getComboHits();
        this.giftComboInfoQueue.offer(giftComboInfo);
        if (bl) {
            YYTaskExecutor.removeTask((Runnable)this.mNextTask);
            long l2 = System.currentTimeMillis();
            long l3 = 500L - Math.abs(this.lastComboStamp - l2);
            long l4 = l3 = l3 < 0L ? 0L : l3;
            if (l3 <= 0L) {
                this.nextCombo();
            } else {
                YYTaskExecutor.postToMainThread((Runnable)this.mNextTask, (long)l3);
            }
        }
    }

    boolean isMyself() {
        if (this.giftBroInfo != null) {
            return this.giftBroInfo.getUid() == AccountUtil.getUid();
        }
        return false;
    }

    private void nextCombo() {
        if (this.giftComboInfoQueue.isEmpty()) {
            return;
        }
        if (this.state == -1) {
            MLog.error((Object)TAG, (String)"nextCombo queue is not empty, but state is not invalid", (Object[])new Object[0]);
            this.giftComboInfoQueue.clear();
            return;
        }
        YYTaskExecutor.removeTask((Runnable)this.mNextTask);
        long l2 = System.currentTimeMillis();
        long l3 = 500L - Math.abs(this.lastComboStamp - l2);
        long l4 = l3 = l3 < 0L ? 0L : l3;
        if (l3 > 100L) {
            YYTaskExecutor.postToMainThread((Runnable)this.mNextTask, (long)l3);
            return;
        }
        GiftComboInfo giftComboInfo = this.giftComboInfoQueue.poll();
        MLog.info((Object)TAG, (String)"nextCombo cur: %s, next: %s", (Object[])new Object[]{this.giftComboInfo, giftComboInfo});
        if (giftComboInfo.getComboHits() != 1) {
            this.setGiftComboInfo(giftComboInfo);
            YYTaskExecutor.postToMainThread((Runnable)this.mNextTask, (long)500L);
        } else {
            this.nextCombo();
        }
    }

    public boolean needShow(int n2) {
        return this.state != -1 && (n2 & this.level) == n2;
    }

    public boolean isIdle() {
        return this.state == -1 || this.state == this.level;
    }

    public GiftBroadcastInfo getGiftBroInfo() {
        return this.giftBroInfo;
    }

    public GiftComboInfo getGiftComboInfo() {
        return this.giftComboInfo;
    }

    public GiftItemInfo getGiftInfo() {
        return this.giftInfo;
    }

    public SendGiftExpand getExpand() {
        return this.expand;
    }

    public String toString() {
        return "GiftEffectInfo{giftName=" + (this.giftInfo == null ? "" : this.giftInfo.getName()) + ", level=0b" + Integer.toBinaryString(this.level) + ", state=0b" + Integer.toBinaryString(this.state) + ", giftComboInfoQueue.size=" + this.giftComboInfoQueue.size() + ", hit=" + (this.giftComboInfo == null ? "" : Integer.valueOf(this.giftComboInfo.getComboHits())) + ", isFinish=" + (this.giftComboInfo == null ? "" : Boolean.valueOf(this.giftComboInfo.getIsFinishCombo())) + ", giftBroInfo=" + this.giftBroInfo + '}';
    }

    static /* synthetic */ void access$000(GiftEffectInfo giftEffectInfo) {
        giftEffectInfo.nextCombo();
    }
}

