/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.sticker;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.VersionUtil;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.hiyo.sticker.IStickerService;
import com.yy.hiyo.sticker.IStickerUnzipListener;
import com.yy.hiyo.sticker.StickerData;
import com.yy.hiyo.sticker.StickerDataListener;
import com.yy.hiyo.sticker.StickerDownLoadListener;
import com.yy.hiyo.sticker.StickerDownLoadManager;
import com.yy.hiyo.videorecord.IVideoPlayService;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.ihago.money.api.mask.ExpressionClassify;
import net.ihago.money.api.mask.GetMasksReq;
import net.ihago.money.api.mask.GetMasksRes;
import net.ihago.money.api.mask.MaskGroupInfo;
import net.ihago.money.api.mask.MaskIconInfo;

public class StickerService
implements IStickerService {
    private static final String TAG = "StickerService";
    private IQueueTaskExecutor mIQueueTaskExecutor = YYTaskExecutor.createAQueueExcuter();
    private List<StickerData> mStickerDataList = new ArrayList<StickerData>();
    private List<StickerData> mBeautyDataList = new ArrayList<StickerData>();
    private StickerDownLoadManager mStickerDownLoadManager = new StickerDownLoadManager();

    public String isStickerDownLoad(int maskId) {
        return this.mStickerDownLoadManager.isResourceExists(maskId);
    }

    public void getPathByMaskId(int maskId, StickerDownLoadListener loadListener) {
        StickerData stickerData = this.getStickerData(maskId);
        this.getPath(stickerData, loadListener, ".ofeffect");
    }

    public void getPathByZip(String zipPath, IStickerUnzipListener listener) {
        try {
            this.mIQueueTaskExecutor.execute(() -> {
                String[] files;
                boolean isZipSuccess;
                File file = new File(zipPath);
                String targetPath = this.getZipTargetPath() + File.separator + YYFileUtils.getFileNameNoEx((String)file.getName());
                File targetFile = new File(targetPath);
                if (!targetFile.exists() && !(isZipSuccess = YYFileUtils.unZip((String)zipPath, (String)targetPath))) {
                    YYFileUtils.removeDir((String)targetPath);
                    YYTaskExecutor.postToMainThread(() -> ((IStickerUnzipListener)listener).fali());
                    return;
                }
                String targetZipPath = null;
                for (String s : files = new File(targetPath).list()) {
                    if (!".ofeffect".equals(YYFileUtils.getFileExtension((String)s))) continue;
                    targetZipPath = targetPath + File.separator + s;
                }
                String finalTargetZipPath = targetZipPath;
                YYTaskExecutor.postToMainThread(() -> {
                    if (!TextUtils.isEmpty((CharSequence)finalTargetZipPath)) {
                        listener.success(finalTargetZipPath);
                    } else {
                        listener.fali();
                    }
                });
            }, 0L);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            listener.fali();
        }
    }

    public boolean isStickerNeedUpdate(int maskId) {
        StickerData stickerData = this.getStickerData(maskId);
        if (stickerData != null) {
            this.mStickerDownLoadManager.isDownedNeedUpdate(maskId, stickerData.getMd5());
        }
        return false;
    }

    public void requestStickerData(final StickerDataListener listener) {
        if (!this.mStickerDataList.isEmpty()) {
            listener.success(this.mStickerDataList);
        } else {
            this.mStickerDownLoadManager.readLocalLoaded(() -> this.requestStickerData(new OvaDataListener(){

                @Override
                public void success(List<StickerData> stickerData) {
                    StickerService.this.mStickerDataList = stickerData;
                    listener.success(stickerData);
                }

                @Override
                public void fail(int code) {
                    listener.fail(code);
                }
            }, this.getTextureSupport(), 4));
        }
    }

    public void requestBeautyFilterData(final StickerDataListener listener) {
        if (!this.mBeautyDataList.isEmpty()) {
            listener.success(this.mBeautyDataList);
        } else {
            this.mStickerDownLoadManager.readLocalLoaded(() -> this.requestStickerData(new OvaDataListener(){

                @Override
                public void success(List<StickerData> stickerData) {
                    StickerService.this.mBeautyDataList = stickerData;
                    listener.success(stickerData);
                }

                @Override
                public void fail(int code) {
                    listener.fail(code);
                }
            }, this.getTextureSupport(), 1));
        }
    }

    public void getBeautyPathByMaskId(int maskId, StickerDownLoadListener loadListener) {
        StickerData stickerData = this.getBeautyData(maskId);
        this.getPath(stickerData, loadListener, ".ofeffect");
    }

    private void getPath(StickerData stickerData, StickerDownLoadListener loadListener, String extensionName) {
        if (stickerData != null) {
            int maskId = stickerData.getId();
            String downLoadPath = this.isStickerDownLoad(maskId);
            if (!TextUtils.isEmpty((CharSequence)downLoadPath) && !this.mStickerDownLoadManager.isDownedNeedUpdate(maskId, stickerData.getMd5())) {
                loadListener.success(downLoadPath);
            } else {
                this.mStickerDownLoadManager.downloadSticker(stickerData, loadListener, extensionName);
            }
        } else {
            loadListener.fail();
        }
    }

    private String getTextureSupport() {
        return ((IVideoPlayService)ServiceManagerProxy.getInstance().getService(IVideoPlayService.class)).getTextureSupport();
    }

    private StickerData getStickerData(int maskId) {
        for (StickerData data : this.mStickerDataList) {
            if (data.getId() != maskId) continue;
            return data;
        }
        return null;
    }

    private StickerData getBeautyData(int maskId) {
        for (StickerData data : this.mBeautyDataList) {
            if (data.getId() != maskId) continue;
            return data;
        }
        return null;
    }

    public void requestStickerData(final OvaDataListener listener, String textureSupport, final int type) {
        GetMasksReq.Builder builder = new GetMasksReq.Builder().sequence(Long.valueOf(System.currentTimeMillis())).request_version("1").type(Integer.valueOf(type)).uid(Long.valueOf(AccountUtil.getUid())).texture_support(textureSupport).version(VersionUtil.getLocalVer((Context)RuntimeContext.sApplicationContext).getVersionNameWithoutSnapshot()).os("2").machine(Build.MANUFACTURER + " " + Build.MODEL).model(Build.MANUFACTURER + " " + Build.MODEL).classify(Integer.valueOf(ExpressionClassify.ClassifyGame.getValue()));
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"requestStickerData %s", (Object[])new Object[]{type});
        }
        ProtoManager.getInstance().sendRpc((AndroidMessage)builder.build(), (IProtoCallback)new SimpleProtoCallback<GetMasksRes>(){

            public void onResponse(@NonNull GetMasksRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (listener != null) {
                    YYTaskExecutor.execute(() -> {
                        List data = StickerService.this.parseData(message);
                        YYTaskExecutor.postToMainThread(() -> listener.success(data));
                    });
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                MLog.error((Object)StickerService.TAG, (String)"requestStickerData %s Failed! Code:%d, Reason:%s", (Object[])new Object[]{type, code, reason});
                if (listener != null) {
                    listener.fail(code);
                }
            }
        });
    }

    private List<StickerData> parseData(GetMasksRes masksRes) {
        ArrayList<StickerData> dataList = new ArrayList<StickerData>();
        List groupInfos = masksRes.infos;
        if (groupInfos != null && !groupInfos.isEmpty()) {
            for (MaskGroupInfo groupInfo : groupInfos) {
                List maskIconInfos = groupInfo.icons;
                if (maskIconInfos == null || maskIconInfos.isEmpty()) continue;
                for (MaskIconInfo iconInfo : maskIconInfos) {
                    StickerData stickerData = new StickerData();
                    stickerData.setId(iconInfo.id.intValue());
                    stickerData.setMd5(iconInfo.md5);
                    stickerData.setName(iconInfo.name);
                    stickerData.setOperationType(iconInfo.operation_type);
                    stickerData.setTip(iconInfo.tip);
                    stickerData.setUrl(iconInfo.url);
                    stickerData.setThumb(iconInfo.thumb);
                    stickerData.setExpendJson(iconInfo.expand_json);
                    dataList.add(stickerData);
                }
            }
        }
        return dataList;
    }

    private String getZipTargetPath() {
        return FileStorageUtils.getInstance().getDir("mask" + File.separator + ".zip", true, false, false, 0).getAbsolutePath();
    }

    static interface OvaDataListener {
        public void success(List<StickerData> var1);

        public void fail(int var1);
    }
}

