/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.sticker;

import android.content.Context;
import android.text.TextUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.sticker.StickerData;
import com.yy.hiyo.sticker.StickerDownLoadListener;
import downloader.Downloader;
import downloader.IDownloadCallback;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StickerDownLoadManager {
    private static final String TAG = "StickerDownLoadManager";
    private List<StickerData> loaded = new ArrayList<StickerData>();
    private List<StickerData> loading = new ArrayList<StickerData>();
    private boolean isReadLocal;

    public synchronized void downloadSticker(final StickerData stickerData, StickerDownLoadListener loadListener, final String extensionName) {
        final InnerStickerDownLoadListener innerStickerDownLoadListener = new InnerStickerDownLoadListener(stickerData);
        innerStickerDownLoadListener.outListener = loadListener;
        if (this.loading.contains(stickerData)) {
            innerStickerDownLoadListener.onDownloading();
            if (RuntimeContext.sIsDebuggable) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"current loading", (int)1);
            }
            return;
        }
        this.loading.add(stickerData);
        stickerData.setDownloadStatus(1);
        Downloader.Builder builder = new Downloader.Builder(stickerData.getUrl(), this.getStickerTempPath(stickerData.getId()), stickerData.getId() + "");
        Downloader downloader = builder.build();
        downloader.setCallBack(new IDownloadCallback(){

            public void onComplete(Downloader downloader) {
                MLog.error((Object)StickerDownLoadManager.TAG, (String)downloader.getFilePath(), (Object[])new Object[0]);
                StickerDownLoadManager.this.operatorDownLoadPath(downloader.getFilePath(), stickerData, innerStickerDownLoadListener, extensionName);
                StickerDownLoadManager.this.loading.remove(stickerData);
            }

            public void onError(Downloader downloader, int errorType, String errorInfo) {
                StickerDownLoadManager.this.loading.remove(stickerData);
                innerStickerDownLoadListener.fail();
            }

            public void onProgressChange(Downloader downloader, long totalSize, long curSize) {
                MLog.error((Object)StickerDownLoadManager.TAG, (String)("totalSize:" + totalSize + "curSize" + curSize), (Object[])new Object[0]);
            }

            public void onStart(Downloader downloader) {
            }
        });
        downloader.start();
    }

    public String isResourceExists(int maskId) {
        StickerData stickerDown = this.getStickerDown(maskId);
        return stickerDown != null ? stickerDown.getResourcePath() : null;
    }

    public boolean isDownedNeedUpdate(int maskId, String md5) {
        StickerData stickerDown = this.getStickerDown(maskId);
        return stickerDown != null && !stickerDown.getMd5().equals(md5);
    }

    private StickerData getStickerDown(int maskId) {
        for (StickerData data : this.loaded) {
            if (data.getId() != maskId || !new File(data.getResourcePath()).exists()) continue;
            return data;
        }
        return null;
    }

    private void operatorDownLoadPath(String downloadPath, StickerData stickerData, StickerDownLoadListener loadListener, String extensionName) {
        YYTaskExecutor.execute(() -> {
            try {
                String tempPath = downloadPath.substring(0, downloadPath.lastIndexOf(File.separator)) + File.separator + "temp";
                YYFileUtils.unZip((String)downloadPath, (String)tempPath);
                File file = new File(tempPath);
                Object[] list = file.list();
                String targetPath = null;
                MLog.error((Object)TAG, (String)Arrays.toString(list), (Object[])new Object[0]);
                if (list != null && list.length != 0) {
                    for (Object s : list) {
                        if (!extensionName.equals(YYFileUtils.getFileExtension((String)s))) continue;
                        targetPath = tempPath + File.separator + (String)s;
                        break;
                    }
                }
                String finalTargetPath = targetPath;
                YYTaskExecutor.postToMainThread(() -> {
                    if (!TextUtils.isEmpty((CharSequence)finalTargetPath)) {
                        stickerData.setResourcePath(finalTargetPath);
                        this.loaded.add(stickerData);
                        this.updateLocalLoaded();
                        loadListener.success(finalTargetPath);
                    } else {
                        loadListener.fail();
                    }
                });
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        });
    }

    private void updateLocalLoaded() {
        YYTaskExecutor.execute(() -> {
            try {
                YYFileUtils.writeBytesToFile((File)FileUtils.createNewFile((String)this.getStickerLoadedPath()), (byte[])JsonParser.toJson(this.loaded).getBytes(), (boolean)false);
            }
            catch (IOException e) {
                MLog.error((Object)TAG, (String)"writeBytesToFile Failed", (Throwable)e, (Object[])new Object[0]);
            }
        });
    }

    public void readLocalLoaded(ReadLocalStickerDataListener localStickerDataListener) {
        if (this.isReadLocal) {
            localStickerDataListener.already();
            return;
        }
        YYTaskExecutor.execute(() -> {
            try {
                this.isReadLocal = true;
                byte[] bytes = YYFileUtils.readBytes((String)this.getStickerLoadedPath());
                String loadedStr = StringUtils.byteToStringUtf8((byte[])bytes);
                MLog.debug((Object)TAG, (String)"readLocalloadedStr=%s", (Object[])new Object[]{loadedStr});
                List data = JsonParser.parseJsonList((String)loadedStr, StickerData.class);
                this.loaded.addAll(data);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"readLocalLoaded=%s", (Object[])new Object[]{data.size()});
                }
                YYTaskExecutor.postToMainThread(localStickerDataListener::already);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"readLocalLoaded Failed", (Throwable)e, (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread(localStickerDataListener::already);
            }
        });
    }

    private String getStickerLoadedPath() {
        File loadedFile = new File(RuntimeContext.sApplicationContext.getCacheDir(), "mask");
        if (!loadedFile.exists() && loadedFile.mkdirs() && RuntimeContext.sIsDebuggable) {
            MLog.error((Object)TAG, (String)"mkdirs error %s", (Object[])new Object[]{loadedFile});
        }
        return loadedFile.getAbsolutePath() + File.separator + "maskloaded";
    }

    private String getStickerTempPath(int maskId) {
        return this.getStickerPath("temp") + File.separator + maskId;
    }

    private String getStickerPath(String pathName) {
        return FileStorageUtils.getInstance().getDir("mask" + File.separator + pathName, true, false, false, 0).getAbsolutePath();
    }

    static interface ReadLocalStickerDataListener {
        public void already();
    }

    class InnerStickerDownLoadListener
    implements StickerDownLoadListener {
        StickerDownLoadListener outListener;
        StickerData stickerData;

        public InnerStickerDownLoadListener(StickerData stickerData) {
            this.stickerData = stickerData;
        }

        public void fail() {
            if (this.outListener != null) {
                this.outListener.fail();
            }
            this.stickerData.setDownloadStatus(0);
        }

        public void success(String path) {
            if (this.outListener != null) {
                this.outListener.success(path);
            }
            this.stickerData.setDownloadStatus(0);
        }

        void onDownloading() {
            if (this.outListener != null) {
                this.outListener.fail();
            }
        }
    }
}

