/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.tools.revenue.calculator.ui;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ComposeShader;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Shader;
import android.os.Build;
import android.util.AttributeSet;
import android.view.ViewTreeObserver;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.hiyo.tools.revenue.R;

public class ShimmerLayout
extends YYFrameLayout {
    private int a;
    private Rect b;
    private Paint c;
    private ValueAnimator d;
    private Bitmap e;
    private Bitmap f;
    private Canvas g;
    private boolean h;
    private boolean i;
    private boolean j;
    private int k;
    private int l;
    private int m;
    private float n;
    private float o;
    private ViewTreeObserver.OnPreDrawListener p;
    private Animator.AnimatorListener q;

    public ShimmerLayout(Context context) {
        this(context, null);
    }

    public ShimmerLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShimmerLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.setWillNotDraw(false);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.ShimmerLayout, 0, 0);
        try {
            this.m = typedArray.getInteger(R.styleable.ShimmerLayout_shimmer_angle, 20);
            this.k = typedArray.getInteger(R.styleable.ShimmerLayout_shimmer_animation_duration, 1500);
            this.l = typedArray.getColor(R.styleable.ShimmerLayout_shimmer_color, this.a(R.color.shimmer_color));
            this.j = typedArray.getBoolean(R.styleable.ShimmerLayout_shimmer_auto_start, false);
            this.n = typedArray.getFloat(R.styleable.ShimmerLayout_shimmer_mask_width, 0.5f);
            this.o = typedArray.getFloat(R.styleable.ShimmerLayout_shimmer_gradient_center_color_width, 0.1f);
            this.h = typedArray.getBoolean(R.styleable.ShimmerLayout_shimmer_reverse_animation, false);
        }
        finally {
            typedArray.recycle();
        }
        this.setMaskWidth(this.n);
        this.setGradientCenterColorWidth(this.o);
        this.setShimmerAngle(this.m);
        this.i();
        if (this.j && this.getVisibility() == 0) {
            this.a();
        }
    }

    protected void onDetachedFromWindow() {
        this.d();
        super.onDetachedFromWindow();
    }

    protected void dispatchDraw(Canvas canvas) {
        if (!this.i || this.getWidth() <= 0 || this.getHeight() <= 0) {
            super.dispatchDraw(canvas);
        } else {
            this.a(canvas);
        }
    }

    public void setVisibility(int n) {
        super.setVisibility(n);
        if (n == 0) {
            if (this.j) {
                this.a();
            }
        } else {
            this.b();
        }
    }

    public void a() {
        if (this.i) {
            return;
        }
        if (this.getWidth() == 0) {
            this.p = new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    ShimmerLayout.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    ShimmerLayout.this.a();
                    return true;
                }
            };
            this.getViewTreeObserver().addOnPreDrawListener(this.p);
            return;
        }
        Animator animator = this.getShimmerAnimation();
        animator.start();
        this.i = true;
    }

    public void b() {
        if (this.p != null) {
            this.getViewTreeObserver().removeOnPreDrawListener(this.p);
        }
        this.d();
    }

    public void setShimmerColor(int n) {
        this.l = n;
        this.c();
    }

    public void setShimmerAnimationDuration(int n) {
        this.k = n;
        this.c();
    }

    public void setAnimationReversed(boolean bl) {
        this.h = bl;
        this.c();
    }

    public void setAnimationListener(Animator.AnimatorListener animatorListener) {
        this.q = animatorListener;
    }

    public void setShimmerAngle(int n) {
        if (n < -45 || 45 < n) {
            throw new IllegalArgumentException(String.format("shimmerAngle value must be between %d and %d", (byte)-45, (byte)45));
        }
        this.m = n;
        this.c();
    }

    public void setMaskWidth(float f2) {
        if (f2 <= 0.0f || 1.0f < f2) {
            throw new IllegalArgumentException(String.format("maskWidth value must be higher than %d and less or equal to %d", (byte)0, (byte)1));
        }
        this.n = f2;
        this.c();
    }

    public void setGradientCenterColorWidth(float f2) {
        if (f2 <= 0.0f || 1.0f <= f2) {
            throw new IllegalArgumentException(String.format("gradientCenterColorWidth value must be higher than %d and less than %d", (byte)0, (byte)1));
        }
        this.o = f2;
        this.c();
    }

    private void c() {
        if (this.i) {
            this.d();
            this.a();
        }
    }

    private void a(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.e = this.getMaskBitmap();
        if (this.e == null) {
            return;
        }
        if (this.g == null) {
            this.g = new Canvas(this.e);
        }
        this.g.drawColor(0, PorterDuff.Mode.CLEAR);
        this.g.save();
        this.g.translate((float)(-this.a), 0.0f);
        super.dispatchDraw(this.g);
        this.g.restore();
        this.b(canvas);
        this.e = null;
    }

    private void b(Canvas canvas) {
        this.f();
        canvas.save();
        canvas.translate((float)this.a, 0.0f);
        canvas.drawRect((float)this.b.left, 0.0f, (float)this.b.width(), (float)this.b.height(), this.c);
        canvas.restore();
    }

    private void d() {
        if (this.d != null) {
            this.d.end();
            this.d.removeAllUpdateListeners();
        }
        this.d = null;
        this.c = null;
        this.i = false;
        this.e();
    }

    private void e() {
        this.g = null;
        if (this.f != null) {
            this.f.recycle();
            this.f = null;
        }
    }

    private Bitmap getMaskBitmap() {
        if (this.f == null) {
            this.f = this.a(this.b.width(), this.getHeight());
        }
        return this.f;
    }

    private void f() {
        if (this.c != null) {
            return;
        }
        int n = this.b(this.l);
        float f2 = (float)(this.getWidth() / 2) * this.n;
        float f3 = 0 <= this.m ? (float)this.getHeight() : 0.0f;
        LinearGradient linearGradient = new LinearGradient(0.0f, f3, (float)Math.cos(Math.toRadians(this.m)) * f2, f3 + (float)Math.sin(Math.toRadians(this.m)) * f2, new int[]{this.a(R.color.transparent), this.l, this.l, this.a(R.color.transparent)}, this.getGradientColorDistribution(), Shader.TileMode.CLAMP);
        BitmapShader bitmapShader = new BitmapShader(this.e, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        ComposeShader composeShader = new ComposeShader((Shader)linearGradient, (Shader)bitmapShader, PorterDuff.Mode.DST_IN);
        this.c = new Paint();
        this.c.setAntiAlias(true);
        this.c.setDither(true);
        this.c.setFilterBitmap(true);
        this.c.setShader((Shader)composeShader);
    }

    private Animator getShimmerAnimation() {
        if (this.d != null) {
            return this.d;
        }
        if (this.b == null) {
            this.b = this.g();
        }
        int n = this.getWidth();
        final int n2 = this.getWidth() > this.b.width() ? -n : -this.b.width();
        final int n3 = this.b.width();
        int n4 = n - n2;
        this.d = this.h ? ValueAnimator.ofInt((int[])new int[]{n4, 0}) : ValueAnimator.ofInt((int[])new int[]{0, n4});
        this.d.setDuration((long)this.k);
        this.d.setRepeatCount(-1);
        if (this.q != null) {
            this.d.addListener(this.q);
        }
        this.d.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ShimmerLayout.this.a = n2 + (Integer)valueAnimator.getAnimatedValue();
                if (ShimmerLayout.this.a + n3 >= 0) {
                    ShimmerLayout.this.invalidate();
                }
            }
        });
        return this.d;
    }

    private Bitmap a(int n, int n2) {
        try {
            return Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ALPHA_8);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            return null;
        }
    }

    private int a(int n) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.getContext().getColor(n);
        }
        return this.getResources().getColor(n);
    }

    private int b(int n) {
        return Color.argb((int)0, (int)Color.red((int)n), (int)Color.green((int)n), (int)Color.blue((int)n));
    }

    private Rect g() {
        return new Rect(0, 0, this.h(), this.getHeight());
    }

    private int h() {
        double d2 = (double)((float)(this.getWidth() / 2) * this.n) / Math.cos(Math.toRadians(Math.abs(this.m)));
        double d3 = (double)this.getHeight() * Math.tan(Math.toRadians(Math.abs(this.m)));
        return (int)(d2 + d3);
    }

    private float[] getGradientColorDistribution() {
        float[] fArray = new float[4];
        fArray[0] = 0.0f;
        fArray[3] = 1.0f;
        fArray[1] = 0.5f - this.o / 2.0f;
        fArray[2] = 0.5f + this.o / 2.0f;
        return fArray;
    }

    private void i() {
        if (Build.VERSION.SDK_INT <= 16) {
            this.setLayerType(1, null);
        }
    }
}

