/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.sticker.display;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.transition.AutoTransition;
import androidx.transition.Transition;
import androidx.transition.TransitionManager;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.opensource.svgaplayer.utils.SVGARange;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.FP;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.channel.plugins.radio.R;
import com.yy.hiyo.channel.plugins.radio.sticker.StickerView;
import com.yy.hiyo.channel.plugins.radio.sticker.base.StickerInfo;
import com.yy.hiyo.channel.plugins.radio.sticker.callback.IApplyStickerCallback;
import com.yy.hiyo.channel.plugins.radio.sticker.callback.IStickerViewCallback;
import com.yy.hiyo.channel.plugins.radio.sticker.display.IStickerDisplayPresenter;
import com.yy.hiyo.channel.plugins.radio.sticker.display.IStickerDisplayView;
import com.yy.hiyo.channel.plugins.radio.sticker.display.StickerDisplayPresenter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\u0018\u0000 G2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001GB\u0017\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020!H\u0002J\u0018\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u000eH\u0002J\b\u0010*\u001a\u00020!H\u0002J\b\u0010+\u001a\u00020!H\u0002J\u0010\u0010,\u001a\u00020!2\u0006\u0010(\u001a\u00020\u000eH\u0002J\u0010\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u001cH\u0002J\b\u0010/\u001a\u00020\u0011H\u0002J\b\u00100\u001a\u00020\u0011H\u0016J\u001a\u00101\u001a\u00020!2\u0006\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u000105H\u0016J\u0010\u00106\u001a\u00020!2\u0006\u00102\u001a\u000203H\u0016J\u0010\u00107\u001a\u00020!2\u0006\u00102\u001a\u000203H\u0016J\u0010\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020\u0011H\u0016J\b\u0010:\u001a\u00020!H\u0002J\u0010\u0010;\u001a\u00020!2\u0006\u0010<\u001a\u00020\u0011H\u0002J\u0010\u0010=\u001a\u00020!2\u0006\u0010>\u001a\u00020\u000eH\u0002J\u0010\u0010?\u001a\u00020!2\u0006\u0010@\u001a\u00020\u000eH\u0002J\u0010\u0010A\u001a\u00020!2\u0006\u0010B\u001a\u00020CH\u0002J\u0016\u0010D\u001a\u00020!2\f\u0010E\u001a\b\u0012\u0004\u0012\u0002030FH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/sticker/display/StickerDisplayPanel;", "Lcom/yy/base/memoryrecycle/views/YYConstraintLayout;", "Lcom/yy/hiyo/channel/plugins/radio/sticker/display/IStickerDisplayView;", "Lcom/yy/hiyo/channel/plugins/radio/sticker/callback/IStickerViewCallback;", "context", "Landroid/content/Context;", "presenter", "Lcom/yy/hiyo/channel/plugins/radio/sticker/display/StickerDisplayPresenter;", "(Landroid/content/Context;Lcom/yy/hiyo/channel/plugins/radio/sticker/display/StickerDisplayPresenter;)V", "mColorAnim", "Landroid/animation/ValueAnimator;", "mConstraintSet", "Landroidx/constraintlayout/widget/ConstraintSet;", "mDeleteHeight", "", "mDeleteWidth", "mIsColorAnimating", "", "mIsScaleAnimating", "mIsTranslationInAnimating", "mIsTranslationOutAnimating", "mLastStatus", "mPresenter", "Lcom/yy/hiyo/channel/plugins/radio/sticker/display/IStickerDisplayPresenter;", "mScaleAnim", "mStickerMap", "", "", "Lcom/yy/hiyo/channel/plugins/radio/sticker/StickerView;", "mTranslationInAnim", "Landroid/animation/ObjectAnimator;", "mTranslationOutAnim", "createView", "", "getLimit", "", "getView", "Landroid/view/View;", "initAnim", "initColorAnim", "colorInit", "colorDelete", "initScaleAnim", "initTranslationInAnim", "initTranslationOutAnim", "isDeletable", "view", "isDeleteStatus", "isOwnerOrAnchor", "onContentChanged", "stickerInfo", "Lcom/yy/hiyo/channel/plugins/radio/sticker/base/StickerInfo;", "callback", "Lcom/yy/hiyo/channel/plugins/radio/sticker/callback/IApplyStickerCallback;", "onStickerMoving", "onStickerPosChanged", "onVideoModeChanged", "isVideoMode", "playDeleteSvga", "playScreenAnim", "isShow", "playTriggerSvga", "svgaMode", "setBgColor", "color", "setDeleteScale", "scale", "", "updateStickers", "stickers", "", "Companion", "radio_debug"})
public final class StickerDisplayPanel
extends YYConstraintLayout
implements IStickerDisplayView,
IStickerViewCallback {
    private IStickerDisplayPresenter mPresenter;
    private final Map<Long, StickerView> mStickerMap;
    private boolean mLastStatus;
    private boolean mIsColorAnimating;
    private boolean mIsScaleAnimating;
    private boolean mIsTranslationInAnimating;
    private boolean mIsTranslationOutAnimating;
    private final int mDeleteWidth;
    private final int mDeleteHeight;
    private ValueAnimator mColorAnim;
    private ValueAnimator mScaleAnim;
    private ObjectAnimator mTranslationInAnim;
    private ObjectAnimator mTranslationOutAnim;
    private ConstraintSet mConstraintSet;
    private static final String TAG = "Sticker_StickerDisplayPanel";
    private static final long ANIM_DURATION = 150L;
    private static final int MODE_FIRST_FRAME = 0;
    private static final int MODE_ANIM_NORMAL = 1;
    private static final int MODE_ANIM_REVERSE = 2;
    private static final String SVGA_DELETE_START = "sticker_delete_start.svga";
    private static final String SVGA_DELETE_SUCCESS = "sticker_delete_success.svga";
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    private final void createView() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_sticker_display_panel, (ViewGroup)this);
        this.initAnim();
    }

    @Override
    public boolean isOwnerOrAnchor() {
        return this.mPresenter.isOwnerOrAnchor();
    }

    @Override
    public void onVideoModeChanged(boolean isVideoMode) {
        if (!FP.empty(this.mStickerMap)) {
            for (StickerView view : this.mStickerMap.values()) {
                view.changeVideoMode(isVideoMode);
                if (isVideoMode || !this.mPresenter.isOwnerOrAnchor()) continue;
                view.resetPos();
                IStickerDisplayPresenter.DefaultImpls.handleStickerInfoChanged$default(this.mPresenter, view.getInfo(), null, 2, null);
            }
        }
    }

    private final void initAnim() {
        int colorInit = Color.parseColor((String)"#33000000");
        int colorDelete = Color.parseColor((String)"#ccff4d6f");
        this.initColorAnim(colorInit, colorDelete);
        this.initTranslationOutAnim(colorInit);
        this.initTranslationInAnim();
        this.initScaleAnim();
    }

    private final void initColorAnim(int colorInit, int colorDelete) {
        ValueAnimator valueAnimator = ValueAnimator.ofObject((TypeEvaluator)((TypeEvaluator)new ArgbEvaluator()), (Object[])new Object[]{colorInit, colorDelete});
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"ValueAnimator.ofObject(A\u2026, colorInit, colorDelete)");
        ValueAnimator valueAnimator2 = this.mColorAnim = valueAnimator;
        if (valueAnimator2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mColorAnim");
        }
        valueAnimator2.setDuration(150L);
        ValueAnimator valueAnimator3 = this.mColorAnim;
        if (valueAnimator3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mColorAnim");
        }
        valueAnimator3.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ StickerDisplayPanel this$0;

            public final void onAnimationUpdate(ValueAnimator animation) {
                ValueAnimator valueAnimator = animation;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animation");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                StickerDisplayPanel.access$setBgColor(this.this$0, (Integer)object);
            }
            {
                this.this$0 = stickerDisplayPanel;
            }
        });
        ValueAnimator valueAnimator4 = this.mColorAnim;
        if (valueAnimator4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mColorAnim");
        }
        valueAnimator4.addListener(new Animator.AnimatorListener(this){
            final /* synthetic */ StickerDisplayPanel this$0;

            public void onAnimationEnd(@Nullable Animator animation) {
                StickerDisplayPanel.access$setMIsColorAnimating$p(this.this$0, false);
            }

            public void onAnimationStart(@Nullable Animator animation) {
                StickerDisplayPanel.access$setMIsColorAnimating$p(this.this$0, true);
            }

            public void onAnimationRepeat(@Nullable Animator animation) {
            }

            public void onAnimationCancel(@Nullable Animator animation) {
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void initScaleAnim() {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 1.1f});
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"ValueAnimator.ofFloat(1f, 1.1f)");
        ValueAnimator valueAnimator2 = this.mScaleAnim = valueAnimator;
        if (valueAnimator2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mScaleAnim");
        }
        valueAnimator2.setDuration(150L);
        ValueAnimator valueAnimator3 = this.mScaleAnim;
        if (valueAnimator3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mScaleAnim");
        }
        valueAnimator3.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ StickerDisplayPanel this$0;

            public final void onAnimationUpdate(ValueAnimator animation) {
                ValueAnimator valueAnimator = animation;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animation");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                }
                StickerDisplayPanel.access$setDeleteScale(this.this$0, ((Float)object).floatValue());
            }
            {
                this.this$0 = stickerDisplayPanel;
            }
        });
        ValueAnimator valueAnimator4 = this.mScaleAnim;
        if (valueAnimator4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mScaleAnim");
        }
        valueAnimator4.addListener(new Animator.AnimatorListener(this){
            final /* synthetic */ StickerDisplayPanel this$0;

            public void onAnimationEnd(@Nullable Animator animation) {
                StickerDisplayPanel.access$setMIsScaleAnimating$p(this.this$0, false);
            }

            public void onAnimationStart(@Nullable Animator animation) {
                StickerDisplayPanel.access$setMIsScaleAnimating$p(this.this$0, true);
            }

            public void onAnimationRepeat(@Nullable Animator animation) {
            }

            public void onAnimationCancel(@Nullable Animator animation) {
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void setDeleteScale(float scale) {
        YYFrameLayout yYFrameLayout = (YYFrameLayout)this._$_findCachedViewById(R.id.flDelete);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYFrameLayout, (String)"flDelete");
        yYFrameLayout.setScaleX(scale);
        YYFrameLayout yYFrameLayout2 = (YYFrameLayout)this._$_findCachedViewById(R.id.flDelete);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYFrameLayout2, (String)"flDelete");
        yYFrameLayout2.setScaleY(scale);
        SVGAImageView sVGAImageView = (SVGAImageView)this._$_findCachedViewById(R.id.svgaDelete);
        Intrinsics.checkExpressionValueIsNotNull((Object)sVGAImageView, (String)"svgaDelete");
        sVGAImageView.setScaleX(scale);
        SVGAImageView sVGAImageView2 = (SVGAImageView)this._$_findCachedViewById(R.id.svgaDelete);
        Intrinsics.checkExpressionValueIsNotNull((Object)sVGAImageView2, (String)"svgaDelete");
        sVGAImageView2.setScaleY(scale);
    }

    private final void initTranslationInAnim() {
        YYFrameLayout yYFrameLayout = (YYFrameLayout)this._$_findCachedViewById(R.id.flDelete);
        float[] fArray = new float[2];
        YYFrameLayout yYFrameLayout2 = (YYFrameLayout)this._$_findCachedViewById(R.id.flDelete);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYFrameLayout2, (String)"flDelete");
        fArray[0] = yYFrameLayout2.getTranslationY();
        fArray[1] = -((float)(this.mDeleteWidth - this.mDeleteHeight));
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)yYFrameLayout, (String)"translationY", (float[])fArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectAnimator, (String)"ObjectAnimator.ofFloat(f\u2026mDeleteHeight).toFloat())");
        ObjectAnimator objectAnimator2 = this.mTranslationInAnim = objectAnimator;
        if (objectAnimator2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mTranslationInAnim");
        }
        objectAnimator2.setDuration(150L);
        ObjectAnimator objectAnimator3 = this.mTranslationInAnim;
        if (objectAnimator3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mTranslationInAnim");
        }
        objectAnimator3.addListener(new Animator.AnimatorListener(this){
            final /* synthetic */ StickerDisplayPanel this$0;

            public void onAnimationStart(@Nullable Animator animation) {
                StickerDisplayPanel.access$setMIsTranslationInAnimating$p(this.this$0, true);
            }

            public void onAnimationEnd(@Nullable Animator animation) {
                StickerDisplayPanel.access$setMIsTranslationInAnimating$p(this.this$0, false);
            }

            public void onAnimationCancel(@Nullable Animator animation) {
            }

            public void onAnimationRepeat(@Nullable Animator animation) {
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void initTranslationOutAnim(int colorInit) {
        YYFrameLayout yYFrameLayout = (YYFrameLayout)this._$_findCachedViewById(R.id.flDelete);
        float[] fArray = new float[2];
        YYFrameLayout yYFrameLayout2 = (YYFrameLayout)this._$_findCachedViewById(R.id.flDelete);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYFrameLayout2, (String)"flDelete");
        fArray[0] = yYFrameLayout2.getTranslationY();
        fArray[1] = -((float)((double)this.mDeleteWidth + 0.05 * (double)this.mDeleteWidth));
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)yYFrameLayout, (String)"translationY", (float[])fArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectAnimator, (String)"ObjectAnimator.ofFloat(f\u2026 mDeleteWidth).toFloat())");
        ObjectAnimator objectAnimator2 = this.mTranslationOutAnim = objectAnimator;
        if (objectAnimator2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mTranslationOutAnim");
        }
        objectAnimator2.setDuration(150L);
        ObjectAnimator objectAnimator3 = this.mTranslationOutAnim;
        if (objectAnimator3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mTranslationOutAnim");
        }
        objectAnimator3.addListener(new Animator.AnimatorListener(this, colorInit){
            final /* synthetic */ StickerDisplayPanel this$0;
            final /* synthetic */ int $colorInit;

            public void onAnimationStart(@Nullable Animator animation) {
                StickerDisplayPanel.access$setMIsTranslationOutAnimating$p(this.this$0, true);
            }

            public void onAnimationEnd(@Nullable Animator animation) {
                StickerDisplayPanel.access$setMIsTranslationOutAnimating$p(this.this$0, false);
                StickerDisplayPanel.access$setDeleteScale(this.this$0, 1.0f);
                StickerDisplayPanel.access$setBgColor(this.this$0, this.$colorInit);
                YYFrameLayout yYFrameLayout = (YYFrameLayout)this.this$0._$_findCachedViewById(R.id.flDelete);
                Intrinsics.checkExpressionValueIsNotNull((Object)yYFrameLayout, (String)"flDelete");
                yYFrameLayout.setTranslationY(-((float)StickerDisplayPanel.access$getMDeleteWidth$p(this.this$0)));
            }

            public void onAnimationCancel(@Nullable Animator animation) {
            }

            public void onAnimationRepeat(@Nullable Animator animation) {
            }
            {
                this.this$0 = $outer;
                this.$colorInit = $captured_local_variable$1;
            }
        });
    }

    private final void playTriggerSvga(int svgaMode) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("playTriggerSvga , svgaMode=" + svgaMode), (Object[])new Object[0]);
        }
        ((SVGAImageView)this._$_findCachedViewById(R.id.svgaDelete)).setCallback((SVGACallback)null);
        ((SVGAImageView)this._$_findCachedViewById(R.id.svgaDelete)).setFillMode(SVGAImageView.FillMode.Forward);
        SvgaLoader.load((SVGAImageView)((SVGAImageView)this._$_findCachedViewById(R.id.svgaDelete)), (String)SVGA_DELETE_START, (ISvgaLoadCallback)new ISvgaLoadCallback(this, svgaMode){
            final /* synthetic */ StickerDisplayPanel this$0;
            final /* synthetic */ int $svgaMode;

            public void onFinished(@NotNull SVGAVideoEntity svgaVideoEntity) {
                Intrinsics.checkParameterIsNotNull((Object)svgaVideoEntity, (String)"svgaVideoEntity");
                ((SVGAImageView)this.this$0._$_findCachedViewById(R.id.svgaDelete)).setLoopCount(1);
                ((SVGAImageView)this.this$0._$_findCachedViewById(R.id.svgaDelete)).setClearsAfterStop(false);
                switch (this.$svgaMode) {
                    case 0: {
                        ((SVGAImageView)this.this$0._$_findCachedViewById(R.id.svgaDelete)).stepToFrame(0, false);
                        break;
                    }
                    case 1: {
                        ((SVGAImageView)this.this$0._$_findCachedViewById(R.id.svgaDelete)).startAnimation();
                        break;
                    }
                    case 2: {
                        ((SVGAImageView)this.this$0._$_findCachedViewById(R.id.svgaDelete)).setFillMode(SVGAImageView.FillMode.Backward);
                        ((SVGAImageView)this.this$0._$_findCachedViewById(R.id.svgaDelete)).startAnimation(new SVGARange(0, svgaVideoEntity.getFrames()), true);
                    }
                }
            }

            public void onFailed(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            }
            {
                this.this$0 = $outer;
                this.$svgaMode = $captured_local_variable$1;
            }
        });
    }

    private final void playDeleteSvga() {
        ((SVGAImageView)this._$_findCachedViewById(R.id.svgaDelete)).setCallback(new SVGACallback(this){
            final /* synthetic */ StickerDisplayPanel this$0;

            public void onPause() {
            }

            public void onFinished() {
                StickerDisplayPanel.access$getMTranslationOutAnim$p(this.this$0).start();
                StickerDisplayPanel.access$playScreenAnim(this.this$0, true);
            }

            public void onRepeat() {
            }

            public void onStep(int i, double v) {
            }
            {
                this.this$0 = $outer;
            }
        });
        SvgaLoader.load((SVGAImageView)((SVGAImageView)this._$_findCachedViewById(R.id.svgaDelete)), (String)SVGA_DELETE_SUCCESS, (ISvgaLoadCallback)new ISvgaLoadCallback(this){
            final /* synthetic */ StickerDisplayPanel this$0;

            public void onFinished(@NotNull SVGAVideoEntity svgaVideoEntity) {
                Intrinsics.checkParameterIsNotNull((Object)svgaVideoEntity, (String)"svgaVideoEntity");
                ((SVGAImageView)this.this$0._$_findCachedViewById(R.id.svgaDelete)).setClearsAfterStop(false);
                ((SVGAImageView)this.this$0._$_findCachedViewById(R.id.svgaDelete)).setLoopCount(1);
                ((SVGAImageView)this.this$0._$_findCachedViewById(R.id.svgaDelete)).setFillMode(SVGAImageView.FillMode.Forward);
                ((SVGAImageView)this.this$0._$_findCachedViewById(R.id.svgaDelete)).startAnimation();
            }

            public void onFailed(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final boolean isDeleteStatus() {
        double d;
        YYFrameLayout yYFrameLayout = (YYFrameLayout)this._$_findCachedViewById(R.id.flDelete);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYFrameLayout, (String)"flDelete");
        if (yYFrameLayout.getTranslationY() < 0.0f) {
            YYFrameLayout yYFrameLayout2 = (YYFrameLayout)this._$_findCachedViewById(R.id.flDelete);
            Intrinsics.checkExpressionValueIsNotNull((Object)yYFrameLayout2, (String)"flDelete");
            d = (double)yYFrameLayout2.getTranslationY() - 0.5;
        } else {
            YYFrameLayout yYFrameLayout3 = (YYFrameLayout)this._$_findCachedViewById(R.id.flDelete);
            Intrinsics.checkExpressionValueIsNotNull((Object)yYFrameLayout3, (String)"flDelete");
            d = (double)yYFrameLayout3.getTranslationY() + 0.5;
        }
        double transY = d;
        return (int)transY > -ResolutionUtils.dip2Px((float)250.0f);
    }

    private final void setBgColor(int color2) {
        block1: {
            Drawable background;
            YYFrameLayout yYFrameLayout = (YYFrameLayout)this._$_findCachedViewById(R.id.flDelete);
            Intrinsics.checkExpressionValueIsNotNull((Object)yYFrameLayout, (String)"flDelete");
            Drawable drawable2 = background = yYFrameLayout.getBackground();
            if (drawable2 == null) break block1;
            Drawable drawable3 = drawable2;
            boolean bl = false;
            boolean bl2 = false;
            Drawable $this$run = drawable3;
            boolean bl3 = false;
            Drawable drawable4 = $this$run;
            if (drawable4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
            }
            ((GradientDrawable)drawable4).setColor(color2);
        }
    }

    private final boolean isDeletable(StickerView view) {
        return view.getTranslationY() <= (float)ResolutionUtils.dip2Px((float)92.5f);
    }

    @Override
    @NotNull
    public View getView() {
        return (View)this;
    }

    @Override
    public void updateStickers(@NotNull List<StickerInfo> stickers) {
        Intrinsics.checkParameterIsNotNull(stickers, (String)"stickers");
        MLog.info((Object)TAG, (String)("updateStickers,isVideoLive=" + this.mPresenter.isVideoLive() + ",mStickerMap=" + this.mStickerMap.values() + ",stickers=" + stickers), (Object[])new Object[0]);
        if (!FP.empty(this.mStickerMap.values())) {
            for (StickerView stickerView : this.mStickerMap.values()) {
                this.removeView((View)stickerView);
            }
        }
        this.mStickerMap.clear();
        if (!FP.empty((Collection)stickers)) {
            for (StickerInfo stickerInfo : stickers) {
                Long l = stickerInfo.getSeqId();
                Context context = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                this.mStickerMap.put(l, new StickerView(context, stickerInfo, this.mPresenter.isVideoLive(), this));
            }
            for (StickerView stickerView : this.mStickerMap.values()) {
                this.addView((View)stickerView);
            }
        }
    }

    @Override
    public void onContentChanged(@NotNull StickerInfo stickerInfo, @Nullable IApplyStickerCallback callback2) {
        Intrinsics.checkParameterIsNotNull((Object)stickerInfo, (String)"stickerInfo");
        this.mPresenter.handleStickerInfoChanged(stickerInfo, callback2);
    }

    @Override
    public void onStickerMoving(@NotNull StickerInfo stickerInfo) {
        Intrinsics.checkParameterIsNotNull((Object)stickerInfo, (String)"stickerInfo");
        if (this.mPresenter.isOwnerOrAnchor()) {
            StickerView stickerView = this.mStickerMap.get(stickerInfo.getSeqId());
            if (stickerView == null) {
                return;
            }
            StickerView view = stickerView;
            if (!this.mIsTranslationInAnimating && !this.isDeleteStatus()) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)("onStickerMoving, show delete, stickerInfo=" + stickerInfo), (Object[])new Object[0]);
                }
                ObjectAnimator objectAnimator = this.mTranslationInAnim;
                if (objectAnimator == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mTranslationInAnim");
                }
                objectAnimator.start();
                this.playTriggerSvga(0);
                this.playScreenAnim(false);
            }
            if (!this.mIsColorAnimating && !StringUtils.equal((String)String.valueOf(this.mLastStatus), (String)String.valueOf(this.isDeletable(view)))) {
                if (this.isDeletable(view)) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)("onStickerMoving, trigger delete, stickerInfo=" + stickerInfo), (Object[])new Object[0]);
                    }
                    ValueAnimator valueAnimator = this.mColorAnim;
                    if (valueAnimator == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mColorAnim");
                    }
                    valueAnimator.start();
                    ValueAnimator valueAnimator2 = this.mScaleAnim;
                    if (valueAnimator2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mScaleAnim");
                    }
                    valueAnimator2.start();
                    this.playTriggerSvga(1);
                } else {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)("onStickerMoving, untrigger delete, stickerInfo=" + stickerInfo), (Object[])new Object[0]);
                    }
                    ValueAnimator valueAnimator = this.mColorAnim;
                    if (valueAnimator == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mColorAnim");
                    }
                    valueAnimator.reverse();
                    ValueAnimator valueAnimator3 = this.mScaleAnim;
                    if (valueAnimator3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mScaleAnim");
                    }
                    valueAnimator3.reverse();
                    this.playTriggerSvga(2);
                }
                this.mLastStatus = this.isDeletable(view);
            }
        }
    }

    private final void playScreenAnim(boolean isShow) {
        ConstraintSet constraintSet = this.mConstraintSet = new ConstraintSet();
        if (constraintSet == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mConstraintSet");
        }
        View view = this.mPresenter.getRootLayout();
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout");
        }
        constraintSet.clone((ConstraintLayout)view);
        AutoTransition transition = new AutoTransition();
        transition.setDuration(150L);
        View view2 = this.mPresenter.getRootLayout();
        if (view2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout");
        }
        TransitionManager.beginDelayedTransition((ViewGroup)((ViewGroup)((ConstraintLayout)view2)), (Transition)((Transition)transition));
        ConstraintSet constraintSet2 = this.mConstraintSet;
        if (constraintSet2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mConstraintSet");
        }
        ConstraintSet constraintSet3 = constraintSet2;
        boolean bl = false;
        boolean bl2 = false;
        ConstraintSet $this$apply = constraintSet3;
        boolean bl3 = false;
        $this$apply.setVisibility(R.id.clTopContainer, isShow ? 0 : 4);
        $this$apply.setVisibility(R.id.seatHolder, isShow ? 0 : 4);
        ConstraintSet constraintSet4 = this.mConstraintSet;
        if (constraintSet4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mConstraintSet");
        }
        View view3 = this.mPresenter.getRootLayout();
        if (view3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout");
        }
        constraintSet4.applyTo((ConstraintLayout)view3);
    }

    @Override
    public void onStickerPosChanged(@NotNull StickerInfo stickerInfo) {
        Intrinsics.checkParameterIsNotNull((Object)stickerInfo, (String)"stickerInfo");
        if (this.mPresenter.isOwnerOrAnchor()) {
            StickerView stickerView = this.mStickerMap.get(stickerInfo.getSeqId());
            if (stickerView == null) {
                return;
            }
            StickerView view = stickerView;
            if (this.isDeletable(view)) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)("onStickerPosChanged, deletable, stickerInfo=" + stickerInfo), (Object[])new Object[0]);
                }
                this.playDeleteSvga();
                this.mPresenter.handleDeleteSticker(stickerInfo);
            } else {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)("onStickerPosChanged, undeletable, stickerInfo=" + stickerInfo), (Object[])new Object[0]);
                }
                ObjectAnimator objectAnimator = this.mTranslationInAnim;
                if (objectAnimator == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mTranslationInAnim");
                }
                objectAnimator.reverse();
                this.playScreenAnim(true);
                IStickerDisplayPresenter.DefaultImpls.handleStickerInfoChanged$default(this.mPresenter, stickerInfo, null, 2, null);
            }
            this.mLastStatus = false;
        }
    }

    @Override
    @NotNull
    public int[] getLimit() {
        View view = this.mPresenter.getRootLayout().findViewById(R.id.publicScreenHolder);
        int[] limit = new int[2];
        view.getLocationInWindow(limit);
        if (LanguageUtils.isLtr()) {
            int n = limit[0];
            View view2 = view;
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view");
            limit[0] = n + view2.getWidth();
        }
        limit[1] = limit[1] - SystemUtils.getStatusBarHeight((Context)this.getContext());
        return limit;
    }

    public StickerDisplayPanel(@NotNull Context context, @NotNull StickerDisplayPresenter presenter) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)presenter, (String)"presenter");
        super(context);
        StickerDisplayPanel stickerDisplayPanel = this;
        boolean bl = false;
        stickerDisplayPanel.mStickerMap = map = (Map)new LinkedHashMap();
        this.mDeleteWidth = ResolutionUtils.dip2Px((float)250.0f);
        this.mDeleteHeight = ResolutionUtils.dip2Px((float)80.0f);
        this.mPresenter = presenter;
        this.createView();
    }

    public static final /* synthetic */ void access$setBgColor(StickerDisplayPanel $this, int color2) {
        $this.setBgColor(color2);
    }

    public static final /* synthetic */ boolean access$getMIsColorAnimating$p(StickerDisplayPanel $this) {
        return $this.mIsColorAnimating;
    }

    public static final /* synthetic */ void access$setMIsColorAnimating$p(StickerDisplayPanel $this, boolean bl) {
        $this.mIsColorAnimating = bl;
    }

    public static final /* synthetic */ void access$setDeleteScale(StickerDisplayPanel $this, float scale) {
        $this.setDeleteScale(scale);
    }

    public static final /* synthetic */ boolean access$getMIsScaleAnimating$p(StickerDisplayPanel $this) {
        return $this.mIsScaleAnimating;
    }

    public static final /* synthetic */ void access$setMIsScaleAnimating$p(StickerDisplayPanel $this, boolean bl) {
        $this.mIsScaleAnimating = bl;
    }

    public static final /* synthetic */ boolean access$getMIsTranslationInAnimating$p(StickerDisplayPanel $this) {
        return $this.mIsTranslationInAnimating;
    }

    public static final /* synthetic */ void access$setMIsTranslationInAnimating$p(StickerDisplayPanel $this, boolean bl) {
        $this.mIsTranslationInAnimating = bl;
    }

    public static final /* synthetic */ boolean access$getMIsTranslationOutAnimating$p(StickerDisplayPanel $this) {
        return $this.mIsTranslationOutAnimating;
    }

    public static final /* synthetic */ void access$setMIsTranslationOutAnimating$p(StickerDisplayPanel $this, boolean bl) {
        $this.mIsTranslationOutAnimating = bl;
    }

    public static final /* synthetic */ int access$getMDeleteWidth$p(StickerDisplayPanel $this) {
        return $this.mDeleteWidth;
    }

    public static final /* synthetic */ ObjectAnimator access$getMTranslationOutAnim$p(StickerDisplayPanel $this) {
        ObjectAnimator objectAnimator = $this.mTranslationOutAnim;
        if (objectAnimator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mTranslationOutAnim");
        }
        return objectAnimator;
    }

    public static final /* synthetic */ void access$setMTranslationOutAnim$p(StickerDisplayPanel $this, ObjectAnimator objectAnimator) {
        $this.mTranslationOutAnim = objectAnimator;
    }

    public static final /* synthetic */ void access$playScreenAnim(StickerDisplayPanel $this, boolean isShow) {
        $this.playScreenAnim(isShow);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/sticker/display/StickerDisplayPanel$Companion;", "", "()V", "ANIM_DURATION", "", "MODE_ANIM_NORMAL", "", "MODE_ANIM_REVERSE", "MODE_FIRST_FRAME", "SVGA_DELETE_START", "", "SVGA_DELETE_SUCCESS", "TAG", "radio_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

