/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.star;

import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import com.yy.appbase.eventobserver.Event;
import com.yy.appbase.extension.EasyExtensionKt;
import com.yy.appbase.safelivedata.SafeLiveData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.IEnteredChannel;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.module.endpage.viewmodel.StarModel;
import com.yy.hiyo.channel.plugins.radio.star.StarEntryModule;
import com.yy.hiyo.channel.plugins.radio.star.StarNotify;
import com.yy.hiyo.mvp.base.IMvpLifeCycleOwner;
import com.yy.hiyo.mvp.base.INotifyDispatchService;
import ikxd.through.KxdThrough;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0006\u0010\u0019\u001a\u00020\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\u001a\u0010\u001b\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\fH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00130\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/star/StarEntryModel;", "Lcom/yy/hiyo/channel/plugins/radio/star/StarEntryModule$IModel;", "Lcom/yy/hiyo/channel/base/service/plugin/IPluginService$IPluginDataChangedCallBack;", "lifeCycleOwner", "Lcom/yy/hiyo/mvp/base/IMvpLifeCycleOwner;", "channel", "Lcom/yy/hiyo/channel/base/service/IEnteredChannel;", "(Lcom/yy/hiyo/mvp/base/IMvpLifeCycleOwner;Lcom/yy/hiyo/channel/base/service/IEnteredChannel;)V", "getChannel", "()Lcom/yy/hiyo/channel/base/service/IEnteredChannel;", "isVisible", "Lcom/yy/appbase/safelivedata/SafeLiveData;", "", "()Lcom/yy/appbase/safelivedata/SafeLiveData;", "notifyAt", "", "notifyService", "Lcom/yy/hiyo/channel/plugins/radio/star/StarNotify;", "upgradeEvent", "Lcom/yy/appbase/eventobserver/Event;", "getUpgradeEvent", "checkVisible", "", "isVideoMode", "isOpen", "onDestroy", "onLevelChangedNotify", "onVideoModeChanged", "channelId", "", "radio_debug"})
public final class StarEntryModel
implements StarEntryModule.IModel,
IPluginService.IPluginDataChangedCallBack {
    private long notifyAt;
    @NotNull
    private final SafeLiveData<Boolean> isVisible;
    @NotNull
    private final SafeLiveData<Event<Boolean>> upgradeEvent;
    private final StarNotify notifyService;
    @NotNull
    private final IEnteredChannel channel;

    @NotNull
    public final SafeLiveData<Boolean> isVisible() {
        return this.isVisible;
    }

    @NotNull
    public final SafeLiveData<Event<Boolean>> getUpgradeEvent() {
        return this.upgradeEvent;
    }

    public void onVideoModeChanged(@Nullable String channelId, boolean isVideoMode) {
        this.checkVisible(isVideoMode, EasyExtensionKt.isTrue((Boolean)((Boolean)StarModel.INSTANCE.isOpen().getValue())));
    }

    private final void checkVisible(boolean isVideoMode, boolean isOpen) {
        this.isVisible.setValue((Object)(isVideoMode && isOpen ? 1 : 0));
    }

    @Override
    public void onLevelChangedNotify() {
        int interval;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FTChannel.Star.StarEntryVM", (String)"onLevelChangedNotify", (Object[])new Object[0]);
        }
        int n = interval = RuntimeContext.isLocalBuild() ? 100 : 60000;
        if (System.currentTimeMillis() - this.notifyAt > (long)interval) {
            this.notifyAt = System.currentTimeMillis();
            this.upgradeEvent.postValue((Object)Event.Companion.of((Object)true));
        }
    }

    public final void onDestroy() {
        this.channel.getPluginService().removePluginDataListener((IPluginService.IPluginDataChangedCallBack)this);
        this.notifyService.onDestroy();
    }

    @NotNull
    public final IEnteredChannel getChannel() {
        return this.channel;
    }

    public StarEntryModel(@NotNull IMvpLifeCycleOwner lifeCycleOwner, @NotNull IEnteredChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)lifeCycleOwner, (String)"lifeCycleOwner");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        this.channel = channel;
        this.isVisible = new SafeLiveData();
        this.upgradeEvent = new SafeLiveData();
        this.notifyService = new StarNotify();
        StarModel.requestConfig$default((StarModel)StarModel.INSTANCE, (boolean)false, (int)1, null);
        this.channel.getPluginService().addPluginDataListener((IPluginService.IPluginDataChangedCallBack)this);
        this.notifyService.addHandler((INotifyDispatchService.INotifyHandler)new INotifyDispatchService.INotifyHandler<KxdThrough>(){

            public final void onHandleNotify(KxdThrough it) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"FTChannel.Star.StarEntryVM", (String)("onNotify " + it.web_message_notify.name), (Object[])new Object[0]);
                }
                if (Intrinsics.areEqual((Object)it.web_message_notify.name, (Object)"kUriStarryInfoChange")) {
                    try {
                        String data = it.web_message_notify.data.utf8();
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)"FTChannel.Star.StarEntryVM", (String)("kUriStarryInfoChange " + data), (Object[])new Object[0]);
                        }
                        this.onLevelChangedNotify();
                    }
                    catch (Exception e) {
                        MLog.error((Object)"FTChannel.Star.StarEntryVM", (Throwable)e);
                        this.onLevelChangedNotify();
                    }
                }
            }
        });
        StarModel.INSTANCE.isOpen().observe((LifecycleOwner)lifeCycleOwner, (Observer)new Observer<Boolean>(){

            public final void onChanged(Boolean it) {
                IPluginService iPluginService = this.getChannel().getPluginService();
                Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService, (String)"channel.pluginService");
                ChannelPluginData channelPluginData = iPluginService.getCurPluginData();
                Intrinsics.checkExpressionValueIsNotNull((Object)channelPluginData, (String)"channel.pluginService.curPluginData");
                boolean bl = channelPluginData.isVideoMode();
                Boolean bl2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl2, (String)"it");
                this.checkVisible(bl, bl2);
            }
        });
    }
}

