/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.screenrecord.impl;

import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.MediaCodec;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Parcelable;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.service.IBaseEnvService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.BbsPostConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.channel.ChannelBaseMsgDef;
import com.yy.hiyo.channel.cbase.channelhiido.RadioUtils;
import com.yy.hiyo.channel.plugins.radio.screenrecord.impl.BaseEncoder;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0001\u0018\u0000 52\u00020\u00012\u00020\u0002:\u00015B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001a\u001a\u00020\u001bH\u0003J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u0016H\u0003J\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J\"\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\b\u0010'\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u0010(\u001a\u00020 H\u0002J\u0010\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020+H\u0014J\u0018\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020\u0004H\u0016J\u0010\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020\nH\u0007J\b\u00101\u001a\u00020 H\u0016J\b\u00102\u001a\u00020 H\u0003J\u0006\u00103\u001a\u00020\u001bJ\b\u00104\u001a\u00020 H\u0016R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\b\u00a8\u00066"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/ScreenVideoEncoder;", "Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/BaseEncoder;", "Lcom/yy/framework/core/INotify;", "width", "", "height", "(II)V", "getHeight", "()I", "mCaptureReadyCallback", "Ljava/lang/Runnable;", "mDisplay", "Landroid/hardware/display/VirtualDisplay;", "getMDisplay", "()Landroid/hardware/display/VirtualDisplay;", "setMDisplay", "(Landroid/hardware/display/VirtualDisplay;)V", "mInputSurface", "Landroid/view/Surface;", "mMediaProjection", "Landroid/media/projection/MediaProjection;", "mMediaProjectionManager", "Landroid/media/projection/MediaProjectionManager;", "mRequestVirtualDisplayIntent", "Landroid/content/Intent;", "getWidth", "checkPrepareIntent", "", "createMediaFormat", "Landroid/media/MediaFormat;", "getProjectionManager", "init", "", "notify", "notification", "Lcom/yy/framework/core/Notification;", "onActivityResult", "requestCode", "resultCode", "data", "onCapturePermissionReady", "onEncoderConfigured", "encoder", "Landroid/media/MediaCodec;", "onInputBufferAvailable", "codec", "index", "prepareCapturePermission", "readyCallback", "release", "requestCaptureScreenPermission", "startRecord", "stop", "Companion", "radio_debug"})
@RequiresApi(value=21)
public final class ScreenVideoEncoder
extends BaseEncoder
implements INotify {
    @Nullable
    private VirtualDisplay mDisplay;
    private Runnable mCaptureReadyCallback;
    private MediaProjection mMediaProjection;
    private MediaProjectionManager mMediaProjectionManager;
    private Intent mRequestVirtualDisplayIntent;
    private Surface mInputSurface;
    private final int width;
    private final int height;
    @NotNull
    public static final String TAG = "ScreenVideoEncoder";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final VirtualDisplay getMDisplay() {
        return this.mDisplay;
    }

    public final void setMDisplay(@Nullable VirtualDisplay virtualDisplay) {
        this.mDisplay = virtualDisplay;
    }

    public final void init() {
        NotificationCenter.getGlobalInstance().register(ChannelBaseMsgDef.CAPTURE_SCREEN_PERMISSION_REQUEST, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ChannelBaseMsgDef.CAPTURE_SCREEN_PERMISSION_REQUESTForQ, (INotify)this);
    }

    @RequiresApi(value=21)
    public final void prepareCapturePermission(@NotNull Runnable readyCallback) {
        Intrinsics.checkParameterIsNotNull((Object)readyCallback, (String)"readyCallback");
        this.mCaptureReadyCallback = readyCallback;
        if (this.checkPrepareIntent()) {
            this.onCapturePermissionReady();
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                final /* synthetic */ ScreenVideoEncoder this$0;

                public final void run() {
                    ScreenVideoEncoder.access$requestCaptureScreenPermission(this.this$0);
                }
                {
                    this.this$0 = screenVideoEncoder;
                }
            });
        }
    }

    @RequiresApi(value=21)
    private final void requestCaptureScreenPermission() {
        FragmentActivity activity = ((IBaseEnvService)ServiceManagerProxy.getInstance().getService(IBaseEnvService.class)).getBaseAEnv().getContext();
        NotificationCenter.getGlobalInstance().unregister(ChannelBaseMsgDef.CAPTURE_SCREEN_PERMISSION_REQUEST, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ChannelBaseMsgDef.CAPTURE_SCREEN_PERMISSION_REQUEST, (INotify)this);
        activity.startActivityForResult(this.getProjectionManager().createScreenCaptureIntent(), 3002);
        RadioUtils.INSTANCE.reportRequestCaptureScreenPermission();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"Request Capture Permission", (Object[])new Object[0]);
        }
    }

    private final void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (requestCode == 3002) {
            if (resultCode != -1) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"User cancelled", (Object[])new Object[0]);
                }
                RadioUtils.INSTANCE.reportCaptureScreenPermissionResult(false);
                return;
            }
            this.mRequestVirtualDisplayIntent = data;
            if (Build.VERSION.SDK_INT < 29) {
                if (this.checkPrepareIntent()) {
                    this.onCapturePermissionReady();
                    RadioUtils.INSTANCE.reportCaptureScreenPermissionResult(true);
                } else {
                    RadioUtils.INSTANCE.reportCaptureScreenPermissionResult(false);
                }
            } else {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"android q process", (Object[])new Object[0]);
                }
                FragmentActivity activity = ((IBaseEnvService)ServiceManagerProxy.getInstance().getService(IBaseEnvService.class)).getBaseAEnv().getContext();
                Intent service = new Intent();
                service.setClassName("com.yy.hiyo", "com.yy.hiyo.app.screenrecord.CaptureScreenService");
                service.putExtra("code", resultCode);
                service.putExtra("data", (Parcelable)data);
                activity.startForegroundService(service);
            }
        }
    }

    public void notify(@NotNull Notification notification) {
        Object[] objects;
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
        if (notification.id == ChannelBaseMsgDef.CAPTURE_SCREEN_PERMISSION_REQUEST && notification.extObj instanceof Object[]) {
            Object object = notification.extObj;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            }
            objects = (Object[])object;
            if (objects.length == 3) {
                Object object2 = objects[0];
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                Object object3 = objects[1];
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.onActivityResult((Integer)object2, (Integer)object3, (Intent)objects[2]);
            }
        }
        if (notification.id == ChannelBaseMsgDef.CAPTURE_SCREEN_PERMISSION_REQUESTForQ) {
            objects = notification.extObj;
            if (objects instanceof MediaProjection) {
                if (this.mMediaProjection != null) {
                    MediaProjection mediaProjection = this.mMediaProjection;
                    if (mediaProjection != null) {
                        mediaProjection.stop();
                    }
                    this.mMediaProjection = null;
                }
                this.mMediaProjection = (MediaProjection)objects;
                this.onCapturePermissionReady();
                RadioUtils.INSTANCE.reportCaptureScreenPermissionResult(true);
            } else {
                RadioUtils.INSTANCE.reportCaptureScreenPermissionResult(false);
            }
        }
    }

    @RequiresApi(value=21)
    private final boolean checkPrepareIntent() {
        Intent intent = this.mRequestVirtualDisplayIntent;
        if (intent == null) {
            return false;
        }
        Intent intent2 = intent;
        if (this.mMediaProjection != null) {
            MediaProjection mediaProjection = this.mMediaProjection;
            if (mediaProjection != null) {
                mediaProjection.stop();
            }
            this.mMediaProjection = null;
        }
        this.mMediaProjection = this.getProjectionManager().getMediaProjection(-1, intent2);
        return this.mMediaProjection != null;
    }

    @RequiresApi(value=21)
    private final MediaProjectionManager getProjectionManager() {
        MediaProjectionManager projectionManager = this.mMediaProjectionManager;
        if (projectionManager == null) {
            Object object = RuntimeContext.sApplicationContext.getSystemService("media_projection");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.media.projection.MediaProjectionManager");
            }
            projectionManager = (MediaProjectionManager)object;
        }
        this.mMediaProjectionManager = projectionManager;
        return projectionManager;
    }

    private final void onCapturePermissionReady() {
        Runnable runnable2 = this.mCaptureReadyCallback;
        if (runnable2 != null) {
            runnable2.run();
        }
        this.mCaptureReadyCallback = null;
    }

    @Override
    @NotNull
    protected MediaFormat createMediaFormat() {
        BbsPostConfig bbsPostConfig;
        MediaCodecList codecList = new MediaCodecList(1);
        String mime = "video/avc";
        MediaFormat format = MediaFormat.createVideoFormat((String)mime, (int)this.width, (int)this.height);
        if (codecList.findEncoderForFormat(format) == null) {
            MLog.warn((Object)TAG, (String)("NOT SUPPORT " + mime + "??"), (Object[])new Object[0]);
        }
        int frameRate = 20;
        AConfigData aConfigData = UnifyConfig.INSTANCE.getConfigData(BssCode.BBS_POST_CONFIG);
        if (!(aConfigData instanceof BbsPostConfig)) {
            aConfigData = null;
        }
        int bitrate = (bbsPostConfig = (BbsPostConfig)aConfigData) != null && (bbsPostConfig = bbsPostConfig.getData()) != null ? bbsPostConfig.getVideoBitrate() : 1500;
        bitrate = Math.min(Math.max(bitrate, 800), 20000);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)(" BitRate: " + bitrate), (Object[])new Object[0]);
        }
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", (int)((float)bitrate / 1000.0f * (float)1024 * (float)1024));
        format.setInteger("frame-rate", frameRate);
        format.setInteger("i-frame-interval", 2);
        MediaFormat mediaFormat = format;
        Intrinsics.checkExpressionValueIsNotNull((Object)mediaFormat, (String)"format");
        return mediaFormat;
    }

    public void onInputBufferAvailable(@NotNull MediaCodec codec, int index) {
        Intrinsics.checkParameterIsNotNull((Object)codec, (String)"codec");
        MLog.error((Object)TAG, (String)"Ignore , Video Input from Surface", (Object[])new Object[0]);
    }

    @Override
    protected void onEncoderConfigured(@NotNull MediaCodec encoder) {
        Intrinsics.checkParameterIsNotNull((Object)encoder, (String)"encoder");
        this.mInputSurface = encoder.createInputSurface();
    }

    public final boolean startRecord() {
        this.start();
        MediaProjection mediaProjection = this.mMediaProjection;
        VirtualDisplay virtualDisplay = this.mDisplay = mediaProjection != null ? mediaProjection.createVirtualDisplay("Recording Display", this.width, this.height, 1, 1, this.mInputSurface, null, null) : null;
        if (this.mDisplay != null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)("startRecord " + this.mDisplay), (Object[])new Object[0]);
            }
            return true;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("startRecord Failed! " + this.mDisplay), (Object[])new Object[0]);
        }
        return false;
    }

    @Override
    public void stop() {
        VirtualDisplay virtualDisplay = this.mDisplay;
        if (virtualDisplay != null) {
            virtualDisplay.release();
        }
        this.mDisplay = null;
        MediaProjection mediaProjection = this.mMediaProjection;
        if (mediaProjection != null) {
            mediaProjection.stop();
        }
        this.mMediaProjection = null;
        Surface surface = this.mInputSurface;
        if (surface != null) {
            surface.release();
        }
        this.mInputSurface = null;
        super.stop();
    }

    @Override
    public void release() {
        super.release();
        NotificationCenter.getGlobalInstance().unregister(ChannelBaseMsgDef.CAPTURE_SCREEN_PERMISSION_REQUEST, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(ChannelBaseMsgDef.CAPTURE_SCREEN_PERMISSION_REQUESTForQ, (INotify)this);
        if (Build.VERSION.SDK_INT >= 29) {
            FragmentActivity activity = ((IBaseEnvService)ServiceManagerProxy.getInstance().getService(IBaseEnvService.class)).getBaseAEnv().getContext();
            Intent service = new Intent();
            service.setClassName("com.yy.hiyo", "com.yy.hiyo.app.screenrecord.CaptureScreenService");
            activity.stopService(service);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"releaseService", (Object[])new Object[0]);
            }
        }
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public ScreenVideoEncoder(int width, int height2) {
        this.width = width;
        this.height = height2;
    }

    public static final /* synthetic */ void access$requestCaptureScreenPermission(ScreenVideoEncoder $this) {
        $this.requestCaptureScreenPermission();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/ScreenVideoEncoder$Companion;", "", "()V", "TAG", "", "radio_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

