/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.bubble.widget;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.PointF;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import com.scwang.smartrefresh.layout.util.DensityUtil;
import com.yy.appbase.callback.SimpleAnimatorListener;
import com.yy.appbase.extensions.CommonExtensionsKt;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.channel.plugins.radio.bubble.util.BubbleBezierUtils;
import com.yy.hiyo.channel.plugins.radio.bubble.widget.BubbleBaseView;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000fH\u0014R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/bubble/widget/BubbleView;", "Lcom/yy/hiyo/channel/plugins/radio/bubble/widget/BubbleBaseView;", "context", "Landroid/content/Context;", "animListener", "Lcom/yy/appbase/callback/SimpleAnimatorListener;", "(Landroid/content/Context;Lcom/yy/appbase/callback/SimpleAnimatorListener;)V", "startTime", "", "getStartTime", "()J", "setStartTime", "(J)V", "getBezierPoint", "", "Landroid/graphics/PointF;", "statusBarTranslucent", "", "(Z)[Landroid/graphics/PointF;", "startAnim", "", "iconUrl", "", "startPoint", "endPoint", "update", "t", "", "point", "Companion", "radio_debug"})
public class BubbleView
extends BubbleBaseView {
    private long startTime;
    @NotNull
    public static final String TAG = "BUBBLE";
    public static final long DURATION = 2500L;
    public static final float START_SCALE = 0.3f;
    public static final float SCALE_STATE_1 = 0.02f;
    public static final float SCALE_TARGET_1 = 1.0f;
    public static final float SCALE_STATE_2 = 0.04f;
    public static final float SCALE_TARGET_2 = 1.5f;
    public static final float SCALE_STATE_3 = 0.16f;
    public static final float SCALE_TARGET_3 = 1.0f;
    public static final float SCALE_STATE_4 = 1.0f;
    public static final float SCALE_TARGET_4 = 0.6f;
    public static final float START_DISMISS_STATE = 0.8f;
    public static final float START_ALPHA_STATE = 0.128f;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    public final long getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(long l) {
        this.startTime = l;
    }

    @Override
    public void startAnim(@NotNull String iconUrl, @NotNull PointF startPoint, @NotNull PointF endPoint, boolean statusBarTranslucent) {
        Intrinsics.checkParameterIsNotNull((Object)iconUrl, (String)"iconUrl");
        Intrinsics.checkParameterIsNotNull((Object)startPoint, (String)"startPoint");
        Intrinsics.checkParameterIsNotNull((Object)endPoint, (String)"endPoint");
        ImageLoader.loadImage((RecycleImageView)this, (String)iconUrl);
        PointF[] bezierPoint = this.getBezierPoint(statusBarTranslucent);
        this.getValueAnimator().setDuration(2500L).addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this, bezierPoint){
            final /* synthetic */ BubbleView this$0;
            final /* synthetic */ PointF[] $bezierPoint;

            public final void onAnimationUpdate(ValueAnimator it) {
                ValueAnimator valueAnimator = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"it");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                }
                float t = ((Float)object).floatValue();
                PointF point = BubbleBezierUtils.calculateBezierPointForCubic(t, this.$bezierPoint[0], this.$bezierPoint[1], this.$bezierPoint[2], this.$bezierPoint[3]);
                this.this$0.setCurPointF(point);
                PointF pointF = point;
                Intrinsics.checkExpressionValueIsNotNull((Object)pointF, (String)"point");
                this.this$0.update(t, pointF);
            }
            {
                this.this$0 = bubbleView;
                this.$bezierPoint = pointFArray;
            }
        });
        this.getValueAnimator().setInterpolator((TimeInterpolator)new DecelerateInterpolator(0.5f));
        this.getValueAnimator().start();
        this.startTime = System.currentTimeMillis();
    }

    protected void update(float t, @NotNull PointF point) {
        Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
        this.setTranslationX(LanguageUtils.isRtl() ? -point.x : point.x);
        this.setTranslationY(point.y);
        this.setAlpha(t < 0.128f ? 1.0f : (t < 0.8f ? 1.0f - (t - 0.128f) / 0.8f : 0.0f));
        float scale = t < 0.02f ? 0.3f + 0.7f * t / 0.02f : (t < 0.04f ? 1.0f + 0.5f * (t - 0.02f) / 0.02f : (t < 0.16f ? 1.5f - 0.5f * (t - 0.04f) / 0.12f : 1.0f - 0.39999998f * (t - 0.16f) / 0.84000003f));
        this.setScaleX(scale);
        this.setScaleY(scale);
    }

    private final PointF[] getBezierPoint(boolean statusBarTranslucent) {
        PointF[] pointFArray;
        int random = Random.Default.nextInt(5);
        ScreenUtils screenUtils = ScreenUtils.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)screenUtils, (String)"ScreenUtils.getInstance()");
        int animTotalHeight = screenUtils.getHeightPixels() * 3 / 5;
        int dp100 = CommonExtensionsKt.dp2Px((Number)50).intValue();
        int transparentStatusHeight = statusBarTranslucent ? SystemUtils.getStatusBarHeight((Context)this.getContext()) : 0;
        ScreenUtils screenUtils2 = ScreenUtils.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)screenUtils2, (String)"ScreenUtils.getInstance()");
        float f = screenUtils2.getWidthPixels() - CommonExtensionsKt.dp2Px((Number)50).intValue() - dp100;
        ScreenUtils screenUtils3 = ScreenUtils.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)screenUtils3, (String)"ScreenUtils.getInstance()");
        PointF startPoint = new PointF(f, (float)(screenUtils3.getHeightPixels() - CommonExtensionsKt.dp2Px((Number)70).intValue() + transparentStatusHeight));
        switch (random) {
            case 0: {
                PointF[] pointFArray2 = new PointF[4];
                pointFArray2[0] = new PointF(startPoint.x + (float)dp100, startPoint.y);
                pointFArray2[1] = new PointF(startPoint.x, startPoint.y - (float)(animTotalHeight * 500 / 1200));
                pointFArray2[2] = new PointF(startPoint.x + CommonExtensionsKt.dp2Px((Number)110).floatValue(), startPoint.y - (float)(animTotalHeight * 790 / 1200));
                pointFArray = pointFArray2;
                pointFArray2[3] = new PointF(startPoint.x + (float)dp100, startPoint.y - (float)animTotalHeight);
                break;
            }
            case 1: {
                PointF[] pointFArray3 = new PointF[4];
                pointFArray3[0] = new PointF(startPoint.x + (float)dp100, startPoint.y);
                pointFArray3[1] = new PointF(startPoint.x + CommonExtensionsKt.dp2Px((Number)105).floatValue(), startPoint.y - (float)(animTotalHeight * 490 / 1200));
                pointFArray3[2] = new PointF(startPoint.x, startPoint.y - (float)(animTotalHeight * 820 / 1200));
                pointFArray = pointFArray3;
                pointFArray3[3] = new PointF(startPoint.x + CommonExtensionsKt.dp2Px((Number)60).floatValue(), startPoint.y - (float)animTotalHeight);
                break;
            }
            case 2: {
                PointF[] pointFArray4 = new PointF[4];
                pointFArray4[0] = new PointF(startPoint.x + (float)dp100, startPoint.y);
                pointFArray4[1] = new PointF(startPoint.x + CommonExtensionsKt.dp2Px((Number)35).floatValue(), startPoint.y - (float)(animTotalHeight * 370 / 1200));
                pointFArray4[2] = new PointF(startPoint.x + CommonExtensionsKt.dp2Px((Number)25).floatValue(), startPoint.y - (float)(animTotalHeight * 880 / 1200));
                pointFArray = pointFArray4;
                pointFArray4[3] = new PointF(startPoint.x + CommonExtensionsKt.dp2Px((Number)55).floatValue(), startPoint.y - (float)animTotalHeight);
                break;
            }
            case 3: {
                PointF[] pointFArray5 = new PointF[4];
                pointFArray5[0] = new PointF(startPoint.x + (float)dp100, startPoint.y);
                pointFArray5[1] = new PointF(startPoint.x, startPoint.y - (float)(animTotalHeight * 370 / 1200));
                pointFArray5[2] = new PointF(startPoint.x + CommonExtensionsKt.dp2Px((Number)90).floatValue(), startPoint.y - (float)(animTotalHeight * 720 / 1200));
                pointFArray = pointFArray5;
                pointFArray5[3] = new PointF(startPoint.x + CommonExtensionsKt.dp2Px((Number)42).floatValue(), startPoint.y - (float)(animTotalHeight * 1150 / 1200));
                break;
            }
            case 4: {
                PointF[] pointFArray6 = new PointF[4];
                pointFArray6[0] = new PointF(startPoint.x + (float)dp100, startPoint.y);
                pointFArray6[1] = new PointF(startPoint.x + CommonExtensionsKt.dp2Px((Number)95).floatValue(), startPoint.y - (float)(animTotalHeight * 450 / 1200));
                pointFArray6[2] = new PointF(startPoint.x + CommonExtensionsKt.dp2Px((Number)55).floatValue(), startPoint.y - (float)(animTotalHeight * 1010 / 1200));
                pointFArray = pointFArray6;
                pointFArray6[3] = new PointF(startPoint.x + CommonExtensionsKt.dp2Px((Number)62).floatValue(), startPoint.y - (float)animTotalHeight);
                break;
            }
            default: {
                PointF[] pointFArray7 = new PointF[4];
                pointFArray7[0] = new PointF(startPoint.x + (float)dp100, startPoint.y);
                pointFArray7[1] = new PointF(startPoint.x + CommonExtensionsKt.dp2Px((Number)95).floatValue(), startPoint.y - (float)(animTotalHeight * 450 / 1200));
                pointFArray7[2] = new PointF(startPoint.x + CommonExtensionsKt.dp2Px((Number)55).floatValue(), startPoint.y - (float)(animTotalHeight * 1010 / 1200));
                pointFArray = pointFArray7;
                pointFArray7[3] = new PointF(startPoint.x + CommonExtensionsKt.dp2Px((Number)62).floatValue(), startPoint.y - (float)animTotalHeight);
            }
        }
        return pointFArray;
    }

    public BubbleView(@Nullable Context context, @Nullable SimpleAnimatorListener animListener) {
        super(context, animListener);
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/bubble/widget/BubbleView$Companion;", "", "()V", "DURATION", "", "SCALE_STATE_1", "", "SCALE_STATE_2", "SCALE_STATE_3", "SCALE_STATE_4", "SCALE_TARGET_1", "SCALE_TARGET_2", "SCALE_TARGET_3", "SCALE_TARGET_4", "START_ALPHA_STATE", "START_DISMISS_STATE", "START_SCALE", "TAG", "", "createBubble", "Lcom/yy/hiyo/channel/plugins/radio/bubble/widget/BubbleView;", "context", "Landroid/content/Context;", "animListener", "Lcom/yy/appbase/callback/SimpleAnimatorListener;", "radio_debug"})
    public static final class Companion {
        @NotNull
        public final BubbleView createBubble(@Nullable Context context, @Nullable SimpleAnimatorListener animListener) {
            int bubbleSize = DensityUtil.dp2px((float)40.0f);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(bubbleSize, bubbleSize);
            BubbleView bubbleView = new BubbleView(context, animListener);
            bubbleView.setLayoutParams((ViewGroup.LayoutParams)lp);
            return bubbleView;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

