/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.os.Bundle;
import android.os.Message;
import android.view.View;
import android.view.ViewGroup;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.bbs.base.BBSUtils;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.cbase.publicscreen.msg.VideoMsg;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgTitleBarHolder;
import org.jetbrains.annotations.NotNull;

public final class VideoHolder
extends AbsMsgTitleBarHolder<VideoMsg> {
    private RecycleImageView ivImage;
    private YYTextView durationTv;
    private View[] mViews = new View[2];

    public VideoHolder(@NotNull View v, boolean self) {
        super(v, self);
        this.ivImage = (RecycleImageView)this.itemView.findViewById(R.id.coverIv);
        this.durationTv = (YYTextView)this.itemView.findViewById(R.id.durationTv);
        this.mViews[0] = this.itemView;
        this.mViews[1] = this.ivImage;
        this.ivImage.setOnClickListener(v1 -> {
            VideoMsg videoMsg = (VideoMsg)this.getItemMsg();
            if (videoMsg == null) {
                return;
            }
            Message msg = Message.obtain();
            Bundle bundle = new Bundle();
            msg.what = AppbaseMsgDef.MSG_OPEN_VIDEO_PREVIEW_WINDOW;
            if (FP.empty((CharSequence)videoMsg.getVideoUrl())) {
                bundle.putString("url", videoMsg.getLocalPath());
                bundle.putInt("dataSource", 2);
            } else {
                bundle.putString("url", videoMsg.getVideoUrl());
                bundle.putInt("dataSource", 100);
            }
            bundle.putString("cover_url", videoMsg.getCoverUrl());
            bundle.putFloat("width", (float)videoMsg.getWidth());
            bundle.putFloat("height", (float)videoMsg.getHeight());
            bundle.putBoolean("close_channel", false);
            msg.obj = bundle;
            MsgDispatcher.getInstance().sendMessage(msg);
        });
    }

    @KvoMethodAnnotation(name="dataChange", sourceClass=VideoMsg.class, thread=1)
    public final void onDataChange(@NotNull KvoEventIntent event) {
        VideoMsg msg = (VideoMsg)this.getItemMsg();
        if (null == msg) {
            return;
        }
        if (this.ivImage != null) {
            this.updateSize(msg);
            if (StringUtils.isNotEmpty((String)msg.getLocalCoverPath())) {
                ImageLoader.loadImage((RecycleImageView)this.ivImage, (String)msg.getLocalCoverPath(), (int)R.drawable.icon_img1_default);
                return;
            }
            String url = msg.getCoverUrl();
            if (StringUtils.isNotEmpty((String)url)) {
                url = url + YYImageUtils.getThumbnailPostfix((int)75);
            }
            ImageLoader.loadImage((RecycleImageView)this.ivImage, (String)url, (int)R.drawable.icon_img1_default);
        }
        if (this.durationTv != null) {
            this.durationTv.setText((CharSequence)BBSUtils.INSTANCE.formatVideoTime(Integer.valueOf((int)(msg.getDuration() / 1000L))));
        }
    }

    @Override
    public void bindView(@NotNull VideoMsg newData, int position) {
        super.bindView(newData, position);
    }

    private void updateSize(VideoMsg msg) {
        ViewGroup.LayoutParams lp;
        ViewGroup.LayoutParams layoutParams = lp = this.ivImage != null ? this.ivImage.getLayoutParams() : null;
        if (lp != null) {
            int width = msg.getWidth();
            int height = msg.getHeight();
            if (width == 0 || height == 0) {
                width = ChannelDefine.MAX_VIDEO_SIZE;
                height = ChannelDefine.MAX_VIDEO_SIZE;
            } else {
                float aspectRatio = (float)width / (float)height;
                if (width >= height) {
                    width = ChannelDefine.MAX_VIDEO_SIZE;
                    height = (int)((float)width / aspectRatio);
                } else {
                    height = ChannelDefine.MAX_VIDEO_SIZE;
                    width = (int)((float)height * aspectRatio);
                }
            }
            lp.width = width;
            lp.height = height;
        }
    }

    @KvoMethodAnnotation(name="localCoverPath", sourceClass=VideoMsg.class, thread=1)
    public final void onLocalCoverPath(@NotNull KvoEventIntent event) {
        VideoMsg msg = (VideoMsg)this.getItemMsg();
        if (this.ivImage != null && msg != null && StringUtils.isNotEmpty((String)msg.getLocalCoverPath())) {
            this.updateSize(msg);
            ImageLoader.loadImage((RecycleImageView)this.ivImage, (String)msg.getLocalCoverPath());
        }
    }

    @Override
    protected View[] getLongClickView() {
        return this.mViews;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.mBinder.clearAllKvoConnections();
    }
}

