/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.graphics.Paint;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcelable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.style.LeadingMarginSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.yy.appbase.data.ViewDimension;
import com.yy.appbase.ui.widget.FlowLayout;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.HyperLinkConfig;
import com.yy.appbase.unifyconfig.config.HyperLinkConfigData;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.channel.cbase.publicscreen.msg.ImageMsg;
import com.yy.hiyo.channel.cbase.publicscreen.msg.PureTextMsg;
import com.yy.hiyo.channel.cbase.publicscreen.msg.TextImageMsg;
import com.yy.hiyo.channel.component.base.util.HyperLinkUtil;
import com.yy.hiyo.channel.component.base.util.PrivilegeHelper;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgTitleBarHolder;
import com.yy.hiyo.component.publicscreen.theme.IThemeSimplify;
import com.yy.hiyo.component.publicscreen.widge.BaseUserTitleView;
import com.yy.hiyo.wallet.base.privilege.bean.ChatBubbleConfig;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class TextImageHolder
extends AbsMsgTitleBarHolder<TextImageMsg> {
    private BaseUserTitleView titleView;
    private RecycleImageView ivImage;
    private RecycleImageView ivLogo;
    private YYTextView tvText;
    private View[] mViews = new View[3];
    private Runnable updateTextTask;
    private static final int MARGIN_TOP_BASE = ResolutionUtils.dip2Px((float)0.0f);
    private static final int MARGIN_TOP_VOICE = ResolutionUtils.dip2Px((float)2.0f);
    private final int marginHorizon = ResolutionUtils.dip2Px((float)0.0f);
    private static final int CONTENT_MARGIN = ResolutionUtils.dip2Px((float)10.0f);

    public TextImageHolder(@NotNull View v, boolean self) {
        super(v, self);
        this.titleView = (BaseUserTitleView)this.itemView.findViewById(R.id.butv_c);
        this.ivImage = (RecycleImageView)this.itemView.findViewById(R.id.iv_c_img);
        this.ivLogo = (RecycleImageView)this.itemView.findViewById(R.id.iv_logo);
        this.tvText = (YYTextView)this.itemView.findViewById(R.id.tv_c_text);
        this.mViews[0] = this.itemView;
        this.mViews[1] = this.ivImage;
        this.mViews[2] = this.tvText;
        this.tvText.setOnClickListener(v1 -> {
            if (this.mActionHandler != null) {
                Message msg = Message.obtain();
                msg.obj = this.getItemMsg();
                msg.what = ActionDefine.CLICK_PURE_TEXT_MSG;
                this.mActionHandler.onAction(msg);
            }
        });
        this.ivImage.setOnClickListener(v1 -> {
            TextImageMsg textImageMsg = (TextImageMsg)this.getItemMsg();
            if (textImageMsg == null || this.mActionHandler == null) {
                return;
            }
            Message msg = Message.obtain();
            msg.what = ActionDefine.CLICK_IMAGE;
            Bundle bundle = new Bundle();
            bundle.putParcelable("view_dimension", (Parcelable)new ViewDimension(v1));
            bundle.putString("localPath", textImageMsg.getImageMsg().getLocalPath());
            bundle.putString("imageUrl", textImageMsg.getImageMsg().getImageUrl());
            bundle.putString("msgId", textImageMsg.getMsgId());
            msg.obj = bundle;
            this.mActionHandler.onAction(msg);
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "hago_share_link_click").put("share_content_type", "1"));
        });
        this.updateTextTask = () -> {
            if (this.getItemMsg() != null && null != ((TextImageMsg)this.getItemMsg()).getTextMsg() && ((TextImageMsg)this.getItemMsg()).getTextMsg().getMsgText() != null) {
                this.updateText(this.mThemeRes instanceof IThemeSimplify, ((TextImageMsg)this.getItemMsg()).getTextMsg().getMsgText());
            }
        };
        this.titleView.setOnMeasuredListener((w, h) -> {
            if (this.mThemeRes != null && this.titleView.getFlowLayout().getRowsCount() > 0) {
                this.updateTextTask();
            }
        });
    }

    private void updateTextTask() {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.updateTextTask);
        YYTaskExecutor.postToMainThread((Runnable)this.updateTextTask, (long)100L);
    }

    @KvoMethodAnnotation(name="dataChange", sourceClass=TextImageMsg.class, thread=1)
    public final void onDataChange(@NotNull KvoEventIntent event) {
        TextImageMsg msg = (TextImageMsg)this.getItemMsg();
        if (msg != null) {
            if (null != msg.getTextMsg()) {
                this.updateTextSection(msg.getTextMsg());
            }
            if (null != msg.getImageMsg()) {
                this.updateImageSection(msg.getImageMsg());
            }
        }
    }

    @Override
    public void bindView(@NotNull TextImageMsg newData, int position) {
        super.bindView(newData, position);
        this.ivLogo.setVisibility(newData.getImageMsg().getUrlFrom() == 1 ? 0 : 8);
        if (newData.getImageMsg().isShareImage()) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "hago_share_link_show").put("share_content_type", "1"));
        }
    }

    private void updateTextSection(PureTextMsg textMsg) {
        if (this.tvText != null) {
            this.tvText.setAutoLinkMask(0);
            if (this.mThemeRes != null && this.mThemeRes.getCurrentMode() == 1) {
                AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.HYPER_LINK_INTERCEPT_CONFIG);
                if (configData instanceof HyperLinkConfig) {
                    HyperLinkConfigData data = ((HyperLinkConfig)configData).getData();
                    if (data == null || data.getEnableHyperLink()) {
                        this.tvText.setAutoLinkMask(1);
                    }
                } else {
                    this.tvText.setAutoLinkMask(1);
                }
            }
            if (this.mThemeRes != null && this.mThemeRes.getThemePackage("msg_text") != null && this.mThemeRes.getThemePackage("msg_text").getTextLinkColor() != 0) {
                this.tvText.setLinkTextColor(this.mThemeRes.getThemePackage("msg_text").getTextLinkColor());
            }
            if (this.mThemeRes != null && this.mThemeRes.getCurrentMode() == 1) {
                HyperLinkUtil.INSTANCE.interceptHyperLink((TextView)this.tvText, null);
            }
            this.updateTextTask();
        }
    }

    private void updateImageSection(ImageMsg imageMsg) {
        this.updateSize(imageMsg);
        if (StringUtils.isNotEmpty((String)imageMsg.getLocalPath())) {
            ImageLoader.loadImage((RecycleImageView)this.ivImage, (String)imageMsg.getLocalPath(), (int)R.drawable.icon_img1_default);
            return;
        }
        String url = null;
        url = StringUtils.isNotEmpty((String)imageMsg.getNanoUrl()) ? imageMsg.getNanoUrl() : imageMsg.getImageUrl();
        if (StringUtils.isNotEmpty((String)url) && !ImageUtil.isGif((String)url)) {
            url = url + YYImageUtils.getThumbnailPostfix((int)75);
        }
        ImageLoader.loadImage((RecycleImageView)this.ivImage, (String)url, (int)R.drawable.icon_img1_default);
    }

    private final void updateSize(ImageMsg msg) {
        ViewGroup.LayoutParams lp;
        ViewGroup.LayoutParams layoutParams = lp = this.ivImage != null ? this.ivImage.getLayoutParams() : null;
        if (lp != null) {
            int high;
            int width = msg.getWidth();
            float aspectRatio = (float)width / (float)(high = msg.getHigh());
            if (aspectRatio >= 1.77f) {
                float scale = (float)ChannelDefine.MAX_PIC_SIZE / (float)width;
                high = (int)((float)high * scale);
                width = ChannelDefine.MAX_PIC_SIZE;
            } else if (aspectRatio <= 0.56f) {
                float scale = (float)ChannelDefine.MAX_PIC_SIZE / (float)high;
                width = (int)((float)width * scale);
                high = ChannelDefine.MAX_PIC_SIZE;
            } else if (aspectRatio <= 1.33f && aspectRatio >= 0.75f) {
                high = ChannelDefine.DEFAULT_PIC_SIZE;
                width = ChannelDefine.DEFAULT_PIC_SIZE;
            } else if (aspectRatio > 0.56f && aspectRatio < 1.77f) {
                width = (int)((float)ResolutionUtils.dip2Px((float)width) * msg.getScale());
                high = (int)((float)ResolutionUtils.dip2Px((float)high) * msg.getScale());
            } else {
                high = ChannelDefine.DEFAULT_PIC_SIZE;
                width = ChannelDefine.DEFAULT_PIC_SIZE;
            }
            lp.width = width;
            lp.height = high;
        }
    }

    private void updateText(boolean simplify, CharSequence msgText) {
        if (msgText == null || msgText.length() == 0) {
            return;
        }
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.tvText.getLayoutParams();
        if (simplify) {
            FlowLayout flowLayout = this.titleView.getFlowLayout();
            int itemSpace = flowLayout.getChildSpacing();
            List rows = flowLayout.getChildNumForRow();
            int totalWidth = 0;
            int topOffset = 0;
            if (rows.size() > 0) {
                int maxHeight = flowLayout.getHeightForRow(rows.size() - 1);
                Paint.FontMetrics metrics = this.tvText.getPaint().getFontMetrics();
                int textHeight = (int)(metrics.descent - metrics.ascent);
                topOffset = rows.size() > 1 ? maxHeight - (maxHeight - textHeight) / 2 : maxHeight - (maxHeight - textHeight) / 2;
                int from = flowLayout.getChildCount() - (Integer)rows.get(rows.size() - 1);
                int to = flowLayout.getChildCount();
                for (int i = from; i < to; ++i) {
                    View child = flowLayout.getChildAt(i);
                    if (child == null) continue;
                    totalWidth += child.getMeasuredWidth() + itemSpace;
                }
            } else {
                totalWidth = flowLayout.getMeasuredWidth();
            }
            params.topMargin = -topOffset;
            params.leftMargin = CONTENT_MARGIN;
            params.rightMargin = CONTENT_MARGIN;
            params.setMarginStart(CONTENT_MARGIN);
            float spaceWidth = this.tvText.getPaint().measureText(" ");
            SpannableString spannableString = new SpannableString(msgText);
            LeadingMarginSpan.Standard leadingMarginSpan = new LeadingMarginSpan.Standard(this.getLeadWidth(totalWidth, spaceWidth), 0);
            spannableString.setSpan((Object)leadingMarginSpan, 0, spannableString.length(), 18);
            this.tvText.setText((CharSequence)spannableString);
        } else {
            boolean isBaseMode;
            boolean bl = isBaseMode = this.mThemeRes != null && this.mThemeRes.getCurrentMode() == 1;
            if (isBaseMode) {
                if (this.self) {
                    params.setMarginStart(CONTENT_MARGIN);
                    params.leftMargin = CONTENT_MARGIN;
                    params.rightMargin = this.marginHorizon;
                    params.setMarginEnd(this.marginHorizon);
                } else {
                    params.setMarginStart(this.marginHorizon);
                    params.leftMargin = this.marginHorizon;
                    params.rightMargin = CONTENT_MARGIN;
                    params.setMarginEnd(CONTENT_MARGIN);
                }
                params.topMargin = MARGIN_TOP_BASE;
            } else {
                params.setMarginStart(this.marginHorizon + CONTENT_MARGIN);
                params.leftMargin = this.marginHorizon + CONTENT_MARGIN;
                params.rightMargin = CONTENT_MARGIN;
                params.setMarginEnd(CONTENT_MARGIN);
                params.topMargin = MARGIN_TOP_VOICE;
            }
            this.tvText.setText(this.appendSpace(msgText));
        }
    }

    private int getLeadWidth(int width, float span) {
        if (this.hasContentBg()) {
            return (int)((float)width + span * 3.0f);
        }
        return width;
    }

    private CharSequence appendSpace(CharSequence text) {
        if (this.hasContentBg()) {
            return SpannableStringBuilder.valueOf((CharSequence)text).append((CharSequence)" ").append((CharSequence)" ").append((CharSequence)" ");
        }
        return text;
    }

    private boolean hasContentBg() {
        long from = this.getFromUid();
        ChatBubbleConfig chatBubbleConfig = PrivilegeHelper.INSTANCE.getChatBubbleConfig(from);
        if (from > 0L && chatBubbleConfig != null && this.mChannelMode != 1) {
            String url = StringUtils.isEmpty((String)chatBubbleConfig.getNewUrl()) ? chatBubbleConfig.getUrl() : chatBubbleConfig.getNewUrl();
            return !FP.empty((CharSequence)url);
        }
        return false;
    }

    @Override
    protected View[] getLongClickView() {
        return this.mViews;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.mBinder.clearAllKvoConnections();
    }
}

