/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.os.Message;
import android.text.SpannableString;
import android.text.style.LeadingMarginSpan;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgItemHolder;
import com.yy.hiyo.component.publicscreen.msg.PacketMsg;
import com.yy.hiyo.component.publicscreen.theme.IThemeRes;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.PacketChatMsg;

public class PacketMsgHolder
extends AbsMsgItemHolder<PacketMsg> {
    private CircleImageView ivHead;
    private YYTextView tvContent;

    public PacketMsgHolder(@NonNull View itemView) {
        super(itemView, false);
        this.ivHead = (CircleImageView)itemView.findViewById(R.id.iv_c_head);
        this.tvContent = (YYTextView)itemView.findViewById(R.id.tv_c_text);
        RecycleImageView ivPacket = (RecycleImageView)itemView.findViewById(R.id.iv_packet);
        if ("ae".equalsIgnoreCase(AccountUtil.registerCountry()) || "id".equalsIgnoreCase(AccountUtil.registerCountry())) {
            ivPacket.setImageResource(R.drawable.green_packet_public_chat);
        } else {
            ivPacket.setImageResource(R.drawable.packet_public_chat);
        }
        ViewGroup.LayoutParams params = this.ivHead.getLayoutParams();
        params.width = ResolutionUtils.dip2Px((float)25.0f);
        params.height = ResolutionUtils.dip2Px((float)25.0f);
        this.ivHead.requestLayout();
        this.ivHead.setOnClickListener(v -> {
            if (this.mActionHandler != null) {
                Message msg = Message.obtain();
                msg.what = ActionDefine.SHOW_USER_PROFILE;
                msg.obj = ((PacketMsg)((Object)((Object)this.getItemMsg()))).getFrom();
                this.mActionHandler.onAction(msg);
            }
        });
        itemView.setOnClickListener(v -> {
            PacketChatMsg.OnClickListener listener2;
            PacketChatMsg.OnClickListener onClickListener = listener2 = ((PacketMsg)((Object)((Object)this.getItemMsg()))).getPacketMsg() != null ? ((PacketMsg)((Object)((Object)this.getItemMsg()))).getPacketMsg().getListener() : null;
            if (listener2 != null) {
                listener2.onClick(((PacketMsg)((Object)((Object)this.getItemMsg()))).getPacketMsg());
            }
        });
    }

    @Override
    public void bindView(PacketMsg newData, int position) {
        super.bindView(newData, position);
        PacketChatMsg packetMsg = newData.getPacketMsg();
        if (packetMsg != null) {
            ImageLoader.loadImage((RecycleImageView)this.ivHead, (String)packetMsg.getIconUrl(), (int)packetMsg.getDefaultIconRes());
            int indentDistance = this.tvContent.getContext().getResources().getDimensionPixelSize(R.dimen.dp_30);
            SpannableString spannableString = new SpannableString(packetMsg.getMessage());
            LeadingMarginSpan.Standard what = new LeadingMarginSpan.Standard(indentDistance, 0);
            spannableString.setSpan((Object)what, 0, spannableString.length(), 18);
            this.tvContent.setText((CharSequence)spannableString);
        }
    }

    @Override
    protected void updateThemeAvatar(IThemeRes themeRes, boolean avatarVisible) {
        super.updateThemeAvatar(themeRes, avatarVisible);
        this.ivHead.setVisibility(avatarVisible ? 0 : 8);
    }
}

