/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.panel.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.ResolutionUtils;

public class MicUpCircleProgressBar
extends YYView {
    private Paint mCirclePaint = new Paint(1);
    private float mStartAngle = -90.0f;
    private float sweepAngle = 0.0f;
    private float strokeWidth = ResolutionUtils.dip2Px((float)4.0f);
    int mRealWidth;
    private float mCircleRadius;
    private RectF mCirclrRectF = new RectF();
    private int mCurrentProgress;

    public MicUpCircleProgressBar(Context context) {
        this(context, null, 0);
    }

    public MicUpCircleProgressBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MicUpCircleProgressBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        float centerWidth = ResolutionUtils.dip2Px((float)68.0f);
        this.resetCircleBarSize(centerWidth, false);
        this.init();
    }

    public void updateProgress(int current, int total) {
        this.mCurrentProgress = current;
        this.sweepAngle = total == 0 ? 0.0f : (float)(current * 360 / total);
        this.invalidate();
    }

    public int getProgress() {
        return this.mCurrentProgress;
    }

    private void init() {
        this.mCirclePaint.setColor(Color.parseColor((String)"#FFFFDE3B"));
        this.mCirclePaint.setStyle(Paint.Style.STROKE);
        this.mCirclePaint.setStrokeWidth(this.strokeWidth);
        this.mCirclePaint.setStrokeCap(Paint.Cap.SQUARE);
    }

    public void resetCircleBarSize(float centerWidth, boolean needInvalidate) {
        this.mCircleRadius = centerWidth / 2.0f;
        this.mRealWidth = (int)(centerWidth + this.strokeWidth);
        if (needInvalidate) {
            this.invalidate();
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.mRealWidth, this.mRealWidth);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mCirclrRectF.set(this.strokeWidth / 2.0f, this.strokeWidth / 2.0f, this.mCircleRadius * 2.0f + this.strokeWidth / 2.0f, this.mCircleRadius * 2.0f + this.strokeWidth / 2.0f);
        canvas.drawArc(this.mCirclrRectF, this.mStartAngle, this.sweepAngle, false, this.mCirclePaint);
    }
}

